/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.sources.jrds.adapters;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.dialogs.DataAdapterDialog;
import eu.fthevenet.binjr.sources.jrds.adapters.JrdsDataAdapter;
import eu.fthevenet.binjr.sources.jrds.adapters.JrdsTreeViewTab;
import java.time.ZoneId;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class JrdsAdapterDialog
extends DataAdapterDialog {
    private final ChoiceBox<JrdsTreeViewTab> tabsChoiceBox;
    private final TextField extraArgumentTextField;

    public JrdsAdapterDialog(Node owner) {
        super(owner, DataAdapterDialog.Mode.URL);
        this.parent.setHeaderText("Connect to a JRDS source");
        this.tabsChoiceBox = new ChoiceBox();
        this.tabsChoiceBox.getItems().addAll((Object[])JrdsTreeViewTab.values());
        this.extraArgumentTextField = new TextField();
        HBox.setHgrow((Node)this.extraArgumentTextField, (Priority)Priority.ALWAYS);
        HBox hBox = new HBox(new Node[]{this.tabsChoiceBox, this.extraArgumentTextField});
        hBox.setSpacing(10.0);
        GridPane.setConstraints((Node)hBox, (int)1, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS, (Insets)new Insets(4.0, 0.0, 4.0, 0.0));
        this.tabsChoiceBox.getSelectionModel().select((Object)JrdsTreeViewTab.HOSTS_TAB);
        Label tabsLabel = new Label("Sorted By:");
        GridPane.setConstraints((Node)tabsLabel, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS, (Insets)new Insets(4.0, 0.0, 4.0, 0.0));
        this.paramsGridPane.getChildren().addAll((Object[])new Node[]{tabsLabel, hBox});
        this.extraArgumentTextField.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((JrdsTreeViewTab)((Object)((Object)this.tabsChoiceBox.valueProperty().get()))).getArgument() != null, (Observable[])new Observable[]{this.tabsChoiceBox.valueProperty()}));
    }

    protected DataAdapter getDataAdapter() throws DataAdapterException {
        return JrdsDataAdapter.fromUrl(this.uriField.getText(), ZoneId.of(this.timezoneField.getText()), (JrdsTreeViewTab)((Object)this.tabsChoiceBox.getValue()), this.extraArgumentTextField.getText());
    }
}

