/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.sources.jrds.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.adapters.HttpDataAdapterBase;
import eu.fthevenet.binjr.data.adapters.TimeSeriesBinding;
import eu.fthevenet.binjr.data.codec.CsvDecoder;
import eu.fthevenet.binjr.data.exceptions.CannotInitializeDataAdapterException;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.data.exceptions.InvalidAdapterParameterException;
import eu.fthevenet.binjr.data.exceptions.SourceCommunicationException;
import eu.fthevenet.binjr.data.timeseries.DoubleTimeSeriesProcessor;
import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.sources.jrds.adapters.Graphdesc;
import eu.fthevenet.binjr.sources.jrds.adapters.JrdsSeriesBindingFactory;
import eu.fthevenet.binjr.sources.jrds.adapters.JrdsTreeViewTab;
import eu.fthevenet.binjr.sources.jrds.adapters.json.JsonJrdsItem;
import eu.fthevenet.binjr.sources.jrds.adapters.json.JsonJrdsTree;
import eu.fthevenet.util.xml.XmlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.transform.Source;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class JrdsDataAdapter
extends HttpDataAdapterBase<Double, CsvDecoder<Double>> {
    private static final Logger logger = LogManager.getLogger(JrdsDataAdapter.class);
    private static final char DELIMITER = ',';
    public static final String JRDS_FILTER = "filter";
    public static final String JRDS_TREE = "tree";
    protected static final String ENCODING_PARAM_NAME = "encoding";
    protected static final String ZONE_ID_PARAM_NAME = "zoneId";
    protected static final String TREE_VIEW_TAB_PARAM_NAME = "treeViewTab";
    private final JrdsSeriesBindingFactory bindingFactory = new JrdsSeriesBindingFactory();
    private static final Pattern uriSchemePattern = Pattern.compile("^[a-zA-Z]*://");
    private String filter;
    private ZoneId zoneId;
    private String encoding;
    private JrdsTreeViewTab treeViewTab;

    public JrdsDataAdapter() throws DataAdapterException {
    }

    public JrdsDataAdapter(URL baseURL, ZoneId zoneId, String encoding, JrdsTreeViewTab treeViewTab, String filter) throws DataAdapterException {
        super(baseURL);
        this.zoneId = zoneId;
        this.encoding = encoding;
        this.treeViewTab = treeViewTab;
        this.filter = filter;
    }

    public static JrdsDataAdapter fromUrl(String address, ZoneId zoneId, JrdsTreeViewTab treeViewTab, String filter) throws DataAdapterException {
        try {
            URL url;
            if (!uriSchemePattern.matcher(address).find()) {
                address = "http://" + address;
            }
            if ((url = new URL(address.trim())).getHost().trim().isEmpty()) {
                throw new CannotInitializeDataAdapterException("Malformed URL: no host");
            }
            return new JrdsDataAdapter(url, zoneId, "utf-8", treeViewTab, filter);
        }
        catch (MalformedURLException e) {
            throw new CannotInitializeDataAdapterException("Malformed URL: " + e.getMessage(), e);
        }
    }

    @Override
    public TreeItem<TimeSeriesBinding<Double>> getBindingTree() throws DataAdapterException {
        Gson gson = new Gson();
        try {
            JsonJrdsTree t = (JsonJrdsTree)gson.fromJson(this.getJsonTree(this.treeViewTab.getCommand(), this.treeViewTab.getArgument(), this.filter), JsonJrdsTree.class);
            Map<String, JsonJrdsItem> m = Arrays.stream(t.items).collect(Collectors.toMap(o -> o.id, o -> o));
            TreeItem tree = new TreeItem(this.bindingFactory.of("", this.getSourceName(), "/", this));
            for (JsonJrdsItem branch : Arrays.stream(t.items).filter(jsonJrdsItem -> JRDS_TREE.equals(jsonJrdsItem.type) || JRDS_FILTER.equals(jsonJrdsItem.type)).collect(Collectors.toList())) {
                this.attachNode((TreeItem<TimeSeriesBinding<Double>>)tree, branch.id, m);
            }
            return tree;
        }
        catch (JsonParseException e) {
            throw new DataAdapterException("An error occurred while parsing the json response to getBindingTree request", e);
        }
        catch (URISyntaxException e) {
            throw new SourceCommunicationException("Error building URI for request", e);
        }
    }

    @Override
    protected URI craftFetchUri(String path, Instant begin, Instant end) throws DataAdapterException {
        return this.craftRequestUri("download", new NameValuePair[]{new BasicNameValuePair("id", path), new BasicNameValuePair("begin", Long.toString(begin.toEpochMilli())), new BasicNameValuePair("end", Long.toString(end.toEpochMilli()))});
    }

    @Override
    public String getSourceName() {
        return "[JRDS] " + (this.getBaseAddress() != null ? this.getBaseAddress().getHost() : "???") + (this.getBaseAddress() != null && this.getBaseAddress().getPort() > 0 ? ":" + this.getBaseAddress().getPort() : "") + " - " + (this.treeViewTab != null ? this.treeViewTab : "???") + (this.filter != null ? this.filter : "") + " (" + (this.zoneId != null ? this.zoneId : "???") + ")";
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>(super.getParams());
        params.put(ZONE_ID_PARAM_NAME, this.zoneId.toString());
        params.put(ENCODING_PARAM_NAME, this.encoding);
        params.put(TREE_VIEW_TAB_PARAM_NAME, this.treeViewTab.name());
        params.put(JRDS_FILTER, this.filter);
        return params;
    }

    @Override
    public void loadParams(Map<String, String> params) throws DataAdapterException {
        if (params == null) {
            throw new InvalidAdapterParameterException("Could not find parameter list for adapter " + this.getSourceName());
        }
        super.loadParams(params);
        this.encoding = this.validateParameterNullity(params, ENCODING_PARAM_NAME);
        this.zoneId = this.validateParameter(params, ZONE_ID_PARAM_NAME, s -> {
            if (s == null) {
                throw new InvalidAdapterParameterException("Parameter zoneId is missing in adapter " + this.getSourceName());
            }
            return ZoneId.of(s);
        });
        this.treeViewTab = this.validateParameter(params, TREE_VIEW_TAB_PARAM_NAME, s -> s == null ? JrdsTreeViewTab.valueOf((String)params.get(TREE_VIEW_TAB_PARAM_NAME)) : JrdsTreeViewTab.HOSTS_TAB);
        this.filter = params.get(JRDS_FILTER);
    }

    @Override
    public boolean ping() {
        try {
            return (Boolean)this.doHttpGet(this.craftRequestUri("", new NameValuePair[0]), new AbstractResponseHandler<Boolean>(){

                public Boolean handleEntity(HttpEntity entity) throws IOException {
                    String entityString = EntityUtils.toString((HttpEntity)entity);
                    logger.trace(entityString);
                    return true;
                }
            });
        }
        catch (Exception e) {
            logger.debug(() -> "Ping failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public ZoneId getTimeZoneId() {
        return this.zoneId;
    }

    @Override
    public CsvDecoder<Double> getDecoder() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(this.getTimeZoneId());
        return new CsvDecoder<Double>(this.getEncoding(), ',', DoubleTimeSeriesProcessor::new, s -> {
            Double val = Double.parseDouble(s);
            return val.isNaN() ? 0.0 : val;
        }, s -> ZonedDateTime.parse(s, formatter));
    }

    @Override
    public void close() {
        super.close();
    }

    public Collection<String> discoverFilters() throws DataAdapterException, URISyntaxException {
        Gson gson = new Gson();
        try {
            JsonJrdsTree t = (JsonJrdsTree)gson.fromJson(this.getJsonTree(this.treeViewTab.getCommand(), this.treeViewTab.getArgument()), JsonJrdsTree.class);
            return Arrays.stream(t.items).filter(jsonJrdsItem -> JRDS_FILTER.equals(jsonJrdsItem.type)).map(i -> i.filter).collect(Collectors.toList());
        }
        catch (JsonParseException e) {
            throw new DataAdapterException("An error occurred while parsing the json response to getBindingTree request", e);
        }
    }

    private void attachNode(TreeItem<TimeSeriesBinding<Double>> tree, String id, Map<String, JsonJrdsItem> nodes) throws DataAdapterException {
        JsonJrdsItem n = nodes.get(id);
        String currentPath = this.normalizeId(n.id);
        TreeItem newBranch = new TreeItem(this.bindingFactory.of(((TimeSeriesBinding)tree.getValue()).getTreeHierarchy(), n.name, currentPath, this));
        if (JRDS_FILTER.equals(n.type)) {
            newBranch.getChildren().add((Object)new TreeItem(null));
            newBranch.expandedProperty().addListener((ChangeListener)new FilteredViewListener(n, (TreeItem<TimeSeriesBinding<Double>>)newBranch));
        } else if (n.children != null) {
            for (JsonJrdsItem.JsonTreeRef ref : n.children) {
                this.attachNode((TreeItem<TimeSeriesBinding<Double>>)newBranch, ref._reference, nodes);
            }
        } else {
            newBranch.getChildren().add((Object)new TreeItem(null));
            newBranch.expandedProperty().addListener((ChangeListener)new GraphDescListener(currentPath, (TreeItem<TimeSeriesBinding<Double>>)newBranch, tree));
        }
        tree.getChildren().add((Object)newBranch);
    }

    private String normalizeId(String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("Argument id cannot be null or blank");
        }
        String[] data = id.split("\\.");
        return data[data.length - 1];
    }

    private String getJsonTree(String tabName, String argName) throws DataAdapterException, URISyntaxException {
        return this.getJsonTree(tabName, argName, null);
    }

    private String getJsonTree(String tabName, String argName, String argValue) throws DataAdapterException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("tab", tabName));
        if (argName != null && argValue != null && argValue.trim().length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair(argName, argValue));
        }
        String entityString = (String)this.doHttpGet(this.craftRequestUri("jsontree", params), new BasicResponseHandler());
        logger.trace(entityString);
        return entityString;
    }

    private Graphdesc getGraphDescriptor(String id) throws DataAdapterException {
        URI requestUri = this.craftRequestUri("graphdesc", new NameValuePair[]{new BasicNameValuePair("id", id)});
        return (Graphdesc)this.doHttpGet(requestUri, response -> {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 404) {
                logger.warn("Cannot found graphdesc service; falling back to legacy mode.");
                try {
                    return this.getGraphDescriptorLegacy(id);
                }
                catch (Exception e) {
                    throw new IOException("", e);
                }
            }
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (entity != null) {
                try {
                    return (Graphdesc)JAXB.unmarshal((Source)XmlUtils.toNonValidatingSAXSource(entity.getContent()), Graphdesc.class);
                }
                catch (Exception e) {
                    throw new IOException("Failed to unmarshall graphdesc response", e);
                }
            }
            return null;
        });
    }

    /*
     * Exception decompiling
     */
    private Graphdesc getGraphDescriptorLegacy(String id) throws DataAdapterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class FilteredViewListener
    implements ChangeListener<Boolean> {
        private final JsonJrdsItem n;
        private final TreeItem<TimeSeriesBinding<Double>> newBranch;

        public FilteredViewListener(JsonJrdsItem n, TreeItem<TimeSeriesBinding<Double>> newBranch) {
            this.n = n;
            this.newBranch = newBranch;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                try {
                    JsonJrdsTree t = (JsonJrdsTree)new Gson().fromJson(JrdsDataAdapter.this.getJsonTree(JrdsDataAdapter.this.treeViewTab.getCommand(), JrdsDataAdapter.JRDS_FILTER, this.n.name), JsonJrdsTree.class);
                    Map<String, JsonJrdsItem> m = Arrays.stream(t.items).collect(Collectors.toMap(o -> o.id, o -> o));
                    for (JsonJrdsItem branch : Arrays.stream(t.items).filter(jsonJrdsItem -> JrdsDataAdapter.JRDS_TREE.equals(jsonJrdsItem.type) || JrdsDataAdapter.JRDS_FILTER.equals(jsonJrdsItem.type)).collect(Collectors.toList())) {
                        JrdsDataAdapter.this.attachNode((TreeItem<TimeSeriesBinding<Double>>)this.newBranch, branch.id, m);
                    }
                    this.newBranch.getChildren().remove(0);
                    this.newBranch.expandedProperty().removeListener((ChangeListener)this);
                }
                catch (Exception e) {
                    Dialogs.notifyException("Failed to retrieve graph description", e);
                }
            }
        }
    }

    private class GraphDescListener
    implements ChangeListener<Boolean> {
        private final String currentPath;
        private final TreeItem<TimeSeriesBinding<Double>> newBranch;
        private final TreeItem<TimeSeriesBinding<Double>> tree;

        public GraphDescListener(String currentPath, TreeItem<TimeSeriesBinding<Double>> newBranch, TreeItem<TimeSeriesBinding<Double>> tree) {
            this.currentPath = currentPath;
            this.newBranch = newBranch;
            this.tree = tree;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                try {
                    Graphdesc graphdesc = JrdsDataAdapter.this.getGraphDescriptor(this.currentPath);
                    this.newBranch.setValue(JrdsDataAdapter.this.bindingFactory.of(((TimeSeriesBinding)this.tree.getValue()).getTreeHierarchy(), ((TimeSeriesBinding)this.newBranch.getValue()).getLegend(), graphdesc, this.currentPath, (DataAdapter<Double, CsvDecoder<Double>>)JrdsDataAdapter.this));
                    for (int i = 0; i < graphdesc.seriesDescList.size(); ++i) {
                        String graphType = graphdesc.seriesDescList.get((int)i).graphType;
                        if ("none".equalsIgnoreCase(graphType) || "comment".equalsIgnoreCase(graphType)) continue;
                        this.newBranch.getChildren().add((Object)new TreeItem(JrdsDataAdapter.this.bindingFactory.of(((TimeSeriesBinding)this.tree.getValue()).getTreeHierarchy(), graphdesc, i, this.currentPath, (DataAdapter<Double, CsvDecoder<Double>>)JrdsDataAdapter.this)));
                    }
                    this.newBranch.getChildren().remove(0);
                    this.newBranch.expandedProperty().removeListener((ChangeListener)this);
                }
                catch (Exception e) {
                    Dialogs.notifyException("Failed to retrieve graph description", e);
                }
            }
        }
    }
}

