/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.sources.jrds.adapters;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.adapters.TimeSeriesBinding;
import eu.fthevenet.binjr.data.codec.CsvDecoder;
import eu.fthevenet.binjr.data.workspace.ChartType;
import eu.fthevenet.binjr.data.workspace.UnitPrefixes;
import eu.fthevenet.binjr.sources.jrds.adapters.Graphdesc;
import javafx.scene.paint.Color;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JrdsSeriesBindingFactory {
    private static final Logger logger = LogManager.getLogger(JrdsSeriesBindingFactory.class);
    private static final UnitPrefixes DEFAULT_PREFIX = UnitPrefixes.BINARY;

    public TimeSeriesBinding<Double> of(String parentName, String label, String path, DataAdapter<Double, CsvDecoder<Double>> adapter) {
        return new TimeSeriesBinding<Double>(label, path, null, label, DEFAULT_PREFIX, ChartType.STACKED, "-", parentName + "/" + label, adapter);
    }

    public TimeSeriesBinding<Double> of(String parentName, String legend, Graphdesc graphdesc, String path, DataAdapter<Double, CsvDecoder<Double>> adapter) {
        String label = this.isNullOrEmpty(graphdesc.name) ? (this.isNullOrEmpty(graphdesc.graphName) ? "???" : graphdesc.graphName) : graphdesc.name;
        ChartType graphType = ChartType.STACKED;
        UnitPrefixes prefix = this.findPrefix(graphdesc);
        String unitName = graphdesc.verticalLabel;
        return new TimeSeriesBinding<Double>(label, path, null, legend, prefix, graphType, unitName, parentName + "/" + legend, adapter);
    }

    public TimeSeriesBinding<Double> of(String parentName, Graphdesc graphdesc, int idx, String path, DataAdapter<Double, CsvDecoder<Double>> adapter) {
        ChartType graphType;
        Graphdesc.SeriesDesc desc = graphdesc.seriesDescList.get(idx);
        String label = this.isNullOrEmpty(desc.name) ? (this.isNullOrEmpty(desc.dsName) ? (this.isNullOrEmpty(desc.legend) ? "???" : desc.legend) : desc.dsName) : desc.name;
        Color c = null;
        try {
            if (!this.isNullOrEmpty(desc.color)) {
                c = Color.web((String)desc.color);
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid color string for binding " + label);
        }
        Color color = c;
        String legend = this.isNullOrEmpty(desc.legend) ? (this.isNullOrEmpty(desc.name) ? (this.isNullOrEmpty(desc.dsName) ? "???" : desc.dsName) : desc.name) : desc.legend;
        switch (desc.graphType.toLowerCase()) {
            case "area": {
                graphType = ChartType.AREA;
                break;
            }
            case "stacked": {
                graphType = ChartType.STACKED;
                break;
            }
            case "line": {
                graphType = ChartType.LINE;
                break;
            }
            default: {
                graphType = ChartType.STACKED;
            }
        }
        UnitPrefixes prefix = this.findPrefix(graphdesc);
        String unitName = graphdesc.verticalLabel;
        return new TimeSeriesBinding<Double>(label, path, color, legend, prefix, graphType, unitName, parentName + "/" + legend, adapter);
    }

    private UnitPrefixes findPrefix(Graphdesc graphdesc) {
        if (graphdesc.unit != null && graphdesc.unit.size() > 0) {
            if (graphdesc.unit.get(0) instanceof Graphdesc.JrdsMetricUnitType) {
                return UnitPrefixes.METRIC;
            }
            if (graphdesc.unit.get(0) instanceof Graphdesc.JrdsBinaryUnitType) {
                return UnitPrefixes.BINARY;
            }
        }
        return DEFAULT_PREFIX;
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

