/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.auth;

import com.sun.security.auth.module.Krb5LoginModule;
import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.util.auth.CredentialsEntry;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.scene.control.Dialog;
import javafx.stage.StageStyle;
import javafx.util.Pair;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.dialog.LoginDialog;

public class JfxKrb5LoginModule
extends Krb5LoginModule {
    private static final Logger logger = LogManager.getLogger(JfxKrb5LoginModule.class);
    private CredentialsEntry credentials = CredentialsEntry.EMPTY;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbacks -> {
            block5: {
                try {
                    this.credentials = this.obtainCredentials(CredentialsEntry.copyOf(this.credentials));
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            NameCallback nc = (NameCallback)callback;
                            nc.setName(this.credentials.getLogin());
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            PasswordCallback pc = (PasswordCallback)callback;
                            pc.setPassword(this.credentials.getPwd());
                            this.credentials.clearPassword();
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback, "Unknown Callback");
                    }
                }
                catch (InterruptedException | TimeoutException e) {
                    logger.error("An exception occurred while retrieving credentials - " + e.getMessage());
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("Stack trace", (Throwable)e);
                }
            }
        }, sharedState, options);
    }

    private synchronized CredentialsEntry obtainCredentials(CredentialsEntry credentialsEntry) throws InterruptedException, TimeoutException {
        if (credentialsEntry.isFilled()) {
            return credentialsEntry;
        }
        AsyncResult future = new AsyncResult();
        Platform.runLater(() -> {
            LoginDialog dlg = new LoginDialog(null, null);
            dlg.setHeaderText("Enter login credentials");
            dlg.setTitle("Login");
            dlg.initStyle(StageStyle.UTILITY);
            Dialogs.setAlwaysOnTop((Dialog)dlg);
            Optional res = dlg.showAndWait();
            if (res.isPresent()) {
                CredentialsEntry newCreds = new CredentialsEntry((String)((Pair)dlg.getResult()).getKey(), ((String)((Pair)dlg.getResult()).getValue()).toCharArray());
                future.put(newCreds);
            } else {
                future.put(CredentialsEntry.CANCELLED);
            }
        });
        return (CredentialsEntry)future.get();
    }

    private class AsyncResult<F> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private F value;

        private AsyncResult() {
        }

        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        public F get() throws InterruptedException {
            this.latch.await();
            return this.value;
        }

        public F get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (this.latch.await(timeout, unit)) {
                return this.value;
            }
            throw new TimeoutException();
        }

        private void put(F result) {
            this.value = result;
            this.latch.countDown();
        }
    }
}

