/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.cache;

import eu.fthevenet.util.cache.Cacheable;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMapSizeBound<K, V extends Cacheable>
extends LinkedHashMap<K, V> {
    private long maxSize;

    public LRUMapSizeBound(int maxSize) {
        super(16, 0.75f, true);
        this.maxSize = maxSize;
    }

    public LRUMapSizeBound(int maxSize, Map<? extends K, ? extends V> values) {
        this(maxSize);
        this.putAll(values);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.values().stream().map(Cacheable::getSize).reduce(0L, Long::sum) > this.maxSize;
    }
}

