/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.concurrent;

import eu.fthevenet.util.function.CheckedBiFunction;
import eu.fthevenet.util.function.CheckedConsumer;
import eu.fthevenet.util.function.CheckedFunction;
import eu.fthevenet.util.function.CheckedRunnable;
import eu.fthevenet.util.function.CheckedSupplier;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockHelper {
    private final ReadWriteLock lock;
    private final LockHelper readLockHelper;
    private final LockHelper writeLockHelper;

    public ReadWriteLockHelper() {
        this(new ReentrantReadWriteLock());
    }

    public ReadWriteLockHelper(ReadWriteLock lock) {
        this.lock = lock;
        this.readLockHelper = new LockHelper(lock.readLock());
        this.writeLockHelper = new LockHelper(lock.writeLock());
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public LockHelper read() {
        return this.readLockHelper;
    }

    public LockHelper write() {
        return this.writeLockHelper;
    }

    public static class LockHelper {
        private final Lock lock;

        private LockHelper(Lock lock) {
            this.lock = lock;
        }

        public <R, E extends Exception> R lock(CheckedSupplier<R, E> operation) throws E {
            this.lock.lock();
            try {
                R r = operation.get();
                return r;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T, R, E extends Exception> R lock(CheckedFunction<T, R, E> operation, T t) throws E {
            this.lock.lock();
            try {
                R r = operation.apply(t);
                return r;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T, U, R, E extends Exception> R lock(CheckedBiFunction<T, U, R, E> operation, T t, U u) throws E {
            this.lock.lock();
            try {
                R r = operation.apply(t, u);
                return r;
            }
            finally {
                this.lock.unlock();
            }
        }

        public <E extends Exception> void lock(CheckedRunnable<E> operation) throws E {
            this.lock.lock();
            try {
                operation.run();
            }
            finally {
                this.lock.unlock();
            }
        }

        public <T, E extends Exception> void lock(CheckedConsumer<T, E> operation, T t) throws E {
            this.lock.lock();
            try {
                operation.accept(t);
            }
            finally {
                this.lock.unlock();
            }
        }

        public <R, E extends Exception> Optional<R> tryLock(CheckedSupplier<R, E> operation) throws E {
            if (this.lock.tryLock()) {
                try {
                    Optional<R> optional = Optional.ofNullable(operation.get());
                    return optional;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T, R, E extends Exception> Optional<R> tryLock(CheckedFunction<T, R, E> operation, T t) throws E {
            if (this.lock.tryLock()) {
                try {
                    Optional<R> optional = Optional.ofNullable(operation.apply(t));
                    return optional;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T, U, R, E extends Exception> Optional<R> tryLock(CheckedBiFunction<T, U, R, E> operation, T t, U u) throws E {
            if (this.lock.tryLock()) {
                try {
                    Optional<R> optional = Optional.ofNullable(operation.apply(t, u));
                    return optional;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return Optional.empty();
        }

        public <E extends Exception> boolean tryLock(CheckedRunnable<E> operation) throws E {
            if (this.lock.tryLock()) {
                try {
                    operation.run();
                }
                finally {
                    this.lock.unlock();
                }
                return true;
            }
            return false;
        }

        public <T, E extends Exception> boolean tryLock(CheckedConsumer<T, E> operation, T t) throws E {
            if (this.lock.tryLock()) {
                try {
                    operation.accept(t);
                }
                finally {
                    this.lock.unlock();
                }
                return true;
            }
            return false;
        }
    }
}

