/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.diagnositic;

import eu.fthevenet.util.diagnositic.DiagnosticException;
import java.lang.management.ManagementFactory;
import java.util.function.Supplier;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public interface DiagnosticCommand {
    public static final DiagnosticCommand local = new Supplier<DiagnosticCommand>(){

        @Override
        public DiagnosticCommand get() {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = new ObjectName("com.sun.management", "type", "DiagnosticCommand");
                return JMX.newMBeanProxy(server, name, DiagnosticCommand.class);
            }
            catch (MalformedObjectNameException e) {
                throw new AssertionError((Object)e);
            }
        }
    }.get();

    public String threadPrint(String ... var1);

    public String help(String ... var1);

    public String vmSystemProperties(String ... var1);

    public String gcClassHistogram(String ... var1);

    public String vmFlags(String ... var1);

    public String vmCommandLine(String ... var1);

    public static String dumpVmSystemProperties() throws DiagnosticException {
        try {
            return local.vmSystemProperties(new String[0]);
        }
        catch (Throwable t) {
            throw new DiagnosticException("Failed to invoke diagnostic command VM.System_properties", t);
        }
    }

    public static String dumpThreadStacks() throws DiagnosticException {
        try {
            return local.threadPrint("-l");
        }
        catch (Throwable t) {
            throw new DiagnosticException("Failed to invoke diagnostic command Thread.print", t);
        }
    }

    public static String dumpClassHistogram() throws DiagnosticException {
        try {
            return local.gcClassHistogram(new String[0]);
        }
        catch (Throwable t) {
            throw new DiagnosticException("Failed to invoke diagnostic command GC.class_histogram", t);
        }
    }

    public static String dumpVmFlags() throws DiagnosticException {
        try {
            return local.vmFlags(new String[0]);
        }
        catch (Throwable t) {
            throw new DiagnosticException("Failed to invoke diagnostic command VM.flags", t);
        }
    }

    public static String dumpVmCommandLine() throws DiagnosticException {
        try {
            return local.vmCommandLine(new String[0]);
        }
        catch (Throwable t) {
            throw new DiagnosticException("Failed to invoke diagnostic command VM.command_line", t);
        }
    }

    public static String getHelp() throws DiagnosticException {
        try {
            return local.help(new String[0]);
        }
        catch (Throwable t) {
            throw new DiagnosticException("Failed to invoke diagnostic command help", t);
        }
    }
}

