/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.function;

import eu.fthevenet.util.function.CheckedConsumer;
import eu.fthevenet.util.function.CheckedFunction;
import eu.fthevenet.util.function.CheckedRunnable;
import eu.fthevenet.util.function.CheckedSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class CheckedLambdas {
    private CheckedLambdas() {
    }

    public static <T, E extends Exception> Consumer<T> wrap(CheckedConsumer<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                throw CheckedLambdas.throwActualException(exception);
            }
        };
    }

    public static <E extends Exception> Runnable wrap(CheckedRunnable<E> runnable) throws E {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                throw CheckedLambdas.throwActualException(exception);
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> wrap(CheckedSupplier<T, E> supplier) throws E {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                throw CheckedLambdas.throwActualException(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> wrap(CheckedFunction<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                throw CheckedLambdas.throwActualException(exception);
            }
        };
    }

    private static <E extends Exception> RuntimeException throwActualException(Exception exception) throws E {
        throw exception;
    }
}

