/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.github;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.fthevenet.util.github.GithubRelease;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GithubApi {
    private static final Logger logger = LogManager.getLogger(GithubApi.class);
    public static final String GITHUB_API_HOSTNAME = "api.github.com";
    public static final String URL_PROTOCOL = "https";
    private final CloseableHttpClient httpClient;
    private Gson gson = new Gson();

    private GithubApi() {
        this.httpClient = HttpClients.createDefault();
    }

    public static GithubApi getInstance() {
        return GithubApiHolder.instance;
    }

    public Optional<GithubRelease> getLatestRelease(String owner, String repo) throws IOException, URISyntaxException {
        return this.getRelease(owner, repo, "latest");
    }

    public Optional<GithubRelease> getRelease(String owner, String repo, String id) throws IOException, URISyntaxException {
        URIBuilder requestUrl = new URIBuilder().setScheme(URL_PROTOCOL).setHost(GITHUB_API_HOSTNAME).setPath("/repos/" + owner + "/" + repo + "/releases/" + id);
        logger.debug(() -> "requestUrl = " + requestUrl);
        HttpGet httpget = new HttpGet(requestUrl.build());
        return Optional.ofNullable(this.httpClient.execute((HttpUriRequest)httpget, (ResponseHandler)new AbstractResponseHandler<GithubRelease>(){

            public GithubRelease handleEntity(HttpEntity entity) throws IOException {
                return (GithubRelease)GithubApi.this.gson.fromJson(EntityUtils.toString((HttpEntity)entity), GithubRelease.class);
            }
        }));
    }

    public List<GithubRelease> getAllReleases(String owner, String repo) throws IOException, URISyntaxException {
        URIBuilder requestUrl = new URIBuilder().setScheme(URL_PROTOCOL).setHost(GITHUB_API_HOSTNAME).setPath("/repos/" + owner + "/" + repo + "/releases");
        logger.debug(() -> "requestUrl = " + requestUrl);
        HttpGet httpget = new HttpGet(requestUrl.build());
        return (List)this.httpClient.execute((HttpUriRequest)httpget, (ResponseHandler)new AbstractResponseHandler<List<GithubRelease>>(){

            public List<GithubRelease> handleEntity(HttpEntity entity) throws IOException {
                return (List)GithubApi.this.gson.fromJson(EntityUtils.toString((HttpEntity)entity), new TypeToken<ArrayList<GithubRelease>>(){}.getType());
            }
        });
    }

    private static class GithubApiHolder {
        private static final GithubApi instance = new GithubApi();

        private GithubApiHolder() {
        }
    }
}

