/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.github;

import com.google.gson.annotations.SerializedName;
import eu.fthevenet.util.github.GithubUser;
import eu.fthevenet.util.version.Version;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GithubRelease {
    private static final Logger logger = LogManager.getLogger(GithubRelease.class);
    private String url;
    @SerializedName(value="html_url")
    private String htmlUrl;
    @SerializedName(value="assets_url")
    private String assetsUrl;
    @SerializedName(value="upload_url")
    private String uploadUrl;
    @SerializedName(value="tarball_url")
    private String tarballUrl;
    @SerializedName(value="zipball_url")
    private String zipballUrl;
    private long id;
    @SerializedName(value="tag_name")
    private String tagName;
    @SerializedName(value="target_commitish")
    private String targetCommitish;
    private String name;
    private String body;
    @SerializedName(value="draft")
    private boolean isDraft;
    @SerializedName(value="prerelease")
    private boolean isPrerelease;
    @SerializedName(value="created_at")
    private Date createdAt;
    @SerializedName(value="published_at")
    private Date publishedAt;
    private GithubUser author;

    public String getUrl() {
        return this.url;
    }

    public GithubRelease setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public GithubRelease setHtmlUrl(String htmlUrl) {
        this.htmlUrl = htmlUrl;
        return this;
    }

    public String getAssetsUrl() {
        return this.assetsUrl;
    }

    public GithubRelease setAssetsUrl(String assetsUrl) {
        this.assetsUrl = assetsUrl;
        return this;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public GithubRelease setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        return this;
    }

    public String getTarballUrl() {
        return this.tarballUrl;
    }

    public GithubRelease setTarballUrl(String tarballUrl) {
        this.tarballUrl = tarballUrl;
        return this;
    }

    public String getZipballUrl() {
        return this.zipballUrl;
    }

    public GithubRelease setZipballUrl(String zipballUrl) {
        this.zipballUrl = zipballUrl;
        return this;
    }

    public long getId() {
        return this.id;
    }

    public GithubRelease setId(long id) {
        this.id = id;
        return this;
    }

    public String getTagName() {
        return this.tagName;
    }

    public GithubRelease setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public String getTargetCommitish() {
        return this.targetCommitish;
    }

    public GithubRelease setTargetCommitish(String targetCommitish) {
        this.targetCommitish = targetCommitish;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public GithubRelease setName(String name) {
        this.name = name;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public GithubRelease setBody(String body) {
        this.body = body;
        return this;
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public GithubRelease setDraft(boolean isDraft) {
        this.isDraft = isDraft;
        return this;
    }

    public boolean isPrerelease() {
        return this.isPrerelease;
    }

    public GithubRelease setPrerelease(boolean isPrerelease) {
        this.isPrerelease = isPrerelease;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public GithubRelease setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Date getPublishedAt() {
        return this.publishedAt;
    }

    public GithubRelease setPublishedAt(Date publishedAt) {
        this.publishedAt = publishedAt;
        return this;
    }

    public GithubUser getAuthor() {
        return this.author;
    }

    public GithubRelease setAuthor(GithubUser author) {
        this.author = author;
        return this;
    }

    public Version getVersion() {
        if (this.tagName == null) {
            return Version.emptyVersion;
        }
        try {
            return new Version(this.tagName.replaceAll("^v", ""));
        }
        catch (IllegalArgumentException e) {
            logger.error("Could not decode version number from tag: " + this.tagName, (Throwable)e);
            return Version.emptyVersion;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GithubRelease{");
        sb.append("url='").append(this.url).append('\'');
        sb.append(", htmlUrl='").append(this.htmlUrl).append('\'');
        sb.append(", assetsUrl='").append(this.assetsUrl).append('\'');
        sb.append(", uploadUrl='").append(this.uploadUrl).append('\'');
        sb.append(", tarballUrl='").append(this.tarballUrl).append('\'');
        sb.append(", zipballUrl='").append(this.zipballUrl).append('\'');
        sb.append(", id=").append(this.id);
        sb.append(", tagName='").append(this.tagName).append('\'');
        sb.append(", targetCommitish='").append(this.targetCommitish).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", body='").append(this.body).append('\'');
        sb.append(", isDraft=").append(this.isDraft);
        sb.append(", isPrerelease=").append(this.isPrerelease);
        sb.append(", createdAt=").append(this.createdAt);
        sb.append(", publishedAt=").append(this.publishedAt);
        sb.append(", author=").append(this.author);
        sb.append('}');
        return sb.toString();
    }
}

