/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IOUtils {
    private static final int DEFAULT_COPY_BUFFER_SIZE = 32768;
    private static final int EOF = -1;

    public static long copyChannels(ReadableByteChannel input, WritableByteChannel output) throws IOException {
        return IOUtils.copyChannels(input, output, 32768);
    }

    public static long copyChannels(ReadableByteChannel input, WritableByteChannel output, int bufferSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        long count = 0L;
        while (input.read(buffer) != -1) {
            buffer.flip();
            count += (long)output.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            count += (long)output.write(buffer);
        }
        return count;
    }

    public static long copyStreams(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copyStreams(input, output, 32768);
    }

    public static long copyStreams(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int n;
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static byte[] readToBuffer(InputStream input) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            long count = IOUtils.copyStreams(input, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static long consumeStream(InputStream input) throws IOException {
        int n;
        byte[] buffer = new byte[32768];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            count += (long)n;
        }
        return count;
    }

    public static String readToString(InputStream in) throws IOException {
        return new String(IOUtils.readToBuffer(in));
    }

    public static String readToString(InputStream in, String charset) throws IOException {
        return new String(IOUtils.readToBuffer(in), charset);
    }
}

