/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.bindings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BindingManager
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(BindingManager.class);
    private final Map<ObservableValue, List<ChangeListener>> changeListeners = new ConcurrentHashMap<ObservableValue, List<ChangeListener>>();
    private final Map<ObservableValue, List<InvalidationListener>> invalidationListeners = new ConcurrentHashMap<ObservableValue, List<InvalidationListener>>();
    private final Map<ObservableList, List<ListChangeListener>> listChangeListeners = new ConcurrentHashMap<ObservableList, List<ListChangeListener>>();
    private final Set<Property<?>> boundProperties = Collections.newSetFromMap(new WeakHashMap());

    public <T> void bind(Property<T> property, ObservableValue<T> binding) {
        Objects.requireNonNull(property, "property parameter cannot be null");
        Objects.requireNonNull(binding, "binding parameter cannot be null");
        logger.trace(() -> "Binding " + binding.toString() + " to " + property.toString());
        property.bind(binding);
        this.boundProperties.add(property);
    }

    public void unbindAll() {
        this.boundProperties.forEach(property -> {
            logger.trace(() -> "Unbinding property " + property.toString());
            property.unbind();
        });
    }

    public void attachListener(ObservableValue<?> observable, ChangeListener<?> listener) {
        this.attachListener(observable, listener, this.changeListeners, ObservableValue::addListener);
    }

    public void attachListener(ObservableValue<?> observable, InvalidationListener listener) {
        this.attachListener(observable, listener, this.invalidationListeners, Observable::addListener);
    }

    public void attachListener(ObservableList<?> observable, ListChangeListener listener) {
        this.attachListener(observable, listener, this.listChangeListeners, ObservableList::addListener);
    }

    public void detachListener(ObservableValue<?> observable, ChangeListener listener) {
        this.detachListener(observable, listener, this.changeListeners, ObservableValue::removeListener);
    }

    public void detachListener(ObservableValue<?> observable, InvalidationListener listener) {
        this.detachListener(observable, listener, this.invalidationListeners, Observable::removeListener);
    }

    public void detachListener(ObservableList<?> observable, ListChangeListener<?> listener) {
        this.detachListener(observable, listener, this.listChangeListeners, ObservableList::removeListener);
    }

    public void detachAllInvalidationListeners(ObservableValue<?> observable) {
        this.detachAllListener(observable, this.invalidationListeners, Observable::removeListener);
    }

    public void detachAllChangeListeners(ObservableValue<?> observable) {
        this.detachAllListener(observable, this.changeListeners, ObservableValue::removeListener);
    }

    public void detachAllListChangeListeners(ObservableList<?> observable) {
        this.detachAllListener(observable, this.listChangeListeners, ObservableList::removeListener);
    }

    @Override
    public void close() {
        this.closeMap(this.listChangeListeners, ObservableList::removeListener);
        this.closeMap(this.invalidationListeners, Observable::removeListener);
        this.closeMap(this.changeListeners, ObservableValue::removeListener);
        this.unbindAll();
    }

    private <T, U> void attachListener(T observable, U listener, Map<T, List<U>> map, BiConsumer<T, U> attachAction) {
        Objects.requireNonNull(observable, "observable parameter cannot be null");
        Objects.requireNonNull(listener, "listener parameter cannot be null");
        Objects.requireNonNull(map, "map parameter cannot be null");
        Objects.requireNonNull(attachAction, "attachAction parameter cannot be null");
        map.computeIfAbsent(observable, p -> new ArrayList()).add(listener);
        logger.trace(() -> "Attaching listener " + listener.toString() + " to observable " + observable.toString());
        attachAction.accept(observable, listener);
    }

    private <T, U> void detachListener(T observable, U listener, Map<T, List<U>> map, BiConsumer<T, U> detachAction) {
        Objects.requireNonNull(observable, "observable parameter cannot be null");
        Objects.requireNonNull(listener, "listener parameter cannot be null");
        Objects.requireNonNull(map, "map parameter cannot be null");
        Objects.requireNonNull(detachAction, "ifPresent parameter cannot be null");
        List<U> listeners = map.get(observable);
        if (listeners == null) {
            throw new IllegalArgumentException("Observable " + observable.toString() + " is not managed by this BindingManager instance");
        }
        listeners.stream().filter(l -> l.equals(listener)).findFirst().ifPresent(found -> ((List)map.get(observable)).remove(found));
        logger.trace(() -> "Removing Listener " + listener.toString() + " from observable " + observable.toString());
        detachAction.accept(observable, listener);
    }

    private <T, U> void detachAllListener(T observable, Map<T, List<U>> map, BiConsumer<T, U> detachAction) {
        Objects.requireNonNull(observable, "observable paramater cannot be null");
        Objects.requireNonNull(map, "map parameter cannot be null");
        Objects.requireNonNull(detachAction, "attachAction parameter cannot be null");
        List<U> l = map.get(observable);
        if (l == null) {
            throw new IllegalArgumentException("ObservableList " + observable.toString() + " is not managed by this BindingManager instance");
        }
        l.forEach(listener -> {
            logger.trace(() -> "Removing Listener " + listener.toString() + " from observable " + observable.toString());
            detachAction.accept(observable, listener);
        });
        map.remove(observable);
    }

    private <T, U> void closeMap(Map<T, List<U>> map, BiConsumer<T, U> detachAction) {
        Objects.requireNonNull(map, "map parameter cannot be null");
        Objects.requireNonNull(detachAction, "attachAction parameter cannot be null");
        map.forEach((observable, listeners) -> listeners.forEach(listener -> {
            logger.trace(() -> "Removing Listener " + listener.toString() + " from observable " + observable.toString());
            detachAction.accept(observable, listener);
        }));
        map.clear();
    }
}

