/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.charts;

import eu.fthevenet.util.javafx.charts.StableTicksAxis;
import eu.fthevenet.util.text.BinaryPrefixFormatter;

public class BinaryStableTicksAxis
extends StableTicksAxis {
    public BinaryStableTicksAxis() {
        super(new BinaryPrefixFormatter());
    }

    @Override
    public double calculateTickSpacing(double delta, int maxTicks) {
        double[] dividers = new double[]{1.0, 2.0, 4.0, 8.0, 16.0};
        if (delta == 0.0) {
            return 0.0;
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta must be positive");
        }
        if (maxTicks < 1) {
            throw new IllegalArgumentException("must be at least one tick");
        }
        int divider = 0;
        int base = 2;
        int factor = (int)(Math.log(delta) / Math.log(2.0));
        double numTicks = delta / (dividers[divider] * Math.pow(base, factor));
        if (numTicks < (double)maxTicks) {
            while (numTicks < (double)maxTicks) {
                if (--divider < 0) {
                    --factor;
                    divider = dividers.length - 1;
                }
                numTicks = delta / (dividers[divider] * Math.pow(base, factor));
            }
            if (numTicks != (double)maxTicks && ++divider >= dividers.length) {
                ++factor;
                divider = 0;
            }
        } else {
            while (numTicks > (double)maxTicks) {
                if (++divider >= dividers.length) {
                    ++factor;
                    divider = 0;
                }
                numTicks = delta / (dividers[divider] * Math.pow(base, factor));
            }
        }
        return dividers[divider] * Math.pow(base, factor);
    }
}

