/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.charts;

import eu.fthevenet.util.text.PrefixFormatter;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Dimension2D;
import javafx.scene.chart.ValueAxis;
import javafx.util.Duration;
import org.gillius.jfxutils.chart.AxisTickFormatter;

public abstract class StableTicksAxis
extends ValueAxis<Number> {
    private static final int NUM_MINOR_TICKS = 3;
    public static final int BTN_WITDTH = 21;
    private final Timeline animationTimeline = new Timeline();
    private final WritableValue<Double> scaleValue = new WritableValue<Double>(){

        public Double getValue() {
            return StableTicksAxis.this.getScale();
        }

        public void setValue(Double value) {
            StableTicksAxis.this.setScale(value);
        }
    };
    private AxisTickFormatter axisTickFormatter;
    private SimpleDoubleProperty tickSpacing = new SimpleDoubleProperty(20.0);
    private List<Number> minorTicks;
    private DoubleProperty autoRangePadding = new SimpleDoubleProperty(0.1);
    private BooleanProperty forceZeroInRange = new SimpleBooleanProperty(true);

    public StableTicksAxis(final PrefixFormatter prefixFormatter) {
        this.getStyleClass().setAll((Object[])new String[]{"axis"});
        this.axisTickFormatter = new AxisTickFormatter(){

            public void setRange(double v, double v1, double v2) {
            }

            public String format(Number number) {
                return prefixFormatter.format(number.doubleValue());
            }
        };
    }

    public AxisTickFormatter getAxisTickFormatter() {
        return this.axisTickFormatter;
    }

    public void setAxisTickFormatter(AxisTickFormatter axisTickFormatter) {
        this.axisTickFormatter = axisTickFormatter;
    }

    public double getAutoRangePadding() {
        return this.autoRangePadding.get();
    }

    public DoubleProperty autoRangePaddingProperty() {
        return this.autoRangePadding;
    }

    public void setAutoRangePadding(double autoRangePadding) {
        this.autoRangePadding.set(autoRangePadding);
    }

    public boolean isForceZeroInRange() {
        return this.forceZeroInRange.get();
    }

    public BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    public void setForceZeroInRange(boolean forceZeroInRange) {
        this.forceZeroInRange.set(forceZeroInRange);
    }

    protected Range autoRange(double minValue, double maxValue, double length, double labelSize) {
        if (Math.abs(minValue - maxValue) < 1.0E-300) {
            minValue -= 1.0;
            maxValue += 1.0;
        } else {
            double paddedMax;
            double delta = maxValue - minValue;
            double paddedMin = minValue - delta * this.autoRangePadding.get();
            if (Math.signum(paddedMin) != Math.signum(minValue)) {
                paddedMin = 0.0;
            }
            if (Math.signum(paddedMax = maxValue + delta * this.autoRangePadding.get()) != Math.signum(maxValue)) {
                paddedMax = 0.0;
            }
            minValue = paddedMin;
            maxValue = paddedMax;
        }
        if (this.forceZeroInRange.get()) {
            if (minValue < 0.0 && maxValue < 0.0) {
                maxValue = 0.0;
                minValue -= -minValue * this.autoRangePadding.get();
            } else if (minValue > 0.0 && maxValue > 0.0) {
                minValue = 0.0;
                maxValue += maxValue * this.autoRangePadding.get();
            }
        }
        Range ret = this.getRange(minValue, maxValue);
        return ret;
    }

    private Range getRange(double minValue, double maxValue) {
        double length = this.getLength();
        double delta = maxValue - minValue;
        double scale = this.calculateNewScale(length, minValue, maxValue);
        int maxTicks = Math.max(1, (int)(length / this.getTickSpacing()));
        Range ret = new Range(minValue, maxValue, this.calculateTickSpacing(delta, maxTicks), scale);
        return ret;
    }

    public abstract double calculateTickSpacing(double var1, int var3);

    protected List<Number> calculateMinorTickMarks() {
        return this.minorTicks;
    }

    protected void setRange(Object range, boolean animate) {
        Range rangeVal = (Range)range;
        if (animate) {
            this.animationTimeline.stop();
            ObservableList keyFrames = this.animationTimeline.getKeyFrames();
            keyFrames.setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)this.getLowerBound()), new KeyValue(this.scaleValue, (Object)this.getScale())}), new KeyFrame(Duration.millis((double)750.0), new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)rangeVal.low), new KeyValue(this.scaleValue, (Object)rangeVal.scale)})});
            this.animationTimeline.play();
        } else {
            this.currentLowerBound.set(rangeVal.low);
            this.setScale(rangeVal.scale);
        }
        this.setLowerBound(rangeVal.low);
        this.setUpperBound(rangeVal.high);
        this.axisTickFormatter.setRange(rangeVal.low, rangeVal.high, rangeVal.tickSpacing);
    }

    protected Range getRange() {
        Range ret = this.getRange(this.getLowerBound(), this.getUpperBound());
        return ret;
    }

    protected List<Number> calculateTickValues(double length, Object range) {
        Range rangeVal = (Range)range;
        double firstTick = Math.floor(rangeVal.low / rangeVal.tickSpacing) * rangeVal.tickSpacing;
        int numTicks = (int)(rangeVal.getDelta() / rangeVal.tickSpacing) + 1;
        ArrayList<Number> ret = new ArrayList<Number>(numTicks + 1);
        this.minorTicks = new ArrayList<Number>((numTicks + 2) * 3);
        double minorTickSpacing = rangeVal.tickSpacing / 4.0;
        for (int i = 0; i <= numTicks; ++i) {
            double majorTick = firstTick + rangeVal.tickSpacing * (double)i;
            ret.add(majorTick);
            for (int j = 1; j <= 3; ++j) {
                this.minorTicks.add(majorTick + minorTickSpacing * (double)j);
            }
        }
        return ret;
    }

    protected String getTickMarkLabel(Number number) {
        return this.axisTickFormatter.format(number);
    }

    private double getLength() {
        if (this.getSide().isHorizontal()) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    private double getLabelSize() {
        Dimension2D dim = this.measureTickMarkLabelSize("-888.88E-88", this.getTickLabelRotation());
        if (this.getSide().isHorizontal()) {
            return dim.getWidth();
        }
        return dim.getHeight();
    }

    public double getTickSpacing() {
        return this.tickSpacing.get();
    }

    public SimpleDoubleProperty tickSpacingProperty() {
        return this.tickSpacing;
    }

    public void setTickSpacing(double tickSpacing) {
        this.tickSpacing.set(tickSpacing);
    }

    private static class Range {
        public final double low;
        public final double high;
        public final double tickSpacing;
        public final double scale;

        private Range(double low, double high, double tickSpacing, double scale) {
            this.low = low;
            this.high = high;
            this.tickSpacing = tickSpacing;
            this.scale = scale;
        }

        public double getDelta() {
            return this.high - this.low;
        }

        public String toString() {
            return "Range{low=" + this.low + ", high=" + this.high + ", tickSpacing=" + this.tickSpacing + ", scale=" + this.scale + '}';
        }
    }
}

