/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.charts;

import eu.fthevenet.util.javafx.charts.XYChartSelection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gillius.jfxutils.JFXUtil;
import org.gillius.jfxutils.chart.XYChartInfo;

public class XYChartCrosshair<X, Y> {
    private static final Logger logger = LogManager.getLogger(XYChartCrosshair.class);
    private static final double SELECTION_OPACITY = 0.5;
    private final Line horizontalMarker = new Line();
    private final Line verticalMarker = new Line();
    private final Label xAxisLabel;
    private final Label yAxisLabel;
    private final LinkedHashMap<XYChart<X, Y>, Function<Y, String>> charts;
    private final Function<X, String> xValuesFormatter;
    private final XYChartInfo chartInfo;
    private final BooleanProperty isSelecting = new SimpleBooleanProperty(false);
    private final Pane parent;
    private Point2D selectionStart = new Point2D(-1.0, -1.0);
    private Point2D mousePosition = new Point2D(-1.0, -1.0);
    private final Rectangle selection = new Rectangle(0.0, 0.0, 0.0, 0.0);
    private final BooleanProperty verticalMarkerVisible = new SimpleBooleanProperty();
    private final BooleanProperty horizontalMarkerVisible = new SimpleBooleanProperty();
    private Consumer<Map<XYChart<X, Y>, XYChartSelection<X, Y>>> selectionDoneEvent;
    private final Map<XYChart<X, Y>, Property<Y>> currentYValues = new HashMap<XYChart<X, Y>, Property<Y>>();
    private final Property<X> currentXValue = new SimpleObjectProperty();
    private final XYChart<X, Y> masterChart;
    private final BooleanProperty isMouseOverChart = new SimpleBooleanProperty(false);

    public XYChartCrosshair(LinkedHashMap<XYChart<X, Y>, Function<Y, String>> charts, Pane parent, Function<X, String> xValuesFormatter) {
        this.charts = charts;
        this.applyStyle((Shape)this.verticalMarker);
        this.applyStyle((Shape)this.horizontalMarker);
        this.applyStyle((Shape)this.selection);
        this.xAxisLabel = this.newAxisLabel();
        this.yAxisLabel = this.newAxisLabel();
        this.parent = parent;
        parent.getChildren().addAll((Object[])new Node[]{this.xAxisLabel, this.yAxisLabel, this.verticalMarker, this.horizontalMarker, this.selection});
        this.xValuesFormatter = xValuesFormatter;
        this.masterChart = (XYChart)charts.keySet().stream().reduce((p, n) -> n).orElseThrow(() -> new IllegalStateException("Could not identify last element in chart linked hash map."));
        this.chartInfo = new XYChartInfo(this.masterChart, (Node)parent);
        this.masterChart.addEventHandler(MouseEvent.MOUSE_MOVED, this::handleMouseMoved);
        this.masterChart.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::handleMouseMoved);
        this.masterChart.setOnMouseReleased(e -> {
            if (this.isSelecting.get()) {
                this.fireSelectionDoneEvent();
                this.drawVerticalMarker();
                this.drawHorizontalMarker();
            }
            this.isSelecting.set(false);
        });
        this.isSelecting.addListener((observable, oldValue, newValue) -> {
            logger.debug(() -> "observable=" + observable + " oldValue=" + oldValue + " newValue=" + newValue);
            if (!oldValue.booleanValue() && newValue.booleanValue()) {
                this.selectionStart = new Point2D(this.verticalMarker.getStartX(), this.horizontalMarker.getStartY());
            }
            this.drawSelection();
            this.selection.setVisible(newValue.booleanValue());
        });
        this.horizontalMarkerVisible.addListener((observable, oldValue, newValue) -> {
            this.drawHorizontalMarker();
            if (!newValue.booleanValue() && !this.verticalMarkerVisible.get()) {
                this.isSelecting.set(false);
                this.currentYValues.forEach((key, value) -> value.setValue(null));
            }
        });
        this.verticalMarkerVisible.addListener((observable, oldValue, newValue) -> {
            this.drawVerticalMarker();
            if (!newValue.booleanValue() && !this.horizontalMarkerVisible.get()) {
                this.isSelecting.set(false);
                this.currentXValue.setValue(null);
            }
        });
        this.masterChart.setOnMouseExited(event -> this.isMouseOverChart.set(false));
        this.masterChart.setOnMouseEntered(event -> this.isMouseOverChart.set(true));
        this.horizontalMarker.visibleProperty().bind((ObservableValue)this.horizontalMarkerVisible.and((ObservableBooleanValue)this.isMouseOverChart));
        this.yAxisLabel.visibleProperty().bind((ObservableValue)this.horizontalMarkerVisible.and((ObservableBooleanValue)this.isMouseOverChart));
        this.verticalMarker.visibleProperty().bind((ObservableValue)this.verticalMarkerVisible.and((ObservableBooleanValue)this.isMouseOverChart));
        this.xAxisLabel.visibleProperty().bind((ObservableValue)this.verticalMarkerVisible.and((ObservableBooleanValue)this.isMouseOverChart));
    }

    public BooleanProperty verticalMarkerVisibleProperty() {
        return this.verticalMarkerVisible;
    }

    public BooleanProperty horizontalMarkerVisibleProperty() {
        return this.horizontalMarkerVisible;
    }

    public boolean isVerticalMarkerVisible() {
        return this.verticalMarkerVisible.get();
    }

    public boolean isHorizontalMarkerVisible() {
        return this.horizontalMarkerVisible.get();
    }

    public void setVerticalMarkerVisible(boolean verticalMarkerVisible) {
        this.verticalMarkerVisible.set(verticalMarkerVisible);
    }

    public void setHorizontalMarkerVisible(boolean horizontalMarkerVisible) {
        this.horizontalMarkerVisible.set(horizontalMarkerVisible);
    }

    public void onSelectionDone(Consumer<Map<XYChart<X, Y>, XYChartSelection<X, Y>>> action) {
        this.selectionDoneEvent = action;
    }

    public Y getCurrentYValue(XYChart<X, Y> chart) {
        return (Y)this.currentYValues.get(chart).getValue();
    }

    public X getCurrentXValue() {
        return (X)this.currentXValue.getValue();
    }

    public Property<X> currentXValueProperty() {
        return this.currentXValue;
    }

    private void fireSelectionDoneEvent() {
        if (this.selectionDoneEvent != null && this.selection.getWidth() > 0.0 && this.selection.getHeight() > 0.0) {
            HashMap s = new HashMap();
            this.charts.forEach((c, f) -> s.put(c, new XYChartSelection<X, Y>(this.getValueFromXcoord(this.selection.getX() - 0.5), this.getValueFromXcoord(this.selection.getX() + this.selection.getWidth() - 0.5), this.getValueFromYcoord((XYChart<X, Y>)c, this.selection.getY() + this.selection.getHeight() - 0.5), this.getValueFromYcoord((XYChart<X, Y>)c, this.selection.getY() - 0.5), this.selection.getHeight() != this.chartInfo.getPlotArea().getHeight())));
            this.selectionDoneEvent.accept(s);
        }
    }

    private void drawHorizontalMarker() {
        if (this.mousePosition.getY() < 0.0) {
            return;
        }
        this.horizontalMarker.setStartX(this.chartInfo.getPlotArea().getMinX() + 0.5);
        this.horizontalMarker.setEndX(this.chartInfo.getPlotArea().getMaxX() + 0.5);
        this.horizontalMarker.setStartY(this.mousePosition.getY() + 0.5);
        this.horizontalMarker.setEndY(this.mousePosition.getY() + 0.5);
        this.yAxisLabel.setLayoutX(Math.min(this.parent.getWidth() - this.yAxisLabel.getWidth(), this.chartInfo.getPlotArea().getMaxX() + 5.0));
        this.yAxisLabel.setLayoutY(Math.min(this.mousePosition.getY() + 5.0, this.chartInfo.getPlotArea().getMaxY() - this.yAxisLabel.getHeight()));
        StringBuilder yAxisText = new StringBuilder();
        this.charts.forEach((c, f) -> {
            this.currentYValues.computeIfAbsent((XYChart<X, Y>)c, k -> new SimpleObjectProperty()).setValue(this.getValueFromYcoord((XYChart<X, Y>)c, this.mousePosition.getY()));
            yAxisText.append(c.getYAxis().getLabel()).append(": ").append((String)f.apply(this.currentYValues.get(c).getValue())).append("\n");
        });
        this.yAxisLabel.setText(yAxisText.toString());
    }

    private Y getValueFromYcoord(XYChart<X, Y> chart, double yPosition) {
        double yStart = chart.getYAxis().getLocalToParentTransform().getTy();
        double axisYRelativePosition = yPosition - JFXUtil.getYShift(this.masterChart, (Node)this.parent) - yStart * 1.5;
        return (Y)chart.getYAxis().getValueForDisplay(axisYRelativePosition);
    }

    private X getValueFromXcoord(double xPosition) {
        double xStart = this.masterChart.getXAxis().getLocalToParentTransform().getTx();
        double axisXRelativeMousePosition = xPosition - JFXUtil.getXShift(this.masterChart, (Node)this.parent) - xStart;
        return (X)this.masterChart.getXAxis().getValueForDisplay(axisXRelativeMousePosition - 5.0);
    }

    private void drawVerticalMarker() {
        if (this.mousePosition.getX() < 0.0) {
            return;
        }
        this.verticalMarker.setStartX(this.mousePosition.getX() + 0.5);
        this.verticalMarker.setEndX(this.mousePosition.getX() + 0.5);
        this.verticalMarker.setStartY(this.chartInfo.getPlotArea().getMinY() + 0.5);
        this.verticalMarker.setEndY(this.chartInfo.getPlotArea().getMaxY() + 0.5);
        this.xAxisLabel.setLayoutY(this.chartInfo.getPlotArea().getMaxY() + 4.0);
        this.xAxisLabel.setLayoutX(Math.min(this.mousePosition.getX(), this.chartInfo.getPlotArea().getMaxX() - this.xAxisLabel.getWidth()));
        this.currentXValue.setValue(this.getValueFromXcoord(this.mousePosition.getX()));
        this.xAxisLabel.setText(this.xValuesFormatter.apply(this.currentXValue.getValue()));
    }

    private void handleMouseMoved(MouseEvent event) {
        Rectangle2D area = this.chartInfo.getPlotArea();
        double xPos = event.getX() + JFXUtil.getXShift(this.masterChart, (Node)this.parent);
        double yPos = event.getY() + JFXUtil.getYShift(this.masterChart, (Node)this.parent);
        this.mousePosition = new Point2D(Math.max(area.getMinX(), Math.min(area.getMaxX(), xPos)), Math.max(area.getMinY(), Math.min(area.getMaxY(), yPos)));
        if (this.horizontalMarkerVisible.get()) {
            this.drawHorizontalMarker();
        }
        if (this.verticalMarkerVisible.get()) {
            this.drawVerticalMarker();
        }
        if (event.isPrimaryButtonDown() && (this.verticalMarkerVisible.get() || this.horizontalMarkerVisible.get())) {
            this.isSelecting.set(true);
            this.drawSelection();
        }
    }

    private void drawSelection() {
        if (this.selectionStart.getX() < 0.0 || this.selectionStart.getY() < 0.0) {
            return;
        }
        if (this.horizontalMarkerVisible.get()) {
            double height = this.horizontalMarker.getStartY() - this.selectionStart.getY();
            this.selection.setY(height < 0.0 ? this.horizontalMarker.getStartY() : this.selectionStart.getY());
            this.selection.setHeight(Math.abs(height));
        } else {
            this.selection.setY(this.verticalMarker.getStartY());
            this.selection.setHeight(this.verticalMarker.getEndY() - this.verticalMarker.getStartY());
        }
        if (this.verticalMarkerVisible.get()) {
            double width = this.verticalMarker.getStartX() - this.selectionStart.getX();
            this.selection.setX(width < 0.0 ? this.verticalMarker.getStartX() : this.selectionStart.getX());
            this.selection.setWidth(Math.abs(width));
        } else {
            this.selection.setX(this.horizontalMarker.getStartX());
            this.selection.setWidth(this.horizontalMarker.getEndX() - this.horizontalMarker.getStartX());
        }
    }

    private Label newAxisLabel() {
        Label label = new Label("");
        label.getStyleClass().add((Object)"crosshair-axis-label");
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMouseTransparent(true);
        label.setVisible(false);
        return label;
    }

    private void applyStyle(Shape shape) {
        shape.setMouseTransparent(true);
        shape.setSmooth(false);
        shape.setStrokeWidth(1.0);
        shape.setVisible(false);
        shape.setStrokeType(StrokeType.CENTERED);
        shape.setStroke((Paint)Color.STEELBLUE);
        Color fillColor = Color.LIGHTSTEELBLUE;
        shape.setFill((Paint)new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), 0.5));
    }
}

