/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.charts;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.chart.Axis;
import javafx.util.StringConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ZonedDateTimeAxis
extends Axis<ZonedDateTime> {
    private static final Logger logger = LogManager.getLogger(ZonedDateTimeAxis.class);
    private final LongProperty currentLowerBound = new SimpleLongProperty((Object)this, "currentLowerBound");
    private final LongProperty currentUpperBound = new SimpleLongProperty((Object)this, "currentUpperBound");
    private final ObjectProperty<StringConverter<ZonedDateTime>> tickLabelFormatter = new ObjectPropertyBase<StringConverter<ZonedDateTime>>(){

        protected void invalidated() {
            if (!ZonedDateTimeAxis.this.isAutoRanging()) {
                ZonedDateTimeAxis.this.invalidateRange();
                ZonedDateTimeAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return ZonedDateTimeAxis.this;
        }

        public String getName() {
            return "tickLabelFormatter";
        }
    };
    private final Property<ZoneId> zoneId;
    private ZonedDateTime minDate;
    private ZonedDateTime maxDate;
    private ObjectProperty<ZonedDateTime> lowerBound = new ObjectPropertyBase<ZonedDateTime>(){

        protected void invalidated() {
            if (!ZonedDateTimeAxis.this.isAutoRanging()) {
                ZonedDateTimeAxis.this.invalidateRange();
                ZonedDateTimeAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return ZonedDateTimeAxis.this;
        }

        public String getName() {
            return "lowerBound";
        }
    };
    private ObjectProperty<ZonedDateTime> upperBound = new ObjectPropertyBase<ZonedDateTime>(){

        protected void invalidated() {
            if (!ZonedDateTimeAxis.this.isAutoRanging()) {
                ZonedDateTimeAxis.this.invalidateRange();
                ZonedDateTimeAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return ZonedDateTimeAxis.this;
        }

        public String getName() {
            return "upperBound";
        }
    };
    private Object currentAnimationID;
    private Interval actualInterval = Interval.DECADE;
    private ZoneOffset zoneOffset = ZoneOffset.UTC;

    public ZonedDateTimeAxis() {
        this.zoneId = new SimpleObjectProperty((Object)ZoneId.systemDefault());
    }

    public ZonedDateTimeAxis(ZoneId zoneId) {
        this.zoneId = new SimpleObjectProperty((Object)zoneId);
    }

    public ZonedDateTimeAxis(ZonedDateTime lowerBound, ZonedDateTime upperBound) {
        this(lowerBound.getZone());
        this.setAutoRanging(false);
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
    }

    public ZonedDateTimeAxis(String axisLabel, ZonedDateTime lowerBound, ZonedDateTime upperBound) {
        this(lowerBound, upperBound);
        this.setLabel(axisLabel);
    }

    public void invalidateRange(List<ZonedDateTime> list) {
        super.invalidateRange(list);
        Collections.sort(list);
        if (list.isEmpty()) {
            this.minDate = this.maxDate = ZonedDateTime.now((ZoneId)this.zoneId.getValue());
        } else if (list.size() == 1) {
            this.minDate = this.maxDate = list.get(0);
        } else if (list.size() > 1) {
            this.minDate = list.get(0);
            this.maxDate = list.get(list.size() - 1);
        }
    }

    protected Object autoRange(double length) {
        if (this.isAutoRanging()) {
            return new Object[]{this.minDate, this.maxDate};
        }
        if (this.getLowerBound() == null || this.getUpperBound() == null) {
            throw new IllegalArgumentException("If autoRanging is false, a lower and upper bound must be set.");
        }
        return this.getRange();
    }

    protected void setRange(Object range, boolean animating) {
        Object[] r = (Object[])range;
        ZonedDateTime oldLowerBound = this.getLowerBound();
        ZonedDateTime oldUpperBound = this.getUpperBound();
        ZonedDateTime lower = (ZonedDateTime)r[0];
        ZonedDateTime upper = (ZonedDateTime)r[1];
        this.setLowerBound(lower);
        this.setUpperBound(upper);
        this.currentLowerBound.set(this.getLowerBound().toEpochSecond());
        this.currentUpperBound.set(this.getUpperBound().toEpochSecond());
    }

    protected Object getRange() {
        return new Object[]{this.getLowerBound(), this.getUpperBound()};
    }

    public double getZeroPosition() {
        return 0.0;
    }

    public double getDisplayPosition(ZonedDateTime date) {
        double length = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double diff = this.currentUpperBound.get() - this.currentLowerBound.get();
        double range = length - this.getZeroPosition();
        double d = (double)(date.toEpochSecond() - this.currentLowerBound.get()) / diff;
        if (this.getSide().isVertical()) {
            return this.getHeight() - d * range + this.getZeroPosition();
        }
        return d * range + this.getZeroPosition();
    }

    public ZonedDateTime getValueForDisplay(double displayPosition) {
        double length = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double diff = this.currentUpperBound.get() - this.currentLowerBound.get();
        double range = length - this.getZeroPosition();
        if (this.getSide().isVertical()) {
            long v = Math.round((displayPosition - this.getZeroPosition() - this.getHeight()) / -range * diff + (double)this.currentLowerBound.get());
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(v), (ZoneId)this.zoneId.getValue());
        }
        long v = Math.round((displayPosition - this.getZeroPosition()) / range * diff + (double)this.currentLowerBound.get());
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(v), (ZoneId)this.zoneId.getValue());
    }

    public boolean isValueOnAxis(ZonedDateTime date) {
        return date.toEpochSecond() > this.currentLowerBound.get() && date.toEpochSecond() < this.currentUpperBound.get();
    }

    public double toNumericValue(ZonedDateTime date) {
        return date.toEpochSecond();
    }

    public ZonedDateTime toRealValue(double v) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(Math.round(v)), (ZoneId)this.zoneId.getValue());
    }

    protected List<ZonedDateTime> calculateTickValues(double v, Object range) {
        Object[] r = (Object[])range;
        ZonedDateTime lower = (ZonedDateTime)r[0];
        ZonedDateTime upper = (ZonedDateTime)r[1];
        ArrayList<ZonedDateTime> dateList = new ArrayList<ZonedDateTime>();
        double averageTickGap = 100.0;
        double averageTicks = v / averageTickGap;
        for (int i = 0; i < Interval.values().length && (double)dateList.size() <= averageTicks; ++i) {
            Interval interval = Interval.values()[i];
            ZonedDateTime currentLower = ZonedDateTime.from(lower);
            ZonedDateTime currentUpper = ZonedDateTime.from(upper);
            dateList.clear();
            this.actualInterval = interval;
            while (currentLower.toEpochSecond() <= currentUpper.toEpochSecond()) {
                dateList.add(currentLower);
                currentLower = currentLower.plus(interval.amount, interval.unit);
            }
        }
        dateList.add(upper);
        List<ZonedDateTime> evenDateList = this.makeDatesEven(dateList);
        if (evenDateList.size() > 2) {
            ZonedDateTime secondDate = evenDateList.get(1);
            ZonedDateTime thirdDate = evenDateList.get(2);
            ZonedDateTime lastDate = evenDateList.get(dateList.size() - 2);
            ZonedDateTime previousLastDate = evenDateList.get(dateList.size() - 3);
            if (upper.toEpochSecond() - lastDate.toEpochSecond() < (lastDate.toEpochSecond() - previousLastDate.toEpochSecond()) / 2L) {
                evenDateList.remove(lastDate);
            }
        }
        return evenDateList;
    }

    protected void layoutChildren() {
        if (!this.isAutoRanging()) {
            this.currentLowerBound.set(this.getLowerBound().toEpochSecond());
            this.currentUpperBound.set(this.getUpperBound().toEpochSecond());
        }
        super.layoutChildren();
    }

    protected String getTickMarkLabel(ZonedDateTime date) {
        DateTimeFormatter formatter;
        StringConverter<ZonedDateTime> converter = this.getTickLabelFormatter();
        if (converter != null) {
            return converter.toString((Object)date);
        }
        if (this.actualInterval.unit == ChronoUnit.YEARS && date.getMonthValue() == 1 && date.getDayOfMonth() == 1) {
            formatter = DateTimeFormatter.ofPattern("yyyy");
        } else if (this.actualInterval.unit == ChronoUnit.MONTHS && date.getDayOfMonth() == 1) {
            formatter = DateTimeFormatter.ofPattern("MMM yy");
        } else {
            switch (this.actualInterval.unit) {
                default: {
                    formatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
                    break;
                }
                case HOURS: 
                case MINUTES: {
                    formatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
                    break;
                }
                case SECONDS: {
                    formatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM);
                    break;
                }
                case MILLIS: {
                    formatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL);
                }
            }
        }
        return formatter.withZone((ZoneId)this.zoneId.getValue()).format(date);
    }

    private List<ZonedDateTime> makeDatesEven(List<ZonedDateTime> dates) {
        if (dates.size() > 2) {
            ArrayList<ZonedDateTime> evenDates = new ArrayList<ZonedDateTime>();
            for (int i = 0; i < dates.size(); ++i) {
                ZonedDateTime date;
                ZonedDateTime normalizedDate = date = dates.get(i);
                boolean isFirstOrLast = i != 0 && i != dates.size() - 1;
                switch (this.actualInterval.unit) {
                    case YEARS: {
                        normalizedDate = ZonedDateTime.of(date.getYear(), isFirstOrLast ? 1 : date.getMonthValue(), isFirstOrLast ? 1 : date.getDayOfMonth(), 0, 0, 0, 6, dates.get(i).getZone());
                        break;
                    }
                    case MONTHS: {
                        normalizedDate = ZonedDateTime.of(date.getYear(), date.getMonthValue(), isFirstOrLast ? 1 : date.getDayOfMonth(), 0, 0, 0, 5, dates.get(i).getZone());
                        break;
                    }
                    case WEEKS: {
                        normalizedDate = ZonedDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, 4, dates.get(i).getZone());
                        break;
                    }
                    case DAYS: {
                        normalizedDate = ZonedDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, 3, dates.get(i).getZone());
                        break;
                    }
                    case HOURS: {
                        normalizedDate = ZonedDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), isFirstOrLast ? 0 : date.getMinute(), isFirstOrLast ? 0 : date.getSecond(), 2, dates.get(i).getZone());
                        break;
                    }
                    case MINUTES: {
                        normalizedDate = ZonedDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), isFirstOrLast ? 0 : date.getSecond(), 1, dates.get(i).getZone());
                        break;
                    }
                    case SECONDS: {
                        normalizedDate = ZonedDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), date.getSecond(), 1, dates.get(i).getZone());
                    }
                }
                evenDates.add(normalizedDate);
            }
            return evenDates;
        }
        return dates;
    }

    public final ObjectProperty<ZonedDateTime> lowerBoundProperty() {
        return this.lowerBound;
    }

    public final ZonedDateTime getLowerBound() {
        return (ZonedDateTime)this.lowerBound.get();
    }

    public final void setLowerBound(ZonedDateTime date) {
        this.lowerBound.set((Object)date);
    }

    public final ObjectProperty<ZonedDateTime> upperBoundProperty() {
        return this.upperBound;
    }

    public final ZonedDateTime getUpperBound() {
        return (ZonedDateTime)this.upperBound.get();
    }

    public final void setUpperBound(ZonedDateTime date) {
        this.upperBound.set((Object)date);
    }

    public final StringConverter<ZonedDateTime> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatter.getValue();
    }

    public final void setTickLabelFormatter(StringConverter<ZonedDateTime> value) {
        this.tickLabelFormatter.setValue(value);
    }

    public final ObjectProperty<StringConverter<ZonedDateTime>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    public ZoneId getZoneId() {
        return (ZoneId)this.zoneId.getValue();
    }

    public Property<ZoneId> zoneIdProperty() {
        return this.zoneId;
    }

    private static enum Interval {
        DECADE(ChronoUnit.YEARS, 10),
        YEAR(ChronoUnit.YEARS, 1),
        MONTH_6(ChronoUnit.MONTHS, 6),
        MONTH_3(ChronoUnit.MONTHS, 3),
        MONTH_1(ChronoUnit.MONTHS, 1),
        WEEK(ChronoUnit.WEEKS, 1),
        DAY(ChronoUnit.DAYS, 1),
        HOUR_12(ChronoUnit.HOURS, 12),
        HOUR_6(ChronoUnit.HOURS, 6),
        HOUR_3(ChronoUnit.HOURS, 3),
        HOUR_1(ChronoUnit.HOURS, 1),
        MINUTE_30(ChronoUnit.MINUTES, 30),
        MINUTE_10(ChronoUnit.MINUTES, 10),
        MINUTE_5(ChronoUnit.MINUTES, 5),
        MINUTE_1(ChronoUnit.MINUTES, 1),
        SECOND_15(ChronoUnit.SECONDS, 15),
        SECOND_5(ChronoUnit.SECONDS, 5),
        SECOND_1(ChronoUnit.SECONDS, 1),
        MILLISECOND(ChronoUnit.MILLIS, 1);

        private final int amount;
        private final transient ChronoUnit unit;

        private Interval(ChronoUnit interval, int amount) {
            this.unit = interval;
            this.amount = amount;
        }
    }
}

