/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.paint.Color;

public class ColorTableCell<T>
extends TableCell<T, Color> {
    private final ColorPicker colorPicker = new ColorPicker();

    public ColorTableCell(TableColumn<T, Color> column) {
        this.colorPicker.getStyleClass().add((Object)"button");
        this.colorPicker.getStyleClass().add((Object)"borderless-color-picker");
        this.colorPicker.editableProperty().bind((ObservableValue)column.editableProperty());
        this.colorPicker.disableProperty().bind((ObservableValue)column.editableProperty().not());
        this.colorPicker.setOnShowing(event -> {
            TableView tableView = this.getTableView();
            tableView.getSelectionModel().select(this.getTableRow().getIndex());
            tableView.edit(tableView.getSelectionModel().getSelectedIndex(), column);
        });
        this.colorPicker.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.isEditing()) {
                this.commitEdit(newValue);
            }
        });
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
    }

    protected void updateItem(Color item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setText(null);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.colorPicker.setValue((Object)item);
            this.setGraphic((Node)this.colorPicker);
        }
    }
}

