/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class ContextMenuTableViewCell<S, T>
extends TableCell<S, T> {
    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(ContextMenu contextMenu) {
        return ContextMenuTableViewCell.forTableColumn(contextMenu, null);
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(ContextMenu contextMenu, Callback<TableColumn<S, T>, TableCell<S, T>> cellFactory) {
        return column -> {
            TableCell cell;
            if (cellFactory == null) {
                cell = new TableCell();
                cell.itemProperty().addListener((observable, oldValue, newValue) -> cell.setText(newValue == null ? null : newValue.toString()));
            } else {
                cell = (TableCell)cellFactory.call(column);
            }
            cell.setContextMenu(contextMenu);
            return cell;
        };
    }

    public ContextMenuTableViewCell(ContextMenu contextMenu) {
        this.setContextMenu(contextMenu);
    }
}

