/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import javafx.scene.control.ContextMenu;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.util.Callback;

public class ContextMenuTreeViewCell<T>
extends TreeCell<T> {
    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(ContextMenu contextMenu) {
        return ContextMenuTreeViewCell.forTreeView(contextMenu, null);
    }

    public static <T> Callback<TreeView<T>, TreeCell<T>> forTreeView(ContextMenu contextMenu, Callback<TreeView<T>, TreeCell<T>> cellFactory) {
        return treeView -> {
            TreeCell cell;
            if (cellFactory == null) {
                cell = new TreeCell();
                cell.itemProperty().addListener((observable, oldValue, newValue) -> cell.setText(newValue == null ? null : newValue.toString()));
            } else {
                cell = (TreeCell)cellFactory.call(treeView);
            }
            cell.setContextMenu(contextMenu);
            return cell;
        };
    }

    public ContextMenuTreeViewCell(ContextMenu contextMenu) {
        this.setContextMenu(contextMenu);
    }
}

