/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import java.text.DecimalFormat;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;

public class DecimalFormatTableCellFactory<S, T>
implements Callback<TableColumn<S, T>, TableCell<S, T>> {
    private TextAlignment alignment;
    private DecimalFormat formatter;
    private String formatPattern;

    public TextAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(TextAlignment alignment) {
        this.alignment = alignment;
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public void setPattern(String format) {
        this.formatPattern = format;
        this.formatter = new DecimalFormat(this.formatPattern);
    }

    public TableCell<S, T> call(TableColumn<S, T> p) {
        TableCell cell = new TableCell<S, T>(){

            public void updateItem(Object item, boolean empty) {
                if (item == this.getItem()) {
                    return;
                }
                super.updateItem(item, empty);
                if (item == null) {
                    super.setText(null);
                    super.setGraphic(null);
                } else if (DecimalFormatTableCellFactory.this.formatter != null) {
                    super.setText(DecimalFormatTableCellFactory.this.formatter.format(item));
                } else if (item instanceof Node) {
                    super.setText(null);
                    super.setGraphic((Node)item);
                } else {
                    super.setText(item.toString());
                    super.setGraphic(null);
                }
            }
        };
        cell.setTextAlignment(this.alignment);
        switch (this.alignment) {
            case CENTER: {
                cell.setAlignment(Pos.CENTER);
                break;
            }
            case RIGHT: {
                cell.setAlignment(Pos.CENTER_RIGHT);
                break;
            }
            default: {
                cell.setAlignment(Pos.CENTER_LEFT);
            }
        }
        return cell;
    }
}

