/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;

public class EditableTab
extends Tab {
    private final Label label;

    public String getName() {
        return this.label.textProperty().getValue();
    }

    public Property<String> nameProperty() {
        return this.label.textProperty();
    }

    public void setName(String tabName) {
        this.label.textProperty().setValue(tabName);
    }

    public EditableTab(String text) {
        this.label = new Label(text);
        this.label.textProperty();
        this.setGraphic((Node)this.label);
        TextField textField = new TextField();
        this.label.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                textField.setText(this.label.getText());
                this.setGraphic((Node)textField);
                textField.selectAll();
                textField.requestFocus();
            }
        });
        textField.setOnAction(event -> {
            if (!textField.getText().isEmpty()) {
                this.label.setText(textField.getText());
            }
            this.setGraphic((Node)this.label);
        });
        textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                if (!textField.getText().isEmpty()) {
                    this.label.setText(textField.getText());
                }
                this.setGraphic((Node)this.label);
            }
        });
    }

    public void rename(String text) {
        this.label.setText(text);
    }
}

