/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import eu.fthevenet.util.javafx.bindings.BindingManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.SVGPath;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TearableTabPane
extends TabPane
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(TearableTabPane.class);
    private boolean tearable;
    private boolean reorderable;
    private Function<ActionEvent, Optional<Tab>> newTabFactory = e -> Optional.of(new Tab());
    private final Map<Tab, TabState> tearableTabMap = new HashMap<Tab, TabState>();
    private final TabPaneManager manager;
    private EventHandler<ActionEvent> onAddNewTab;
    private EventHandler<WindowEvent> onOpenNewWindow;
    private EventHandler<WindowEvent> onClosingWindow;
    private BindingManager bindingManager = new BindingManager();

    public TearableTabPane() {
        this(new TabPaneManager(), false, false, null);
    }

    public TearableTabPane(TabPaneManager manager, boolean reorderable, boolean tearable, Tab ... tabs) {
        super(tabs);
        this.manager = manager;
        this.tearable = tearable;
        this.reorderable = reorderable;
        this.bindingManager.attachListener((ObservableValue<?>)this.getSelectionModel().selectedItemProperty(), (ChangeListener<?>)((ChangeListener)(observable, oldValue, newValue) -> this.manager.setSelectedTab((Tab)newValue)));
        this.getTabs().addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    for (Tab t : c.getAddedSubList()) {
                        this.tearableTabMap.put(t, new TabState(true));
                        this.manager.addTab(t, this);
                    }
                }
                if (!c.wasRemoved()) continue;
                for (Tab t : c.getRemoved()) {
                    this.tearableTabMap.remove(t);
                    this.manager.removeTab(t);
                }
            }
            logger.trace(() -> "Tearable tabs in tab pane: " + this.tearableTabMap.keySet().stream().map(tab -> tab.getText() == null ? tab.toString() : tab.getText()).reduce((s, s2) -> s + " " + s2).orElse("null"));
        });
        this.setOnDragDetected(event -> {
            Tab currentTab;
            if (!this.tearable) {
                return;
            }
            if (event.getSource() instanceof TabPane && (currentTab = (Tab)this.getSelectionModel().getSelectedItem()) != null) {
                SnapshotParameters snapshotParams = new SnapshotParameters();
                WritableImage snapshot = currentTab.getContent().snapshot(snapshotParams, null);
                Dragboard db = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.put((Object)manager.getDragAndDropFormat(), (Object)manager.getId(currentTab));
                db.setDragView((Image)snapshot, -5.0, -5.0);
                db.setContent((Map)clipboardContent);
                manager.startDragAndDrop();
            }
            event.consume();
        });
        this.setOnDragOver(event -> {
            if (!this.tearable) {
                return;
            }
            Dragboard db = event.getDragboard();
            if (db.hasContent(manager.getDragAndDropFormat())) {
                String id = (String)db.getContent(manager.getDragAndDropFormat());
                Tab t = manager.getTab(id);
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                event.consume();
            }
        });
        this.setOnDragDone(event -> {
            if (!this.tearable || event.isDropCompleted()) {
                return;
            }
            Dragboard db = event.getDragboard();
            if (manager.completeDragAndDrop() && db.hasContent(manager.getDragAndDropFormat())) {
                String id = (String)db.getContent(manager.getDragAndDropFormat());
                logger.trace(() -> "setOnDragDone fired");
                Tab t = manager.getTab(id);
                manager.setMovingTab(true);
                try {
                    this.tearOffTab(t);
                }
                finally {
                    manager.setMovingTab(false);
                }
            }
            event.consume();
        });
        this.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            if (db.hasContent(manager.getDragAndDropFormat())) {
                logger.trace(() -> "setOnDragDropped fired");
                if (manager.completeDragAndDrop()) {
                    String id = (String)db.getContent(manager.getDragAndDropFormat());
                    Tab t = manager.getTab(id);
                    if (t != null) {
                        TabPane p = manager.getTabPane(t);
                        if (reorderable || !this.equals(p)) {
                            manager.setMovingTab(true);
                            try {
                                p.getTabs().remove((Object)t);
                                this.getTabs().add((Object)t);
                                this.getSelectionModel().select((Object)t);
                                this.bringStageToFront();
                            }
                            finally {
                                manager.setMovingTab(false);
                            }
                        } else {
                            logger.debug(() -> "Tabs on this pane cannot be reordered");
                        }
                    } else {
                        logger.debug(() -> "Failed to retrieve tab with id " + (id != null ? id : "null"));
                    }
                }
                event.consume();
            }
        });
        Platform.runLater(() -> {
            this.positionNewTabButton();
            Stage stage = (Stage)this.getScene().getWindow();
            this.bindingManager.attachListener((ObservableValue<?>)stage.focusedProperty(), (ChangeListener<?>)((ChangeListener)(observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    manager.setSelectedTab((Tab)this.getSelectionModel().getSelectedItem());
                }
            }));
        });
        this.bindingManager.attachListener((ObservableValue<?>)this.sideProperty(), (ChangeListener<?>)((ChangeListener)(observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.positionNewTabButton();
            }
        }));
    }

    public Function<ActionEvent, Optional<Tab>> getNewTabFactory() {
        return this.newTabFactory;
    }

    public void setNewTabFactory(Function<ActionEvent, Optional<Tab>> newTabFactory) {
        this.newTabFactory = newTabFactory;
    }

    public void setOnAddNewTab(EventHandler<ActionEvent> onAddNewTab) {
        this.onAddNewTab = onAddNewTab;
    }

    public boolean isTearable() {
        return this.tearable;
    }

    public void setTearable(boolean tearable) {
        this.tearable = tearable;
    }

    public boolean isReorderable() {
        return this.reorderable;
    }

    public void setReorderable(boolean reorderable) {
        this.reorderable = reorderable;
    }

    public Tab getSelectedTab() {
        return this.manager.getSelectedTab();
    }

    public TabPane getSelectedTabPane() {
        if (this.manager.getSelectedTab() == null || this.manager.tabToPaneMap.get((Object)this.manager.getSelectedTab()) == null) {
            return this;
        }
        return (TabPane)this.manager.tabToPaneMap.get((Object)this.getSelectedTab());
    }

    public ObservableList<Tab> getGlobalTabs() {
        return this.manager.getGlobalTabList();
    }

    public void clearAllTabs() {
        this.manager.clearAllTabs();
    }

    public void setOnOpenNewWindow(EventHandler<WindowEvent> action) {
        this.onOpenNewWindow = action;
    }

    public void setOnClosingWindow(EventHandler<WindowEvent> action) {
        this.onClosingWindow = action;
    }

    public DataFormat getDataFormat() {
        return this.manager.dragAndDropFormat;
    }

    private void positionNewTabButton() {
        Pane tabHeaderBg = (Pane)this.lookup(".tab-header-background");
        if (tabHeaderBg == null) {
            return;
        }
        Pane tabHeaderArea = (Pane)this.lookup(".tab-header-area");
        logger.debug("tabHeaderArea.getHeight() = " + tabHeaderArea.getHeight());
        Button newTabButton = (Button)tabHeaderBg.lookup("#newTabButton");
        if (newTabButton != null) {
            tabHeaderBg.getChildren().remove((Object)newTabButton);
        }
        newTabButton = new Button();
        newTabButton.setId("newTabButton");
        newTabButton.setFocusTraversable(false);
        Pane headersRegion = (Pane)this.lookup(".headers-region");
        Region headerArea = (Region)this.lookup(".tab-header-area");
        logger.debug("headersRegion.getHeight() = " + headersRegion.getHeight());
        logger.debug("headersRegion.getPrefHeight = " + headersRegion.getPrefHeight());
        newTabButton.getStyleClass().add((Object)"add-tab-button");
        SVGPath icon = new SVGPath();
        icon.setContent("m 31.25,54.09375 0,2.4375 -2.46875,0 0,0.375 2.46875,0 0,2.46875 0.375,0 0,-2.46875 2.46875,0 0,-0.375 -2.46875,0 0,-2.4375 -0.375,0 z");
        icon.getStyleClass().add((Object)"add-tab-button-icon");
        newTabButton.setGraphic((Node)icon);
        newTabButton.setAlignment(Pos.CENTER);
        if (this.onAddNewTab != null) {
            newTabButton.setOnAction(this.onAddNewTab);
        } else {
            newTabButton.setOnAction(event -> this.newTabFactory.apply((ActionEvent)event).ifPresent(newTab -> {
                this.getTabs().add(newTab);
                this.getSelectionModel().select(newTab);
            }));
        }
        tabHeaderBg.getChildren().add((Object)newTabButton);
        StackPane.setAlignment((Node)newTabButton, (Pos)Pos.CENTER_LEFT);
        switch (this.getSide()) {
            case TOP: 
            case BOTTOM: {
                newTabButton.translateXProperty().bind((ObservableValue)headersRegion.widthProperty().add((ObservableNumberValue)Bindings.createDoubleBinding(() -> headerArea.getInsets().getLeft(), (Observable[])new Observable[]{headerArea.insetsProperty()})));
                break;
            }
            case LEFT: 
            case RIGHT: {
                newTabButton.translateXProperty().bind((ObservableValue)tabHeaderBg.widthProperty().subtract((ObservableNumberValue)headersRegion.widthProperty()).subtract((ObservableNumberValue)newTabButton.widthProperty()).subtract((ObservableNumberValue)Bindings.createDoubleBinding(() -> headerArea.getInsets().getTop(), (Observable[])new Observable[]{headerArea.insetsProperty()})));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid value for side enum");
            }
        }
    }

    private void bringStageToFront() {
        Stage stage;
        if (this.getScene() != null && (stage = (Stage)this.getScene().getWindow()) != null) {
            stage.toFront();
        }
    }

    private void tearOffTab(Tab tab) {
        TearableTabPane detachedTabPane = new TearableTabPane(this.manager, false, true, new Tab[0]);
        detachedTabPane.setOnOpenNewWindow(this.onOpenNewWindow);
        detachedTabPane.setNewTabFactory(this.getNewTabFactory());
        this.getTabs().remove((Object)tab);
        detachedTabPane.getTabs().add((Object)tab);
        AnchorPane root = new AnchorPane(new Node[]{detachedTabPane});
        AnchorPane.setBottomAnchor((Node)detachedTabPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)detachedTabPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)detachedTabPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)detachedTabPane, (Double)0.0);
        Scene scene = new Scene((Parent)root, root.getPrefWidth(), root.getPrefHeight());
        Stage stage = new Stage();
        stage.setScene(scene);
        Point p = MouseInfo.getPointerInfo().getLocation();
        stage.setX(p.getX());
        stage.setY(p.getY());
        detachedTabPane.getTabs().addListener(c -> {
            if (c.getList().size() == 0) {
                if (this.onClosingWindow != null) {
                    this.onClosingWindow.handle((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_CLOSE_REQUEST));
                }
                stage.close();
                this.close();
            }
        });
        if (this.onOpenNewWindow != null) {
            this.onOpenNewWindow.handle((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_SHOWING));
        }
        stage.show();
        detachedTabPane.getSelectionModel().select((Object)tab);
        stage.setOnCloseRequest(event -> detachedTabPane.getTabs().removeAll((Collection)detachedTabPane.getTabs()));
    }

    @Override
    public void close() {
        logger.trace(() -> "Closing down TearableTabPane instance");
        this.bindingManager.close();
    }

    protected static class TabPaneManager {
        private final ObservableMap<Tab, TabPane> tabToPaneMap = FXCollections.observableMap(new HashMap());
        private final Map<String, Tab> idToTabMap = new HashMap<String, Tab>();
        private final ObservableList<Tab> globalTabList = FXCollections.observableList(new ArrayList());
        private final DataFormat dragAndDropFormat = new DataFormat(new String[]{UUID.randomUUID().toString()});
        private final AtomicBoolean dndComplete = new AtomicBoolean(true);
        private Tab selectedTab;
        private boolean movingTab;

        public void startDragAndDrop() {
            this.dndComplete.set(false);
        }

        public boolean completeDragAndDrop() {
            return this.dndComplete.compareAndSet(false, true);
        }

        public void addTab(Tab tab, TabPane pane) {
            this.idToTabMap.put(this.getId(tab), tab);
            this.tabToPaneMap.put((Object)tab, (Object)pane);
            if (!this.movingTab) {
                this.globalTabList.add((Object)tab);
            }
        }

        public void removeTab(Tab tab) {
            this.idToTabMap.remove(this.getId(tab));
            this.tabToPaneMap.remove((Object)tab);
            if (!this.movingTab) {
                this.globalTabList.remove((Object)tab);
            }
        }

        public TabPane getTabPane(Tab tab) {
            return (TabPane)this.tabToPaneMap.get((Object)tab);
        }

        public String getId(Tab tab) {
            return Integer.toString(tab.hashCode());
        }

        public Tab getTab(String id) {
            return this.idToTabMap.get(id);
        }

        public DataFormat getDragAndDropFormat() {
            return this.dragAndDropFormat;
        }

        private ObservableList<Tab> getGlobalTabList() {
            return this.globalTabList;
        }

        public Tab getSelectedTab() {
            return this.selectedTab;
        }

        public void setSelectedTab(Tab selectedTab) {
            this.selectedTab = selectedTab;
            logger.trace(() -> "Selected Tab: " + (selectedTab == null ? "null" : selectedTab.toString() + " " + this.getId(selectedTab) + " " + this.tabToPaneMap.get((Object)selectedTab)));
        }

        public void setMovingTab(boolean movingTab) {
            this.movingTab = movingTab;
        }

        public void clearAllTabs() {
            this.tabToPaneMap.values().stream().distinct().collect(Collectors.toList()).forEach(p -> p.getTabs().clear());
        }
    }

    private class TabState {
        private boolean attached;

        public boolean isAttached() {
            return this.attached;
        }

        public void setAttached(boolean attached) {
            this.attached = attached;
        }

        public TabState(boolean attached) {
            this.attached = attached;
        }
    }
}

