/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import eu.fthevenet.util.javafx.controls.ZonedDateTimePicker;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.textfield.TextFields;

public class TimeRangePicker
extends ToggleButton {
    private static final Logger logger = LogManager.getLogger(TimeRangePicker.class);
    private TimeRangePickerController timeRangePickerController;
    private final PopupControl popup;
    private final Property<ZoneId> zoneId = new SimpleObjectProperty((Object)ZoneId.systemDefault());
    private final Property<TimeRange> selectedRange = new SimpleObjectProperty((Object)new TimeRange(ZonedDateTime.now().minusHours(1L), ZonedDateTime.now()));
    private ChangeListener<ZonedDateTime> onStartDateChanged = (observable, oldValue, newValue) -> {
        if (newValue != null) {
            TimeRange newRange = TimeRange.of(newValue, this.timeRangePickerController.endDate.getDateTimeValue());
            if (newRange.isNegative()) {
                TimeRange oldRange = TimeRange.of(oldValue, this.timeRangePickerController.endDate.getDateTimeValue());
                this.selectedRange.setValue((Object)TimeRange.of(newValue, newValue.plus(oldRange.duration)));
            } else {
                this.selectedRange.setValue((Object)newRange);
            }
        }
    };
    private ChangeListener<ZonedDateTime> onEndDateChanged = (observable, oldValue, newValue) -> {
        if (newValue != null) {
            TimeRange newRange = TimeRange.of(this.timeRangePickerController.startDate.getDateTimeValue(), newValue);
            if (newRange.isNegative()) {
                TimeRange oldRange = TimeRange.of(this.timeRangePickerController.startDate.getDateTimeValue(), oldValue);
                this.selectedRange.setValue((Object)TimeRange.of(newValue.minus(oldRange.duration), newValue));
            } else {
                this.selectedRange.setValue((Object)newRange);
            }
        }
    };

    public TimeRangePicker() throws IOException {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/views/TimeRangePickerView.fxml"));
        this.timeRangePickerController = new TimeRangePickerController();
        loader.setController((Object)this.timeRangePickerController);
        Pane timeRangePickerPane = (Pane)loader.load();
        this.popup = new PopupControl();
        this.popup.setAutoHide(true);
        this.popup.getScene().setRoot((Parent)timeRangePickerPane);
        this.popup.showingProperty().addListener((observable, oldValue, newValue) -> this.setSelected((boolean)newValue));
        this.timeRangePickerController.startDate.zoneIdProperty().bind(this.zoneId);
        this.timeRangePickerController.endDate.zoneIdProperty().bind(this.zoneId);
        this.zoneId.addListener((observable, oldValue, newValue) -> this.updateText());
        this.timeRangePickerController.zoneIdProperty().bindBidirectional(this.zoneId);
        this.setOnAction(actionEvent -> {
            Node owner = (Node)actionEvent.getSource();
            Bounds bounds = owner.localToScreen(owner.getBoundsInLocal());
            this.popup.show(owner.getScene().getWindow(), bounds.getMinX(), bounds.getMaxY());
        });
        this.timeRangePickerController.applyNewTimeRange = (beginning, end) -> this.selectedRange.setValue((Object)TimeRange.of(beginning, end));
        this.selectedRange.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.suspendDateListeners();
                try {
                    this.timeRangePickerController.startDate.setDateTimeValue(newValue.getBeginning());
                    this.timeRangePickerController.endDate.setDateTimeValue(newValue.getEnd());
                }
                finally {
                    this.resumeDateListeners();
                    this.updateText();
                }
            }
        });
        this.timeRangePickerController.startDate.setDateTimeValue(((TimeRange)this.selectedRange.getValue()).getBeginning());
        this.timeRangePickerController.endDate.setDateTimeValue(((TimeRange)this.selectedRange.getValue()).getEnd());
        this.resumeDateListeners();
    }

    private void resumeDateListeners() {
        this.timeRangePickerController.startDate.dateTimeValueProperty().addListener(this.onStartDateChanged);
        this.timeRangePickerController.endDate.dateTimeValueProperty().addListener(this.onEndDateChanged);
    }

    private void suspendDateListeners() {
        this.timeRangePickerController.startDate.dateTimeValueProperty().removeListener(this.onStartDateChanged);
        this.timeRangePickerController.endDate.dateTimeValueProperty().removeListener(this.onEndDateChanged);
    }

    public ZoneId getZoneId() {
        return (ZoneId)this.zoneId.getValue();
    }

    public Property<ZoneId> zoneIdProperty() {
        return this.zoneId;
    }

    private void updateText() {
        this.setText(String.format("From %s to %s (%s)", this.timeRangePickerController.startDate.getDateTimeValue().format(this.timeRangePickerController.startDate.getFormatter()), this.timeRangePickerController.endDate.getDateTimeValue().format(this.timeRangePickerController.endDate.getFormatter()), this.getZoneId().toString()));
    }

    public TimeRange getSelectedRange() {
        return (TimeRange)this.selectedRange.getValue();
    }

    public Property<TimeRange> selectedRangeProperty() {
        return this.selectedRange;
    }

    public void setSelectedRange(TimeRange selectedRange) {
        this.selectedRange.setValue((Object)selectedRange);
    }

    public void updateRangeBeginning(ZonedDateTime newValue) {
        this.suspendDateListeners();
        try {
            this.timeRangePickerController.startDate.setDateTimeValue(newValue);
            this.updateText();
        }
        finally {
            this.resumeDateListeners();
        }
    }

    public void updateRangeEnd(ZonedDateTime newValue) {
        this.suspendDateListeners();
        try {
            this.timeRangePickerController.endDate.setDateTimeValue(newValue);
            this.updateText();
        }
        finally {
            this.resumeDateListeners();
        }
    }

    public static class TimeRange {
        private final ZonedDateTime beginning;
        private final ZonedDateTime end;
        private final Duration duration;

        public static TimeRange of(ZonedDateTime beginning, ZonedDateTime end) {
            return new TimeRange(beginning, end);
        }

        private TimeRange(ZonedDateTime beginning, ZonedDateTime end) {
            this.beginning = beginning;
            this.end = end;
            this.duration = Duration.between(beginning, end);
        }

        public ZonedDateTime getBeginning() {
            return this.beginning;
        }

        public ZonedDateTime getEnd() {
            return this.end;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public boolean isNegative() {
            return this.duration.isNegative();
        }
    }

    private class TimeRangePickerController {
        @FXML
        private ResourceBundle resources;
        @FXML
        private URL location;
        @FXML
        private AnchorPane root;
        @FXML
        private Button previousIntervalBtn;
        @FXML
        private ZonedDateTimePicker startDate;
        @FXML
        private ZonedDateTimePicker endDate;
        @FXML
        private Button nextIntervalBtn;
        @FXML
        private TextField timezoneField;
        @FXML
        private Button last6Hours;
        @FXML
        private Button last3Hours;
        @FXML
        private Button last24Hours;
        @FXML
        private Button last7Days;
        @FXML
        private Button last15Days;
        @FXML
        private Button last30Days;
        @FXML
        private Button last90Days;
        @FXML
        private Button last15Minutes;
        @FXML
        private Button last30Minutes;
        @FXML
        private Button last60Minutes;
        @FXML
        private Button last12Hours;
        @FXML
        private Button last90Minutes;
        @FXML
        private Button today;
        @FXML
        private Button yesterday;
        @FXML
        private Button thisWeek;
        @FXML
        private Button lastWeek;
        private TextFormatter<ZoneId> formatter;
        private BiConsumer<ZonedDateTime, ZonedDateTime> applyNewTimeRange = (start, end) -> {
            this.startDate.dateTimeValueProperty().setValue(start);
            this.endDate.dateTimeValueProperty().setValue(end);
        };

        private TimeRangePickerController() {
        }

        private void stepBy(Duration intervalDuration) {
            this.applyNewTimeRange.accept(this.startDate.getDateTimeValue().plus(intervalDuration), this.endDate.getDateTimeValue().plus(intervalDuration));
        }

        private void last(Duration duration) {
            ZonedDateTime end = ZonedDateTime.now((ZoneId)TimeRangePicker.this.zoneId.getValue());
            this.applyNewTimeRange.accept(end.minus(duration), end);
        }

        @FXML
        void initialize() {
            this.formatter = new TextFormatter((StringConverter)new StringConverter<ZoneId>(){

                public String toString(ZoneId object) {
                    if (object == null) {
                        return "null";
                    }
                    return object.toString();
                }

                public ZoneId fromString(String string) {
                    return ZoneId.of(string);
                }
            });
            TextFields.bindAutoCompletion((TextField)this.timezoneField, ZoneId.getAvailableZoneIds());
            this.timezoneField.setTextFormatter(this.formatter);
            this.nextIntervalBtn.setOnAction(event -> this.stepBy(Duration.between(this.startDate.getDateTimeValue(), this.endDate.getDateTimeValue())));
            this.previousIntervalBtn.setOnAction(event -> this.stepBy(Duration.between(this.endDate.getDateTimeValue(), this.startDate.getDateTimeValue())));
            this.last3Hours.setOnAction(event -> this.last(Duration.of(3L, ChronoUnit.HOURS)));
            this.last6Hours.setOnAction(event -> this.last(Duration.of(6L, ChronoUnit.HOURS)));
            this.last12Hours.setOnAction(event -> this.last(Duration.of(12L, ChronoUnit.HOURS)));
            this.last24Hours.setOnAction(event -> this.last(Duration.of(24L, ChronoUnit.HOURS)));
            this.last7Days.setOnAction(event -> this.last(Duration.of(7L, ChronoUnit.DAYS)));
            this.last15Days.setOnAction(event -> this.last(Duration.of(15L, ChronoUnit.DAYS)));
            this.last30Days.setOnAction(event -> this.last(Duration.of(30L, ChronoUnit.DAYS)));
            this.last90Days.setOnAction(event -> this.last(Duration.of(90L, ChronoUnit.DAYS)));
            this.last15Minutes.setOnAction(event -> this.last(Duration.of(15L, ChronoUnit.MINUTES)));
            this.last30Minutes.setOnAction(event -> this.last(Duration.of(30L, ChronoUnit.MINUTES)));
            this.last60Minutes.setOnAction(event -> this.last(Duration.of(60L, ChronoUnit.MINUTES)));
            this.last90Minutes.setOnAction(event -> this.last(Duration.of(90L, ChronoUnit.MINUTES)));
            this.today.setOnAction(event -> {
                LocalDate today = LocalDate.now((ZoneId)TimeRangePicker.this.zoneId.getValue());
                this.applyNewTimeRange.accept(ZonedDateTime.of(today, LocalTime.MIDNIGHT, (ZoneId)TimeRangePicker.this.zoneId.getValue()), ZonedDateTime.of(today.plusDays(1L), LocalTime.MIDNIGHT, (ZoneId)TimeRangePicker.this.zoneId.getValue()));
            });
            this.yesterday.setOnAction(event -> {
                LocalDate today = LocalDate.now((ZoneId)TimeRangePicker.this.zoneId.getValue());
                this.applyNewTimeRange.accept(ZonedDateTime.of(today.minusDays(1L), LocalTime.MIDNIGHT, (ZoneId)TimeRangePicker.this.zoneId.getValue()), ZonedDateTime.of(today, LocalTime.MIDNIGHT, (ZoneId)TimeRangePicker.this.zoneId.getValue()));
            });
            this.thisWeek.setOnAction(event -> {
                LocalDate refDay = LocalDate.now((ZoneId)TimeRangePicker.this.zoneId.getValue());
                int n = refDay.getDayOfWeek().getValue();
                this.applyNewTimeRange.accept(ZonedDateTime.of(refDay.minusDays(n - 1), LocalTime.MIDNIGHT, (ZoneId)TimeRangePicker.this.zoneId.getValue()), ZonedDateTime.of(refDay.plusDays(8 - n), LocalTime.MIDNIGHT, (ZoneId)TimeRangePicker.this.zoneId.getValue()));
            });
            this.lastWeek.setOnAction(event -> {
                LocalDate refDay = LocalDate.now((ZoneId)TimeRangePicker.this.zoneId.getValue()).minusWeeks(1L);
                int n = refDay.getDayOfWeek().getValue();
                this.applyNewTimeRange.accept(ZonedDateTime.of(refDay.minusDays(n - 1), LocalTime.MIDNIGHT, (ZoneId)TimeRangePicker.this.zoneId.getValue()), ZonedDateTime.of(refDay.plusDays(8 - n), LocalTime.MIDNIGHT, (ZoneId)TimeRangePicker.this.zoneId.getValue()));
            });
        }

        Property<ZoneId> zoneIdProperty() {
            return this.formatter.valueProperty();
        }
    }
}

