/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.scene.control.TreeItem;

public class TreeViewUtils {
    public static <T> Optional<TreeItem<T>> findFirstInTree(TreeItem<T> currentTreeItem, Predicate<TreeItem<T>> predicate) {
        if (predicate.test(currentTreeItem)) {
            return Optional.of(currentTreeItem);
        }
        if (!currentTreeItem.isLeaf()) {
            for (TreeItem item : currentTreeItem.getChildren()) {
                Optional<TreeItem<T>> res = TreeViewUtils.findFirstInTree(item, predicate);
                if (!res.isPresent()) continue;
                return res;
            }
        }
        return Optional.empty();
    }

    public static <T> List<TreeItem<T>> findAllInTree(TreeItem<T> currentTreeItem, Predicate<TreeItem<T>> predicate) {
        return TreeViewUtils.findAllInTree(currentTreeItem, predicate, new ArrayList<TreeItem<T>>());
    }

    private static <T> List<TreeItem<T>> findAllInTree(TreeItem<T> currentTreeItem, Predicate<TreeItem<T>> predicate, List<TreeItem<T>> found) {
        if (predicate.test(currentTreeItem)) {
            found.add(currentTreeItem);
        }
        if (!currentTreeItem.isLeaf()) {
            for (TreeItem item : currentTreeItem.getChildren()) {
                TreeViewUtils.findAllInTree(item, predicate, found);
            }
        }
        return found;
    }
}

