/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.javafx.controls;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.DatePicker;
import javafx.util.StringConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZonedDateTimePicker
extends DatePicker {
    private static final Logger logger = LogManager.getLogger(ZonedDateTimePicker.class);
    private final Property<ZoneId> zoneId;
    private final ObjectProperty<ZonedDateTime> dateTimeValue;

    public ZonedDateTimePicker() {
        this(ZoneId.systemDefault());
    }

    public ZonedDateTimePicker(ZoneId zoneId) {
        this((SimpleObjectProperty<ZoneId>)new SimpleObjectProperty((Object)zoneId));
    }

    public ZonedDateTimePicker(SimpleObjectProperty<ZoneId> zoneIdProperty) {
        this.zoneId = zoneIdProperty;
        this.dateTimeValue = new SimpleObjectProperty((Object)ZonedDateTime.now((ZoneId)zoneIdProperty.get()));
        this.getStyleClass().add((Object)"datetime-picker");
        this.setConverter((StringConverter)new StringConverter<LocalDate>(){

            public String toString(LocalDate object) {
                ZonedDateTime value = ZonedDateTimePicker.this.getDateTimeValue();
                return value != null ? value.format(ZonedDateTimePicker.this.getFormatter()) : "";
            }

            public LocalDate fromString(String stringValue) {
                if (stringValue == null || stringValue.isEmpty()) {
                    ZonedDateTimePicker.this.dateTimeValue.set(null);
                    return null;
                }
                try {
                    ZonedDateTimePicker.this.dateTimeValue.set((Object)ZonedDateTime.parse(stringValue, ZonedDateTimePicker.this.getFormatter()));
                    logger.trace(() -> "zonedId for dateTimeValue=" + ((ZonedDateTime)ZonedDateTimePicker.this.dateTimeValue.get()).getZone());
                }
                catch (Exception ex) {
                    logger.debug("Error parsing date", (Throwable)ex);
                    throw ex;
                }
                return ((ZonedDateTime)ZonedDateTimePicker.this.dateTimeValue.get()).toLocalDate();
            }
        });
        this.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                if (this.dateTimeValue.get() == null) {
                    this.dateTimeValue.set((Object)ZonedDateTime.of(newValue, LocalTime.now(), this.getZoneId()));
                } else {
                    LocalTime time = ((ZonedDateTime)this.dateTimeValue.get()).toLocalTime();
                    this.dateTimeValue.set((Object)ZonedDateTime.of(newValue, time, this.getZoneId()));
                }
            }
        });
        this.dateTimeValue.addListener((observable, oldValue, newValue) -> {
            this.setValue(null);
            this.setValue(newValue == null ? null : newValue.toLocalDate());
        });
        this.getEditor().focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.getEditor().commitValue();
            }
        });
        this.zoneId.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.dateTimeValue.setValue((Object)((ZonedDateTime)this.dateTimeValue.get()).withZoneSameInstant((ZoneId)newValue));
            }
        });
    }

    DateTimeFormatter getFormatter() {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.MEDIUM).withZone(this.getZoneId());
    }

    public ZonedDateTime getDateTimeValue() {
        return (ZonedDateTime)this.dateTimeValue.get();
    }

    public void setDateTimeValue(ZonedDateTime dateTimeValue) {
        this.dateTimeValue.set((Object)dateTimeValue);
    }

    public ObjectProperty<ZonedDateTime> dateTimeValueProperty() {
        return this.dateTimeValue;
    }

    public ZoneId getZoneId() {
        return (ZoneId)this.zoneId.getValue();
    }

    public Property<ZoneId> zoneIdProperty() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId.setValue((Object)zoneId);
    }
}

