/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.logging;

import java.util.concurrent.atomic.AtomicBoolean;

public final class Profiler
implements AutoCloseable {
    private final Elapsed elapsed;
    private final OutputDelegate writeCallback;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final long startTime;
    private final long thresholdMs;

    public static Profiler start(String message, OutputDelegate writeCallback) {
        return new Profiler(new Elapsed(message), writeCallback, -1L);
    }

    public static Profiler start(String message, OutputDelegate writeCallback, long threshold) {
        return new Profiler(new Elapsed(message), writeCallback, threshold);
    }

    public static Profiler start(String message) {
        return new Profiler(new Elapsed(message), null, -1L);
    }

    public static Profiler start(String message, long threshold) {
        return new Profiler(new Elapsed(message), null, threshold);
    }

    public static Profiler start(OutputDelegate writeCallback) {
        return new Profiler(new Elapsed(""), writeCallback, -1L);
    }

    public static Profiler start(OutputDelegate writeCallback, long threshold) {
        return new Profiler(new Elapsed(""), writeCallback, threshold);
    }

    public static Profiler start(Elapsed elapsed) {
        return new Profiler(elapsed, null, -1L);
    }

    public static Profiler start(Elapsed elapsed, long threshold) {
        return new Profiler(elapsed, null, threshold);
    }

    private Profiler(Elapsed elapsed, OutputDelegate writeCallback, long thresholdMs) {
        this.elapsed = elapsed;
        this.writeCallback = writeCallback;
        this.thresholdMs = thresholdMs;
        this.startTime = System.nanoTime();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            long stopTime = System.nanoTime();
            Elapsed elapsed = this.elapsed;
            elapsed.nanoSec = elapsed.nanoSec + (stopTime - this.startTime);
            if (this.writeCallback != null && this.elapsed.getMillis() >= this.thresholdMs) {
                this.writeCallback.invoke(this.elapsed);
            }
        }
    }

    public static class Elapsed {
        private String message;
        private long nanoSec;

        public Elapsed() {
            this("", 0L);
        }

        public Elapsed(String message) {
            this(message, 0L);
        }

        public Elapsed(String message, long intialValue) {
            this.nanoSec = intialValue;
            this.setMessage(message);
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public long getNanos() {
            return this.nanoSec;
        }

        public long getMicros() {
            return Math.round((double)this.nanoSec * Math.pow(10.0, -3.0));
        }

        public long getMillis() {
            return Math.round((double)this.nanoSec * Math.pow(10.0, -6.0));
        }

        public long getSeconds() {
            return Math.round((double)this.nanoSec * Math.pow(10.0, -9.0));
        }

        public String toString() {
            return this.getMessage() + ": " + this.getMillis() + " ms";
        }

        public String toNanoString() {
            return this.getMessage() + ": " + this.getNanos() + " ns";
        }

        public String toMicroString() {
            return this.getMessage() + ": " + this.getMicros() + " \u03bcs";
        }

        public String toMilliString() {
            return this.getMessage() + ": " + this.getMillis() + " ms";
        }

        public String toSecondString() {
            return this.getMessage() + ": " + this.getSeconds() + " s";
        }
    }

    public static interface OutputDelegate {
        public void invoke(Elapsed var1);
    }
}

