/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.logging;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="TextFlowAppender", category="Core", elementType="appender", printObject=true)
public final class TextFlowAppender
extends AbstractAppender {
    private static TextFlow textArea;
    private final Lock lock = new ReentrantLock();
    private final Map<Level, String> logColors = new HashMap<Level, String>();
    private final String defaultColor = "log-info";

    protected TextFlowAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this.logColors.put(Level.TRACE, "log-trace");
        this.logColors.put(Level.DEBUG, "log-debug");
        this.logColors.put(Level.INFO, "log-info");
        this.logColors.put(Level.WARN, "log-warn");
        this.logColors.put(Level.ERROR, "log-error");
        this.logColors.put(Level.FATAL, "log-fatal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        this.lock.lock();
        try {
            String message = new String(this.getLayout().toByteArray(event));
            if (textArea != null) {
                Text log = new Text(message);
                log.getStyleClass().add((Object)this.logColors.getOrDefault(event.getLevel(), "log-info"));
                Platform.runLater(() -> {
                    try {
                        textArea.getChildren().add((Object)log);
                    }
                    catch (Throwable t) {
                        System.out.println("Error while append to TextFlow: " + t.getMessage());
                    }
                });
            }
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    @PluginFactory
    public static TextFlowAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for TextFlowAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new TextFlowAppender(name, filter, (Layout<? extends Serializable>)layout, true);
    }

    public static void setTextFlow(TextFlow textFlow) {
        textArea = textFlow;
    }
}

