/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.text;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public abstract class PrefixFormatter {
    public static final String PATTERN = "###,###.##";
    protected final int base;
    private final NavigableMap<Long, String> longSuffixes = new TreeMap<Long, String>();
    private final NavigableMap<Double, String> doubleSuffixes = new TreeMap<Double, String>();

    public PrefixFormatter(int base, String[] suffixes) {
        this.base = base;
        for (int i = 0; i < suffixes.length; ++i) {
            this.longSuffixes.put(this.pow(base, i + 1), suffixes[i]);
            this.doubleSuffixes.put(Math.pow(base, (double)i + 1.0), suffixes[i]);
        }
    }

    private long pow(long a, int b) {
        if (b == 0) {
            return 1L;
        }
        if (b == 1) {
            return a;
        }
        if (b % 2 == 0) {
            return this.pow(a * a, b / 2);
        }
        return a * this.pow(a * a, b / 2);
    }

    public String format(long value) {
        if (value == Long.MIN_VALUE) {
            return this.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + this.format(-value);
        }
        if (value < (long)this.base) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = this.longSuffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public String format(double value) {
        DecimalFormat formatter = new DecimalFormat(PATTERN);
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            return "Infinite";
        }
        if (value == -9.223372036854776E18) {
            return this.format(-9223372036854775807L);
        }
        if (value < 0.0) {
            return "-" + this.format(-value);
        }
        if (value < (double)this.base) {
            return formatter.format(value);
        }
        Map.Entry<Double, String> e = this.doubleSuffixes.floorEntry(value);
        Double divideBy = e.getKey();
        String suffix = e.getValue();
        double truncated = value / (divideBy / 10.0);
        boolean hasDecimal = truncated < 100.0 && truncated / 10.0 != truncated / 10.0;
        truncated = hasDecimal ? truncated / 10.0 : truncated / 10.0;
        return formatter.format(truncated) + suffix;
    }
}

