/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Path;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlUtils {
    public static String getFirstAttributeValue(File file, String attribute) throws IOException, XMLStreamException {
        XMLStreamReader xmlr = XMLInputFactoryHolder.instance.createXMLStreamReader(new FileInputStream(file));
        while (xmlr.hasNext()) {
            switch (xmlr.getEventType()) {
                case 1: {
                    for (int i = 0; i < xmlr.getAttributeCount(); ++i) {
                        String localName = xmlr.getAttributeName(i).getLocalPart();
                        if (!localName.equals(attribute)) continue;
                        return xmlr.getAttributeValue(i);
                    }
                    return null;
                }
            }
            xmlr.next();
        }
        return null;
    }

    public static <T> T deSerialize(Class<T> docClass, File file) throws JAXBException, IOException {
        try (FileInputStream fin = new FileInputStream(file);){
            T t = XmlUtils.deSerialize(docClass, fin);
            return t;
        }
    }

    public static <T> T deSerialize(Class<T> docClass, InputStream inputStream) throws JAXBException {
        return XmlUtils.deSerialize(docClass, new StreamSource(inputStream));
    }

    public static <T> T deSerialize(Class<T> docClass, String xmlString) throws JAXBException {
        return XmlUtils.deSerialize(docClass, new StreamSource(new StringReader(xmlString)));
    }

    private static <T> T deSerialize(Class<T> docClass, StreamSource source) throws JAXBException {
        return (T)JAXB.unmarshal((Source)source, docClass);
    }

    public static Source toNonValidatingSAXSource(InputStream in) throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        XMLReader xmlReader = spf.newSAXParser().getXMLReader();
        InputSource inputSource = new InputSource(in);
        return new SAXSource(xmlReader, inputSource);
    }

    public static <T> void serialize(T object, Path path) throws JAXBException, IOException {
        XmlUtils.serialize(object, path.toFile());
    }

    public static <T> void serialize(T object, File file) throws JAXBException, IOException {
        try (FileOutputStream fout = new FileOutputStream(file);){
            XmlUtils.serialize(object, fout);
        }
    }

    public static <T> void serialize(T object, OutputStream out) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal(object, out);
    }

    private static class XMLInputFactoryHolder {
        private static final XMLInputFactory instance = XMLInputFactory.newInstance();

        private XMLInputFactoryHolder() {
        }
    }
}

