package eu.ginere.site.nodes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

import org.apache.log4j.Logger;

import eu.ginere.base.util.file.FileUtils;
import eu.ginere.site.ContextProperties;
import eu.ginere.site.PatternUtils;
import eu.ginere.site.SiteGenerator;


public abstract class Node{

	static final Logger log = Logger.getLogger(Node.class);

	private static final List<Node> EMPTY_LIST = new ArrayList<Node>(0);

	protected final SiteGenerator globalContext;

	final public File file;

	protected List <Node> childs=null;
	ContextProperties context;
	private long lastUpdated=0;
	protected final boolean isPageFile;
		
	public Node(SiteGenerator globalContext,File file,boolean isPageFile) throws FileNotFoundException {
		this.globalContext=globalContext;

		this.file=file;
		this.isPageFile=isPageFile;
	}
		
	public String getContent(ContextProperties parentContext) throws FileNotFoundException {
		this.context.setParent(parentContext);
		return updateContent(); 
	}

	public abstract String getFileName();
	
	/**
	 * IF the file is ../content/folder1/folder2/index.html, that will retun /folder1/forlder2
	 * @return
	 */
	public abstract String getRelativePath() throws FileNotFoundException;
	
	public String getRelativePath(String defaultValue) {
		try {
			return getRelativePath();
		}catch(FileNotFoundException e){
			log.warn("While getting relative path for node:"+this);
			return defaultValue;
		}
	}

	/**
	 * Update the the information asociated to this node.
	 * This aply only for page nodes.
	 * @return
	 * @throws FileNotFoundException
	 */
	public void generateOrUpdateDiskFile(ContextProperties parentContext) throws IOException {
		if (!isPage()){
			return ;
		}
			
		createChildList();
			
		this.context.setParent(parentContext);
		// We asume that the information is generated by the first time.
		// then then information has to be changed only if one of the dist files
		// of the children has been changed or the prop nothes of the context ...
			
		long childsLastModified=0; 
							
		if (getChildListSize()>0){				
			// update childs
			for (Node child:getChildList()){
				long curret=child.getLastModified();
				//					log.info("+++"+child+" date:"+new Date(curret));
				if (childsLastModified<curret){
					childsLastModified=curret;
				}
			}				
		}

		// If some child has been modified
		// If myself is modified
		// If the context preoperties, current or parent ones, has been modified
		if (getLastUpdated()<childsLastModified){
			//				log.info("Modificado debido a los hijos:"+this);
			updateContent();
		} else if (getLastUpdated() <= getLastModified()){
			//				log.info("Modificado debido al fichero:"+this);
			updateContent();
		} else if (context.hasBeenModified(getLastUpdated()) ){
			//				log.info("Modificado debido al contexto:"+this);
			updateContent(); 
		}
			
		//			return getLastUpdated();
	}


	protected void createChildList() {
		context.setPageNode(this);
		if (isPageFile){
			if (childs==null){
				childs=new ArrayList<Node>();
			}
		} else {
			childs=null;
		}			
	}


	protected List<Node> getChildList() {
		if (childs!=null){
			return childs;
		} else {
			return EMPTY_LIST;
		}
	}

	protected int getChildListSize() {
		if (childs!=null){
			return childs.size();
		} else {
			return 0;
		}
	}
	protected void clearChildList() {
		if (childs!=null){
			childs.clear();
		}			
	}


	protected void addChild(Node child) {
		if (childs!=null){
			childs.add(child);
		} else {
			context.getPageNode().addChild(child);				
		}
	}

	protected long getLastUpdated() {
		return lastUpdated;
	}

	@Override
	public String toString(){
		return FileUtils.getRelativePath(file, globalContext.contentDir)+":"+context;
	}

		
	/**
	 * This updates the node content, the string that represents this node
	 * and its childs. <p>
	 * @throws IOException 
	 */
	protected String updateContent() throws FileNotFoundException {
		String ret;
		String stringToParse;
			
		clearChildList();
			
		// Getting the String to parse
		stringToParse=getStringToParse();

			
		// First the properties, because into the properties may be defined
		// the included files. There is no problems because the variable may
		// be resolved by the stack

		Matcher matcher;
		StringBuffer buffer;
			
		// First  parseamos las variables $VARIABLE$
		stringToParse=context.parseVariables(stringToParse,this);
		stringToParse=context.parseGlobalVariables(stringToParse,this);
		
		/* 
		   buffer=new StringBuffer();
		   matcher = VARIABLE_TOKEN_PATER.matcher(stringToParse);
		   while (matcher.find()) {
		   String token=matcher.group(1);
		   String value=context.getValue(token);
		   try {
		   matcher.appendReplacement(buffer, value);
		   }catch(IllegalArgumentException e){
		   log.error("For token:"+token+" and value:"+value+"'",e);
		   }
		   }
		   matcher.appendTail(buffer);
		   stringToParse=buffer.toString();
		*/

			
		//  Last include files
		matcher = PatternUtils.FILE_TOKEN_PATER.matcher(stringToParse);
		buffer=new StringBuffer();
						
		while (matcher.find()) {
			String token=matcher.group(1);
			try {
				Node child=globalContext.getFileNode(globalContext.getFileFromFileName(token));
				if (child!=null) {
					addChild(child);
					String value=child.getContent(this.context);

					try {						
						matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
					}catch(IllegalArgumentException e){
						log.error("For token:"+token+" and value:"+value,e);		
					}
				}
			}catch(FileNotFoundException e){
				log.error("While searching for file:"+token,e);
			}
		}			
		matcher.appendTail(buffer);
			
		stringToParse=buffer.toString();
							
		// LISTAS
		matcher = PatternUtils.LIST_TOKEN_PATER.matcher(stringToParse);
		buffer=new StringBuffer();
						
		while (matcher.find()) {
			String listType=matcher.group(1);
			String g2=matcher.group(2);
			String relativePath=matcher.group(3);
			String templateName=matcher.group(4);
				
			Node template=globalContext.getFileNode(globalContext.getFileFromFileName(templateName));
			if (template!=null){
				addChild(template);
				String value;
				if (PatternUtils.DIRS.equals(listType)) {
					value=globalContext.iterateOverDIRS(this,template,relativePath/*,matcher,buffer,list*/);
				} else if (PatternUtils.DIR.equals(listType)) {
					value=globalContext.iterateOverDIR(this,template,relativePath/*,matcher,buffer,list*/);
				} else if (PatternUtils.LINKS.equals(listType)) {
					value=globalContext.iterateOverSymbLink(this,template,relativePath/*,matcher,buffer,list*/);
				} else {
					log.error("Dir command:["+listType+"] unkown.");
					value="";
				}
				try {
					matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
				}catch(IllegalArgumentException e){
					log.error("For templateName:"+templateName+" and value:"+value,e);		
				}
			}						
		}			
		matcher.appendTail(buffer);
			
		stringToParse=buffer.toString();


	
		// actualizamos la lista de hijos
		//			childs=list;
			
		// si soy un nodo raiz me guardo
		if (this.isPage()){
			// One more pass is neded to parse properties inside properties of the 
			// pages properties
			ContextProperties currentContext=context.getParent();
			while (currentContext!=null){
				stringToParse=currentContext.parseVariables(stringToParse,this);
				currentContext=currentContext.getParent();
			}
			globalContext.writeFileContent(this,stringToParse);
			//				setContent(stringToParse);
			ret=stringToParse;

		} else {
			log.info("Updated:"+this);
			//				setContent(stringToParse);
			ret=stringToParse;
		}
			
		lastUpdated=System.currentTimeMillis();
			
		return ret;
	}

	/**
	 * Use this method to get the string to parse of this node.
	 * The list pased in param is the list where the childs found must be added
	 * @param list
	 * @return
	 */
	protected abstract String getStringToParse();

	/**
	 * This node representas a page that have to be sored into the file system after compilation
	 * @return
	 */
	protected boolean isPage() {
		return isPageFile;
	}
		
	/**
	 * The last time of the file disk information need to generate pages has been modified.
	 * This is not the last time the node has been executed or generates.
	 * 
	 * @return
	 */
	protected abstract long getLastModified();


	public ContextProperties getContext(){
		return context;
	}	
}
