/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site;

import eu.ginere.base.util.file.FileUtils;
import eu.ginere.base.util.properties.FileProperties;
import eu.ginere.site.PatternUtils;
import eu.ginere.site.SiteGenerator;
import eu.ginere.site.nodes.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class ContextProperties {
    static Logger log = Logger.getLogger(ContextProperties.class);
    public static final String PAGE_NAME = "pageName";
    public static final String PAGE_PATH = "pagePath";
    public static final String FILE_NAME = "fileName";
    public static final String FILE_PATH = "filePath";
    public static final String CONTEXT_PATH = "contextPath";
    protected final SiteGenerator globalContext;
    FileProperties fileProperties;
    protected ContextProperties parent = null;
    private Node pageNode = null;

    public ContextProperties(SiteGenerator globalContext, File file) {
        this.globalContext = globalContext;
        if (!FileUtils.canReadFile((File)file, (Logger)log)) {
            this.fileProperties = null;
        } else {
            try {
                this.fileProperties = new FileProperties(file, globalContext.charset);
            }
            catch (IOException e) {
                log.error((Object)("Warning file:" + file), (Throwable)e);
                this.fileProperties = null;
            }
        }
    }

    public ContextProperties(SiteGenerator globalContext) {
        this.globalContext = globalContext;
        this.fileProperties = null;
    }

    public String toString() {
        String current = this.fileProperties != null ? FileUtils.getRelativePath((File)this.fileProperties.getFildes(), (File)this.globalContext.contentDir, (String)"Not In Context") : " --- ";
        if (this.parent == null) {
            return "[" + current + "]";
        }
        return "[" + current + this.parent + "]";
    }

    public void setPageNode(Node node) {
        this.pageNode = node;
    }

    public Node getPageNode() {
        if (this.pageNode != null) {
            return this.pageNode;
        }
        return this.getParent().getPageNode();
    }

    public File getCurrentDir() {
        if (this.fileProperties != null && this.fileProperties.getFildes() != null) {
            return this.fileProperties.getFildes().getParentFile();
        }
        if (this.parent != null) {
            return this.parent.getCurrentDir();
        }
        log.error((Object)("RETURNING NULL from context:" + this));
        return null;
    }

    public boolean hasBeenModified(long lastModified) {
        if (this.fileProperties != null) {
            this.fileProperties.checkForModification();
            if (lastModified <= this.fileProperties.getLastModified()) {
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.hasBeenModified(lastModified);
        }
        return false;
    }

    public String getValue(String propertyName, Node currentNode) {
        Node pageNode;
        String ret = null;
        if (PAGE_NAME.equals(propertyName) && (pageNode = this.getPageNode()) != null) {
            return pageNode.getFileName();
        }
        if (PAGE_PATH.equals(propertyName) && (pageNode = this.getPageNode()) != null) {
            return pageNode.getRelativePath(null);
        }
        if (FILE_NAME.equals(propertyName)) {
            return currentNode.getFileName();
        }
        if (FILE_PATH.equals(propertyName)) {
            return currentNode.getRelativePath(null);
        }
        if (CONTEXT_PATH.equals(propertyName)) {
            try {
                return this.globalContext.getRelativePath(this.getCurrentDir());
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Getting context path for:" + this.getCurrentDir()), (Throwable)e);
                return null;
            }
        }
        if (this.fileProperties != null) {
            ret = this.fileProperties.getStringValue(ContextProperties.class, propertyName, null);
        }
        if (ret == null && this.parent != null && (ret = this.parent.getValue(propertyName, currentNode)) == null) {
            return "";
        }
        if (ret == null) {
            return "";
        }
        return PatternUtils.unScapeFromBathPropFiles(ret);
    }

    public void setParent(ContextProperties parentContext) {
        this.parent = parentContext;
    }

    public ContextProperties getParent() {
        return this.parent;
    }

    public String parseVariables(String stringToParse, Node currentNode) {
        if (stringToParse == null || "".equals(stringToParse)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = PatternUtils.VARIABLE_TOKEN_PATER.matcher(stringToParse);
        while (matcher.find()) {
            String token = matcher.group(1);
            String value = this.getValue(token, currentNode);
            try {
                matcher.appendReplacement(buffer, value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("For token:" + token + " and value:" + value + "'"), (Throwable)e);
            }
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public String parseGlobalVariables(String stringToParse, Node currentNode) {
        if (stringToParse == null || "".equals(stringToParse)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = PatternUtils.DATE_TOKEN_PATER.matcher(stringToParse);
        while (matcher.find()) {
            String value;
            String format = matcher.group(1);
            log.debug((Object)("Format:" + format));
            Date now = new Date();
            if (format == null || "".equals(format)) {
                value = now.toString();
            } else {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    value = sdf.format(now);
                }
                catch (Exception e) {
                    value = "";
                    log.error((Object)("Format:" + format + " and date:" + now + "'"), (Throwable)e);
                }
            }
            try {
                matcher.appendReplacement(buffer, value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("For token:" + format + " and value:" + value + "'"), (Throwable)e);
            }
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public String getCharSet() {
        return this.globalContext.charset;
    }
}

