/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site;

import eu.ginere.site.ContextProperties;
import eu.ginere.site.SiteGenerator;
import eu.ginere.site.nodes.Node;
import java.io.File;

public class IteratorContext
extends ContextProperties {
    long lastIteration = 0L;
    int iteration = 0;
    private static final String CONTEXT_PROPERTY_NAME_INDEX = "Index";

    IteratorContext(SiteGenerator globalContext) {
        super(globalContext);
    }

    @Override
    public String toString() {
        String current = " Iterator ";
        if (this.parent == null) {
            return "[" + current + "]";
        }
        return "[" + current + this.parent + "]";
    }

    @Override
    public File getCurrentDir() {
        return this.parent.getCurrentDir();
    }

    public void iterate() {
        ++this.iteration;
        this.lastIteration = System.currentTimeMillis();
    }

    @Override
    public boolean hasBeenModified(long lastModified) {
        if (this.lastIteration >= lastModified) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasBeenModified(lastModified);
        }
        return false;
    }

    @Override
    public String getValue(String propertyName, Node currentNode) {
        if (CONTEXT_PROPERTY_NAME_INDEX.equals(propertyName)) {
            return Integer.toString(this.iteration);
        }
        if (this.parent != null) {
            return this.parent.getValue(propertyName, currentNode);
        }
        return null;
    }
}

