/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site;

import eu.ginere.base.util.file.FileUtils;
import eu.ginere.site.SiteGenerator;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;

public class Main {
    static final Logger log = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        log.info((Object)("Process started at:" + new Date()));
        if (args.length < 3) {
            Main.exitError("Args: content_folder common_folder out_folder [daemon true/false [charset] ]");
        }
        File contentDir = new File(args[0]);
        File commanDir = new File(args[1]);
        File outDir = new File(args[2]);
        boolean daemon = false;
        if (args.length >= 4 && "true".equals(args[3])) {
            daemon = true;
        }
        String charset = "UTF-8";
        if (args.length >= 5) {
            charset = args[4];
            if (log.isInfoEnabled()) {
                log.info((Object)("Using passed charset:" + charset));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Using default charset:" + charset));
        }
        if (!FileUtils.verifyDir((File)outDir, (Logger)log)) {
            Main.exitError("Out path:" + outDir.getAbsolutePath());
        }
        if (!FileUtils.verifyReadDir((File)contentDir, (Logger)log)) {
            Main.exitError("Content dir:" + contentDir.getAbsolutePath());
        }
        if (!FileUtils.verifyReadDir((File)commanDir, (Logger)log)) {
            Main.exitError("Common dir:" + commanDir.getAbsolutePath());
        }
        try {
            SiteGenerator template = new SiteGenerator(outDir, contentDir, commanDir, charset);
            template.generate(daemon);
            log.info((Object)"Process ended OK.");
            System.exit(0);
        }
        catch (Exception e) {
            log.fatal((Object)"Exception while generate sir", (Throwable)e);
            e.printStackTrace(System.err);
            Main.exitError("Exception error:" + e.getMessage());
        }
    }

    public static void exitError(String error) {
        System.err.println(error);
        log.fatal((Object)error);
        System.exit(1);
    }
}

