/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site;

import eu.ginere.site.SiteGenerator;
import eu.ginere.site.nodes.Node;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class NodeFinder
extends SimpleFileVisitor<Path> {
    static final Logger log = Logger.getLogger(SiteGenerator.class);
    private final PathMatcher matcher;
    private final String globPattern;
    private final SiteGenerator generator;
    private final List<Node> result = new Vector<Node>();

    private NodeFinder(SiteGenerator generator, String globPattern) {
        this.generator = generator;
        this.globPattern = globPattern;
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + globPattern);
    }

    private void find(Path path) {
        if (this.matcher.matches(path)) {
            log.info((Object)("Path:'" + path + "' match:'" + this.globPattern + "'"));
            try {
                Node node = this.generator.getFileNode(path.toFile());
                this.result.add(node);
                log.info((Object)("Error with path:" + path));
            }
            catch (Exception e) {
                log.error((Object)("Error with path:" + path), (Throwable)e);
            }
        } else {
            log.info((Object)("Path:'" + path + "' do not match glob pattern:'" + this.globPattern + "'"));
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        this.find(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException exc) {
        log.error((Object)("While visiting path:" + path), (Throwable)exc);
        return FileVisitResult.CONTINUE;
    }

    public static Node[] getResultArray(SiteGenerator generator, File file, String globPattern) throws IOException {
        Path startingDir = file.toPath();
        NodeFinder finder = new NodeFinder(generator, globPattern);
        log.debug((Object)("Startd with path:'" + startingDir + "' and globPattern:'" + globPattern + "'"));
        Files.walkFileTree(startingDir, finder);
        List<Node> result = finder.result;
        return result.toArray(new Node[result.size()]);
    }
}

