/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site;

import eu.ginere.base.util.file.FileUtils;
import eu.ginere.site.IteratorContext;
import eu.ginere.site.nodes.BinaryNode;
import eu.ginere.site.nodes.GlobalPropNode;
import eu.ginere.site.nodes.JavascriptNode;
import eu.ginere.site.nodes.Node;
import eu.ginere.site.nodes.ParseableTextNode;
import eu.ginere.site.nodes.PropNode;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class SiteGenerator {
    static final Logger log = Logger.getLogger(SiteGenerator.class);
    private static final String SLASH = "/";
    public final File outDir;
    public final File contentDir;
    public final File commonDir;
    public final String charset;
    public long timeToSleepBetweenIteration = 100L;
    private final Map<String, File> FILE_CACHE = new Hashtable<String, File>();
    private final Map<File, Node> nodeCache = new Hashtable<File, Node>();
    public static final Map<String, String> BINARY_EXTENSIONS = new Hashtable<String, String>();
    public static final String HTML = ".html";
    public static final String PROP = ".prop";
    public static final String CSS = ".css";
    public static final String JS = ".js";
    public static final String MAP = ".map";
    public static final String TILDE = "~";
    public static final String DOT = ".";

    public SiteGenerator(File outDir, File contentDir, File commonDir, String charset) {
        this.outDir = outDir;
        this.contentDir = contentDir;
        this.commonDir = commonDir;
        this.charset = charset;
    }

    public void generate(boolean daemon) throws FileNotFoundException {
        GlobalPropNode root = new GlobalPropNode(this, this.contentDir);
        root.checkForUpdates(null);
        while (daemon) {
            long time = System.currentTimeMillis();
            root.checkForUpdates(null);
            try {
                Thread.sleep(this.timeToSleepBetweenIteration);
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public File getFileFromFileName(String fileName) {
        if (this.FILE_CACHE.containsKey(fileName)) {
            return this.FILE_CACHE.get(fileName);
        }
        File file = new File(this.commonDir, fileName);
        if (FileUtils.canReadFile((File)file)) {
            this.FILE_CACHE.put(fileName, file);
            return file;
        }
        file = new File(this.contentDir, fileName);
        if (FileUtils.canReadFile((File)file)) {
            this.FILE_CACHE.put(fileName, file);
            return file;
        }
        log.warn((Object)("File not found:'" + fileName + "'"));
        return null;
    }

    public Node getFileNode(File file) throws FileNotFoundException {
        return this.getFileNode(file, false);
    }

    public Node getFileNode(File file, boolean isPageFile) throws FileNotFoundException {
        if (file == null) {
            return null;
        }
        if (this.nodeCache.containsKey(file)) {
            Node ret = this.nodeCache.get(file);
            return ret;
        }
        Node node = file.isDirectory() ? new GlobalPropNode(this, file) : (SiteGenerator.isABinaryNode(file) ? new BinaryNode(this, file) : (JavascriptNode.isJavascriptNode(file) ? new JavascriptNode(this, file) : (PropNode.isAPropertiesFile(file) ? new PropNode(this, file, isPageFile) : new ParseableTextNode(this, file, isPageFile))));
        this.nodeCache.put(file, node);
        return node;
    }

    public void writeFileContent(Node root, String content) {
        try {
            File outFile = new File(this.getOutpath(root), root.getFileName());
            try {
                IOUtils.write((String)content, (OutputStream)new FileOutputStream(outFile), (String)this.charset);
                log.info((Object)("OK: " + outFile.getAbsoluteFile()));
            }
            catch (IOException e) {
                log.error((Object)("Writing file: " + outFile.getAbsoluteFile()), (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("No output file for node: " + root + " "), (Throwable)e);
        }
    }

    public String getRelativePath(File file) throws FileNotFoundException {
        String relativePath = file.isDirectory() ? FileUtils.getRelativePath((File)file, (File)this.contentDir, null) : FileUtils.getRelativePath((File)file.getParentFile(), (File)this.contentDir, null);
        if (relativePath == null) {
            relativePath = FileUtils.getRelativePath((File)file.getParentFile(), (File)this.commonDir, null);
        }
        if (relativePath != null) {
            relativePath = relativePath.replace('\\', '/');
            return relativePath;
        }
        throw new FileNotFoundException("The file:'" + file.getAbsolutePath() + "' is not under the content dir[" + this.contentDir.getAbsolutePath() + "] nor the common dir [" + this.commonDir.getAbsoluteFile() + "]");
    }

    public File getOutpath(Node node) throws FileNotFoundException {
        File src = node.file;
        String relativePath = this.getRelativePath(src);
        FileUtils.createPath((File)this.outDir, (String)relativePath);
        return new File(this.outDir, relativePath);
    }

    public String iterateOverDIRS(Node parent, Node template, String relativePath) {
        return this.iterateOver(parent, template, relativePath, true, false);
    }

    public String iterateOverSymbLink(Node parent, Node template, String globPattern) {
        return this.iterateOver(parent, template, globPattern, false, true);
    }

    public String iterateOver(Node parent, Node template, String relativePath, boolean dirs, boolean symLink) {
        File dir;
        if (relativePath == null) {
            dir = parent.getContext().getCurrentDir();
        } else {
            dir = relativePath.startsWith(SLASH) ? new File(this.contentDir, relativePath) : new File(parent.getContext().getCurrentDir(), relativePath);
            if (!dir.isDirectory()) {
                log.error((Object)("While getting the path:'" + relativePath + "' does not exists:" + dir.getAbsolutePath()));
                return "";
            }
            if (!dir.canRead()) {
                log.error((Object)("While getting the path:'" + relativePath + "' can not be readed:" + dir.getAbsolutePath()));
                return "";
            }
        }
        File[] array = dir.listFiles(CanThreadFileFilter.FILTER);
        FileUtils.sortByName((File[])array);
        StringBuilder buffer = new StringBuilder();
        IteratorContext iteratorContext = new IteratorContext(this);
        for (File file : array) {
            try {
                if ((!symLink || !Files.isSymbolicLink(file.toPath())) && (!dirs || !file.isDirectory() || Files.isSymbolicLink(file.toPath()))) continue;
                Node node = this.getFileNode(file);
                if (node != null) {
                    node.getContext().setParent(parent.getContext());
                    iteratorContext.setParent(node.getContext());
                    iteratorContext.iterate();
                    String value = template.getContent(iteratorContext);
                    buffer.append(value);
                    continue;
                }
                log.warn((Object)("Node is null for file:" + file.getAbsolutePath()));
            }
            catch (FileNotFoundException e) {
                log.error((Object)("File:" + file.getAbsolutePath()), (Throwable)e);
            }
        }
        return buffer.toString();
    }

    public String iterateOverDIR(Node parent, Node template, String relativePath) {
        if (relativePath != null) {
            File dir = new File(parent.getContext().getCurrentDir(), relativePath);
            if (!dir.isDirectory()) {
                log.error((Object)("While getting the path:'" + relativePath + "' does not exists:" + dir.getAbsolutePath()));
                return "";
            }
            if (!dir.canRead()) {
                log.error((Object)("While getting the path:'" + relativePath + "' can not be readed:" + dir.getAbsolutePath()));
                return "";
            }
            try {
                IteratorContext iteratorContext = new IteratorContext(this);
                GlobalPropNode dirNode = new GlobalPropNode(this, dir);
                if (dirNode != null) {
                    dirNode.getContext().setParent(parent.getContext());
                    iteratorContext.setParent(dirNode.getContext());
                    iteratorContext.iterate();
                    String value = template.getContent(iteratorContext);
                    return value;
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)("File:" + dir.getAbsolutePath()), (Throwable)e);
            }
            return "";
        }
        log.error((Object)("relativePath :'" + relativePath + "' can not be null for iterate over DIR."));
        return "";
    }

    public static boolean canThreatFileOrDir(File file) {
        if (file == null) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        String fileName = file.getName();
        if (fileName.startsWith(DOT)) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        if (fileName.endsWith(TILDE)) {
            return false;
        }
        if ("GlobalProperties.prop".equals(fileName)) {
            return false;
        }
        if (fileName.endsWith(HTML)) {
            return true;
        }
        if (fileName.endsWith(PROP)) {
            return true;
        }
        if (fileName.endsWith(CSS)) {
            return true;
        }
        if (fileName.endsWith(JS)) {
            return true;
        }
        if (fileName.endsWith(MAP)) {
            return true;
        }
        if (SiteGenerator.isABinaryNode(file)) {
            return true;
        }
        return true;
    }

    private static boolean isABinaryNode(File file) {
        if (file == null) {
            return false;
        }
        String fileName = file.getName();
        String ext = FileUtils.getExtension((String)fileName);
        if (ext == null) {
            ext = "";
        }
        return BINARY_EXTENSIONS.containsKey(ext);
    }

    static {
        BINARY_EXTENSIONS.put("map", "map");
        BINARY_EXTENSIONS.put("ico", "ico");
        BINARY_EXTENSIONS.put("css", "css");
        BINARY_EXTENSIONS.put("png", "png");
        BINARY_EXTENSIONS.put("gif", "gif");
        BINARY_EXTENSIONS.put("jpg", "jpg");
        BINARY_EXTENSIONS.put("jpeg", "jpeg");
        BINARY_EXTENSIONS.put("webm", "webm");
        BINARY_EXTENSIONS.put("mp4", "mp4");
        BINARY_EXTENSIONS.put("mpeg", "mpeg");
        BINARY_EXTENSIONS.put("mov", "mov");
        BINARY_EXTENSIONS.put("flv", "flv");
        BINARY_EXTENSIONS.put("avi", "avi");
    }

    public static class CanThreadFileFilter
    implements FileFilter {
        public static final CanThreadFileFilter FILTER = new CanThreadFileFilter();

        private CanThreadFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return SiteGenerator.canThreatFileOrDir(file);
        }
    }
}

