/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site.nodes;

import eu.ginere.base.util.file.FileUtils;
import eu.ginere.site.ContextProperties;
import eu.ginere.site.SiteGenerator;
import eu.ginere.site.nodes.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BinaryNode
extends Node {
    private final File out;

    public BinaryNode(SiteGenerator globalContext, File file) throws FileNotFoundException {
        super(globalContext, file, true);
        this.context = new ContextProperties(globalContext);
        this.out = new File(globalContext.getOutpath(this), file.getName());
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public String getRelativePath() throws FileNotFoundException {
        return this.globalContext.getRelativePath(this.file);
    }

    @Override
    public void generateOrUpdateDiskFile(ContextProperties context) throws IOException {
        if (this.out.lastModified() <= this.file.lastModified()) {
            FileUtils.copyFile((File)this.file, (File)this.out);
            log.info((Object)("OK: " + this.out.getAbsoluteFile()));
        }
    }

    @Override
    protected String updateContent() throws FileNotFoundException {
        return "";
    }

    @Override
    protected String getStringToParse() {
        return "";
    }
}

