/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site.nodes;

import eu.ginere.base.util.file.FileUtils;
import eu.ginere.site.ContextProperties;
import eu.ginere.site.SiteGenerator;
import eu.ginere.site.nodes.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GlobalPropNode
extends Node {
    static final Logger log = Logger.getLogger(GlobalPropNode.class);
    public static final String GLOBAL_PROPERTIES_FILE_NAME = "GlobalProperties.prop";
    private final File dir;
    private final File propFile;

    public GlobalPropNode(SiteGenerator globalContext, File dir) throws FileNotFoundException {
        super(globalContext, dir, false);
        File propFile = new File(dir, GLOBAL_PROPERTIES_FILE_NAME);
        if (FileUtils.canReadFile((File)propFile)) {
            this.context = new ContextProperties(globalContext, propFile);
            this.propFile = propFile;
        } else {
            this.context = new ContextProperties(globalContext);
            this.propFile = null;
        }
        this.dir = dir;
    }

    @Override
    public long getLastModified() {
        if (this.propFile == null) {
            return this.file.lastModified();
        }
        return Math.max(this.file.lastModified(), this.propFile.lastModified());
    }

    @Override
    public String getContent(ContextProperties parentContext) throws FileNotFoundException {
        return "";
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public String getRelativePath() {
        return null;
    }

    @Override
    protected String getStringToParse() {
        return "";
    }

    @Override
    public void generateOrUpdateDiskFile(ContextProperties context) throws IOException {
        log.warn((Object)("Trying to generate disk file information for a GlobalProperties Node:" + this));
    }

    public void checkForUpdates(ContextProperties parentContext) {
        this.context.setParent(parentContext);
        File[] array = this.dir.listFiles();
        ArrayList<Node> list = new ArrayList<Node>(array.length);
        for (File file : array) {
            try {
                if (!SiteGenerator.canThreatFileOrDir(file)) continue;
                if (file.isDirectory()) {
                    GlobalPropNode dirChildNode = (GlobalPropNode)this.globalContext.getFileNode(file, false);
                    if (dirChildNode == null) continue;
                    dirChildNode.checkForUpdates(this.context);
                    list.add(dirChildNode);
                    continue;
                }
                Node fileNode = this.globalContext.getFileNode(file, true);
                if (fileNode == null) continue;
                list.add(fileNode);
            }
            catch (FileNotFoundException e) {
                log.error((Object)("File:" + file.getAbsolutePath()), (Throwable)e);
            }
        }
        for (Node child : list) {
            try {
                if (!child.isPage()) continue;
                child.generateOrUpdateDiskFile(this.context);
            }
            catch (IOException e) {
                log.error((Object)("File:" + this.file.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

