/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site.nodes;

import eu.ginere.base.util.file.FileUtils;
import eu.ginere.site.ContextProperties;
import eu.ginere.site.SiteGenerator;
import eu.ginere.site.nodes.GoogleCompiler;
import eu.ginere.site.nodes.ParseableTextNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class JavascriptNode
extends ParseableTextNode {
    static final Logger log = Logger.getLogger(JavascriptNode.class);
    private final File out;

    public JavascriptNode(SiteGenerator globalContext, File file) throws FileNotFoundException {
        super(globalContext, file, true);
        this.context = new ContextProperties(globalContext);
        this.out = new File(globalContext.getOutpath(this), file.getName());
    }

    public static boolean isJavascriptNode(File file) {
        if (file == null) {
            return false;
        }
        String fileName = file.getName();
        String ext = FileUtils.getExtension((String)fileName);
        return ext != null && "js".equals(ext.toLowerCase());
    }

    @Override
    public void generateOrUpdateDiskFile(ContextProperties context) throws IOException {
        if (this.out.lastModified() <= this.file.lastModified()) {
            String compilerOptions = context.getValue("JS_COMPILER_OPTIONS", this);
            try {
                GoogleCompiler.compile(this.file, this.out, context.getCharSet());
            }
            catch (IOException e) {
                throw new IOException("While compiling in file:" + this.file + ", out file:" + this.out + " compiler options:" + compilerOptions, e);
            }
        }
    }

    @Override
    protected String updateContent() throws FileNotFoundException {
        return "";
    }

    @Override
    protected String getStringToParse() {
        return "";
    }
}

