/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site.nodes;

import eu.ginere.base.util.file.FileUtils;
import eu.ginere.site.ContextProperties;
import eu.ginere.site.PatternUtils;
import eu.ginere.site.SiteGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public abstract class Node {
    static final Logger log = Logger.getLogger(Node.class);
    private static final List<Node> EMPTY_LIST = new ArrayList<Node>(0);
    protected final SiteGenerator globalContext;
    public final File file;
    protected List<Node> childs = null;
    ContextProperties context;
    private long lastUpdated = 0L;
    protected final boolean isPageFile;

    public Node(SiteGenerator globalContext, File file, boolean isPageFile) throws FileNotFoundException {
        this.globalContext = globalContext;
        this.file = file;
        this.isPageFile = isPageFile;
    }

    public String getContent(ContextProperties parentContext) throws FileNotFoundException {
        this.context.setParent(parentContext);
        return this.updateContent();
    }

    public abstract String getFileName();

    public abstract String getRelativePath() throws FileNotFoundException;

    public String getRelativePath(String defaultValue) {
        try {
            return this.getRelativePath();
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("While getting relative path for node:" + this));
            return defaultValue;
        }
    }

    public void generateOrUpdateDiskFile(ContextProperties parentContext) throws IOException {
        if (!this.isPage()) {
            return;
        }
        this.createChildList();
        this.context.setParent(parentContext);
        long childsLastModified = 0L;
        if (this.getChildListSize() > 0) {
            for (Node child : this.getChildList()) {
                long curret = child.getLastModified();
                if (childsLastModified >= curret) continue;
                childsLastModified = curret;
            }
        }
        if (this.getLastUpdated() < childsLastModified) {
            this.updateContent();
        } else if (this.getLastUpdated() <= this.getLastModified()) {
            this.updateContent();
        } else if (this.context.hasBeenModified(this.getLastUpdated())) {
            this.updateContent();
        }
    }

    protected void createChildList() {
        this.context.setPageNode(this);
        if (this.isPageFile) {
            if (this.childs == null) {
                this.childs = new ArrayList<Node>();
            }
        } else {
            this.childs = null;
        }
    }

    protected List<Node> getChildList() {
        if (this.childs != null) {
            return this.childs;
        }
        return EMPTY_LIST;
    }

    protected int getChildListSize() {
        if (this.childs != null) {
            return this.childs.size();
        }
        return 0;
    }

    protected void clearChildList() {
        if (this.childs != null) {
            this.childs.clear();
        }
    }

    protected void addChild(Node child) {
        if (this.childs != null) {
            this.childs.add(child);
        } else {
            this.context.getPageNode().addChild(child);
        }
    }

    protected long getLastUpdated() {
        return this.lastUpdated;
    }

    public String toString() {
        return FileUtils.getRelativePath((File)this.file, (File)this.globalContext.contentDir) + ":" + this.context;
    }

    protected String updateContent() throws FileNotFoundException {
        String ret;
        this.clearChildList();
        String stringToParse = this.getStringToParse();
        stringToParse = this.context.parseVariables(stringToParse, this);
        stringToParse = this.context.parseGlobalVariables(stringToParse, this);
        Matcher matcher = PatternUtils.FILE_TOKEN_PATER.matcher(stringToParse);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String token = matcher.group(1);
            try {
                Node child = this.globalContext.getFileNode(this.globalContext.getFileFromFileName(token));
                if (child == null) continue;
                this.addChild(child);
                String value = child.getContent(this.context);
                try {
                    matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("For token:" + token + " and value:" + value), (Throwable)e);
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)("While searching for file:" + token), (Throwable)e);
            }
        }
        matcher.appendTail(buffer);
        stringToParse = buffer.toString();
        matcher = PatternUtils.LIST_TOKEN_PATER.matcher(stringToParse);
        buffer = new StringBuffer();
        while (matcher.find()) {
            String value;
            String listType = matcher.group(1);
            String g2 = matcher.group(2);
            String relativePath = matcher.group(3);
            String templateName = matcher.group(4);
            Node template = this.globalContext.getFileNode(this.globalContext.getFileFromFileName(templateName));
            if (template == null) continue;
            this.addChild(template);
            if ("DIRS".equals(listType)) {
                value = this.globalContext.iterateOverDIRS(this, template, relativePath);
            } else if ("DIR".equals(listType)) {
                value = this.globalContext.iterateOverDIR(this, template, relativePath);
            } else if ("LINKS".equals(listType)) {
                value = this.globalContext.iterateOverSymbLink(this, template, relativePath);
            } else {
                log.error((Object)("Dir command:[" + listType + "] unkown."));
                value = "";
            }
            try {
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("For templateName:" + templateName + " and value:" + value), (Throwable)e);
            }
        }
        matcher.appendTail(buffer);
        stringToParse = buffer.toString();
        if (this.isPage()) {
            for (ContextProperties currentContext = this.context.getParent(); currentContext != null; currentContext = currentContext.getParent()) {
                stringToParse = currentContext.parseVariables(stringToParse, this);
            }
            this.globalContext.writeFileContent(this, stringToParse);
            ret = stringToParse;
        } else {
            log.info((Object)("Updated:" + this));
            ret = stringToParse;
        }
        this.lastUpdated = System.currentTimeMillis();
        return ret;
    }

    protected abstract String getStringToParse();

    protected boolean isPage() {
        return this.isPageFile;
    }

    protected abstract long getLastModified();

    public ContextProperties getContext() {
        return this.context;
    }
}

