/*
 * Decompiled with CFR 0.152.
 */
package eu.ginere.site.nodes;

import eu.ginere.site.ContextProperties;
import eu.ginere.site.SiteGenerator;
import eu.ginere.site.nodes.Node;
import java.io.File;
import java.io.FileNotFoundException;

public class PropNode
extends Node {
    public static final String TEMPLATE_PROPERTY = "template";

    public PropNode(SiteGenerator globalContext, File file, boolean isPageFile) throws FileNotFoundException {
        super(globalContext, file, isPageFile);
        this.context = new ContextProperties(globalContext, file);
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public String getFileName() {
        return PropNode.getHtmlFileNameFromPropFileName(this.file.getName());
    }

    @Override
    public String getRelativePath() throws FileNotFoundException {
        return this.globalContext.getRelativePath(this.file);
    }

    @Override
    protected String getStringToParse() {
        String stringToParse;
        String fileName = this.context.getValue(TEMPLATE_PROPERTY, this);
        if ("".equals(fileName)) {
            log.warn((Object)("No template property defined for node:" + this));
            stringToParse = "";
        } else {
            try {
                Node child = this.globalContext.getFileNode(this.globalContext.getFileFromFileName(fileName));
                if (child != null) {
                    stringToParse = child.getContent(this.context);
                    this.addChild(child);
                } else {
                    stringToParse = "";
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Error getting file:'" + fileName + "'"), (Throwable)e);
                stringToParse = "";
            }
        }
        return stringToParse;
    }

    public static boolean isAPropertiesFile(File file) {
        return SiteGenerator.canThreatFileOrDir(file) && !file.isDirectory() && file.getName().endsWith(".prop");
    }

    private static String getHtmlFileNameFromPropFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName.length() <= ".prop".length()) {
            return fileName;
        }
        String prefix = fileName.substring(0, fileName.length() - ".prop".length());
        return prefix + ".html";
    }
}

