/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.GaugeBuilder;
import eu.hansolo.medusa.tools.GradientLookup;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private Gauge gauge;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.gauge = ((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)GaugeBuilder.create().skinType(Gauge.SkinType.SIMPLE_DIGITAL)).prefSize(400.0, 400.0)).foregroundBaseColor(Color.web((String)"#ebeefd"))).barBackgroundColor(Color.web((String)"#262c49"))).decimals(2)).maxValue(200.0)).arcExtend(5.0)).gradientLookup(new GradientLookup(new Stop(0.0, Color.web((String)"#8f62cb")), new Stop(0.25, Color.web((String)"#7367f0")), new Stop(0.5, Color.web((String)"#ad5ea5")), new Stop(0.75, Color.web((String)"#e85456")), new Stop(1.0, Color.web((String)"#e85456").brighter())))).gradientBarEnabled(true)).animated(true)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 2000000000L) {
                    double value = RND.nextDouble() * Test.this.gauge.getRange() + Test.this.gauge.getMinValue();
                    Test.this.gauge.setValue(value);
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.gauge});
        pane.setPadding(new Insets(10.0));
        pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#10163a"), CornerRadii.EMPTY, Insets.EMPTY)}));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Test");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        this.timer.start();
    }

    public void stop() {
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Test.launch((String[])args);
    }
}

