/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;

public class SimpleSectionSkin
extends GaugeSkinBase {
    private static final double ANGLE_RANGE = 300.0;
    private double size;
    private Canvas sectionCanvas;
    private GraphicsContext sectionCtx;
    private Arc barBackground;
    private Arc bar;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Pane pane;
    private List<Section> sections;
    private InvalidationListener decimalListener;
    private InvalidationListener currentValueListener;

    public SimpleSectionSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.sections = gauge.getSections();
        this.decimalListener = o -> this.handleEvents("DECIMALS");
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.sectionCanvas = new Canvas(250.0, 250.0);
        this.sectionCtx = this.sectionCanvas.getGraphicsContext2D();
        this.barBackground = new Arc(125.0, 125.0, 100.0, 100.0, this.gauge.getStartAngle() + 90.0, -300.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.gauge.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(31.25);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 100.0, 100.0, this.gauge.getStartAngle() + 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)this.gauge.getBarColor());
        this.bar.setStrokeWidth(31.25);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text();
        this.valueText.setStroke(null);
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.unitText = new Text();
        this.unitText.setStroke(null);
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, this.gauge.isValueVisible() && !this.gauge.getUnit().isEmpty());
        this.pane = new Pane(new Node[]{this.barBackground, this.sectionCanvas, this.titleText, this.valueText, this.unitText, this.bar});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.decimalsProperty().addListener(this.decimalListener);
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, this.gauge.isValueVisible() && !this.gauge.getUnit().isEmpty());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.gauge.getSections();
            this.resize();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.redraw();
            this.setBar(this.gauge.getCurrentValue());
        }
    }

    @Override
    public void dispose() {
        this.gauge.decimalsProperty().removeListener(this.decimalListener);
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void setBar(double VALUE) {
        double barLength = 0.0;
        double barStart = 0.0;
        double min = this.gauge.getMinValue();
        double max = this.gauge.getMaxValue();
        double step = this.gauge.getAngleStep();
        double clampedValue = Helper.clamp(min, max, VALUE);
        if (this.gauge.isStartFromZero()) {
            if ((VALUE > min || min < 0.0) && (VALUE < max || max > 0.0)) {
                if (max < 0.0) {
                    barStart = this.gauge.getStartAngle() + 90.0 - this.gauge.getAngleRange();
                    barLength = (max - clampedValue) * step;
                } else if (min > 0.0) {
                    barStart = this.gauge.getStartAngle() + 90.0;
                    barLength = (min - clampedValue) * step;
                } else {
                    barStart = this.gauge.getStartAngle() + 90.0 + min * step;
                    barLength = -clampedValue * step;
                }
            }
        } else {
            barStart = this.gauge.getStartAngle() + 90.0;
            barLength = (min - clampedValue) * step;
        }
        this.bar.setStartAngle(barStart);
        this.bar.setLength(barLength);
        this.bar.setStroke((Paint)this.gauge.getBarColor());
        if (this.gauge.getSectionsVisible() && !this.sections.isEmpty()) {
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                break;
            }
        }
        this.valueText.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.valueText.setLayoutX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
    }

    private void drawBackground() {
        this.sectionCanvas.setCache(false);
        this.sectionCtx.setLineCap(StrokeLineCap.BUTT);
        this.sectionCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (this.gauge.getSectionsVisible() && !this.sections.isEmpty()) {
            double xy = 0.012 * this.size;
            double wh = this.size * 0.976;
            double minValue = this.gauge.getMinValue();
            double maxValue = this.gauge.getMaxValue();
            double angleStep = this.gauge.getAngleStep();
            this.sectionCtx.setLineWidth(this.size * 0.025);
            this.sectionCtx.setLineCap(StrokeLineCap.BUTT);
            for (int i = 0; i < this.sections.size(); ++i) {
                double sectionStartAngle;
                Section section = this.sections.get(i);
                if (Double.compare(section.getStart(), maxValue) > 0 || Double.compare(section.getStop(), minValue) < 0) continue;
                if (Double.compare(section.getStart(), minValue) < 0 && Double.compare(section.getStop(), maxValue) < 0) {
                    sectionStartAngle = 0.0;
                } else {
                    double d = sectionStartAngle = Gauge.ScaleDirection.CLOCKWISE == this.gauge.getScaleDirection() ? (section.getStart() - minValue) * angleStep : -(section.getStart() - minValue) * angleStep;
                }
                double sectionAngleExtend = Double.compare(section.getStop(), maxValue) > 0 ? (Gauge.ScaleDirection.CLOCKWISE == this.gauge.getScaleDirection() ? (maxValue - section.getStart()) * angleStep : -(maxValue - section.getStart()) * angleStep) : (Double.compare(section.getStart(), minValue) < 0 ? (Gauge.ScaleDirection.CLOCKWISE == this.gauge.getScaleDirection() ? (section.getStop() - minValue) * this.gauge.getAngleStep() : -(section.getStop() - minValue) * angleStep) : (Gauge.ScaleDirection.CLOCKWISE == this.gauge.getScaleDirection() ? (section.getStop() - section.getStart()) * angleStep : -(section.getStop() - section.getStart()) * angleStep));
                this.sectionCtx.save();
                this.sectionCtx.setStroke((Paint)section.getColor());
                this.sectionCtx.strokeArc(xy, xy, wh, wh, -(120.0 + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
                this.sectionCtx.restore();
            }
        }
        this.sectionCanvas.setCache(true);
        this.sectionCanvas.setCacheHint(CacheHint.QUALITY);
        this.barBackground.setStroke((Paint)this.gauge.getBarBackgroundColor());
    }

    private void resizeValueText() {
        double maxWidth = this.size * 0.86466165;
        double fontFactor = -0.035 * (double)(Math.max(1, this.gauge.getDecimals()) - 1) + 0.2556391;
        double fontSize = this.size * fontFactor;
        this.valueText.setFont(Fonts.latoLight(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.35;
        double fontSize = this.size * 0.08082707;
        this.titleText.setFont(Fonts.latoBold(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.22180451);
        this.titleText.setFill((Paint)Color.RED);
        this.unitText.setFont(Fonts.latoBold(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.68984962);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.gauge.getWidth() - this.size) * 0.5, (this.gauge.getHeight() - this.size) * 0.5);
            this.sectionCanvas.setWidth(this.size);
            this.sectionCanvas.setHeight(this.size);
            this.barBackground.setCenterX(this.size * 0.5);
            this.barBackground.setCenterY(this.size * 0.5);
            this.barBackground.setRadiusX(this.size * 0.4);
            this.barBackground.setRadiusY(this.size * 0.4);
            this.barBackground.setStrokeWidth(this.size * 0.125);
            this.bar.setCenterX(this.size * 0.5);
            this.bar.setCenterY(this.size * 0.5);
            this.bar.setRadiusX(this.size * 0.4);
            this.bar.setRadiusY(this.size * 0.4);
            this.bar.setStrokeWidth(this.size * 0.125);
            this.redraw();
        }
    }

    @Override
    protected void redraw() {
        this.drawBackground();
        this.setBar(this.gauge.getCurrentValue());
        this.resizeValueText();
        this.titleText.setText(this.gauge.getTitle());
        this.unitText.setText(this.gauge.getUnit());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
    }
}

