/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.skins.ClockSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class TextClockSkin
extends ClockSkinBase {
    protected static final double PREFERRED_WIDTH = 250.0;
    protected static final double PREFERRED_HEIGHT = 100.0;
    protected static final double MINIMUM_WIDTH = 50.0;
    protected static final double MINIMUM_HEIGHT = 20.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    private static final DateTimeFormatter HHMM_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter AMPM_HHMM_FORMATTER = DateTimeFormatter.ofPattern("hh:mm a");
    private static final DateTimeFormatter AMPM_HHMMSS_FORMATTER = DateTimeFormatter.ofPattern("hh:mm:ss a");
    private double aspectRatio = 0.4;
    private double width;
    private double height;
    private DateTimeFormatter dateFormat;
    private Text timeText;
    private Text dateText;
    private Pane pane;
    private Color textColor;
    private Color dateColor;
    private Font customFont;

    public TextClockSkin(Clock clock) {
        super(clock);
        this.textColor = clock.getTextColor();
        this.dateColor = clock.getDateColor();
        this.dateFormat = Helper.getDateFormat(clock.getLocale());
        this.customFont = clock.getCustomFont();
        this.initGraphics();
        this.registerListeners();
    }

    @Override
    protected void initGraphics() {
        if (Double.compare(this.clock.getPrefWidth(), 0.0) <= 0 || Double.compare(this.clock.getPrefHeight(), 0.0) <= 0 || Double.compare(this.clock.getWidth(), 0.0) <= 0 || Double.compare(this.clock.getHeight(), 0.0) <= 0) {
            if (this.clock.getPrefWidth() > 0.0 && this.clock.getPrefHeight() > 0.0) {
                this.clock.setPrefSize(this.clock.getPrefWidth(), this.clock.getPrefHeight());
            } else {
                this.clock.setPrefSize(250.0, 100.0);
            }
        }
        this.timeText = new Text();
        this.timeText.setTextOrigin(VPos.CENTER);
        this.timeText.setFill((Paint)this.textColor);
        this.dateText = new Text();
        this.dateText.setTextOrigin(VPos.CENTER);
        this.dateText.setFill((Paint)this.dateColor);
        this.pane = new Pane(new Node[]{this.timeText, this.dateText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.clock.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (!"VISIBILITY".equals(EVENT_TYPE) && "SECTION".equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    private void drawTime(ZonedDateTime TIME) {
        if (this.clock.isTextVisible()) {
            if (Locale.US == this.clock.getLocale()) {
                this.timeText.setText(this.clock.isSecondsVisible() ? AMPM_HHMMSS_FORMATTER.format(TIME) : AMPM_HHMM_FORMATTER.format(TIME));
            } else {
                this.timeText.setText(this.clock.isSecondsVisible() ? HHMMSS_FORMATTER.format(TIME) : HHMM_FORMATTER.format(TIME));
            }
            this.timeText.setX((this.width - this.timeText.getLayoutBounds().getWidth()) * 0.5);
        }
        if (this.clock.isDateVisible()) {
            this.dateText.setText(this.dateFormat.format(TIME));
            this.dateText.setX((this.width - this.dateText.getLayoutBounds().getWidth()) * 0.5);
        }
    }

    @Override
    public void updateTime(ZonedDateTime TIME) {
        this.drawTime(TIME);
    }

    @Override
    public void updateAlarms() {
    }

    @Override
    protected void resize() {
        this.width = this.clock.getWidth() - this.clock.getInsets().getLeft() - this.clock.getInsets().getRight();
        this.height = this.clock.getHeight() - this.clock.getInsets().getTop() - this.clock.getInsets().getBottom();
        if (this.aspectRatio * this.width > this.height) {
            this.width = 1.0 / (this.aspectRatio / this.height);
        } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
            this.height = this.aspectRatio * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.clock.getWidth() - this.height) * 0.5, (this.clock.getHeight() - this.height) * 0.5);
            if (this.clock.isTextVisible()) {
                if (null == this.customFont) {
                    this.timeText.setFont(Locale.US == this.clock.getLocale() ? Fonts.robotoLight(0.5 * this.height) : Fonts.robotoLight(0.6 * this.height));
                } else {
                    this.timeText.setFont(Locale.US == this.clock.getLocale() ? new Font(this.customFont.getName(), 0.5 * this.height) : new Font(this.customFont.getName(), 0.6 * this.height));
                }
                this.timeText.setX((this.width - this.timeText.getLayoutBounds().getWidth()) * 0.5);
                if (this.clock.isDateVisible()) {
                    this.timeText.setY(this.height * 0.3);
                } else {
                    this.timeText.setY(this.height * 0.5);
                }
            }
            if (this.clock.isDateVisible()) {
                if (null == this.customFont) {
                    this.dateText.setFont(Fonts.robotoLight(0.3 * this.height));
                } else {
                    this.dateText.setFont(new Font(this.customFont.getName(), 0.3 * this.height));
                }
                this.dateText.setX((this.width - this.dateText.getLayoutBounds().getWidth()) * 0.5);
                this.dateText.setY(this.height * 0.8);
            }
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.clock.getBorderWidth() / 250.0 * this.height))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        ZonedDateTime time = this.clock.getTime();
        this.dateFormat = Helper.getDateFormat(this.clock.getLocale());
        this.textColor = this.clock.getTextColor();
        this.timeText.setFill((Paint)this.textColor);
        this.dateColor = this.clock.getDateColor();
        this.dateText.setFill((Paint)this.dateColor);
        this.drawTime(time);
    }
}

