/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import eu.hansolo.medusa.tools.Statistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Text;
import javafx.util.Pair;

public class TileSparklineSkin
extends GaugeSkinBase {
    private double size;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Text averageText;
    private Text highText;
    private Text lowText;
    private Text subTitleText;
    private Rectangle graphBounds;
    private List<PathElement> pathElements;
    private Path sparkLine;
    private Circle dot;
    private Rectangle stdDeviationArea;
    private Line averageLine;
    private Pane pane;
    private double low;
    private double high;
    private double minValue;
    private double maxValue;
    private double range;
    private double stdDeviation;
    private String formatString;
    private Locale locale;
    private int noOfDatapoints;
    private List<Double> dataList;
    private InvalidationListener currentValueListener;
    private InvalidationListener averagingListener;

    public TileSparklineSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.low = gauge.getMaxValue();
        this.high = gauge.getMinValue();
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.range = gauge.getRange();
        this.stdDeviation = 0.0;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.noOfDatapoints = gauge.getAveragingPeriod();
        this.dataList = new LinkedList<Double>();
        this.currentValueListener = o -> this.handleEvents("CURRENT_VALUE");
        this.averagingListener = o -> this.handleEvents("AVERAGING_PERIOD");
        for (int i = 0; i < this.noOfDatapoints; ++i) {
            this.dataList.add(this.minValue);
        }
        if (this.noOfDatapoints < 4) {
            throw new IllegalArgumentException("Please increase the averaging period to a value larger than 3.");
        }
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.graphBounds = new Rectangle(12.5, 125.0, 225.0, 112.5);
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.gauge.getValue()));
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.averageText = new Text(String.format(this.locale, this.formatString, this.gauge.getAverage()));
        this.averageText.setFill((Paint)this.gauge.getAverageColor());
        Helper.enableNode((Node)this.averageText, this.gauge.isAverageVisible());
        this.highText = new Text();
        this.highText.setTextOrigin(VPos.BOTTOM);
        this.highText.setFill((Paint)this.gauge.getValueColor());
        this.lowText = new Text();
        this.lowText.setTextOrigin(VPos.TOP);
        this.lowText.setFill((Paint)this.gauge.getValueColor());
        this.subTitleText = new Text(this.gauge.getSubTitle());
        this.subTitleText.setTextOrigin(VPos.TOP);
        this.subTitleText.setFill((Paint)this.gauge.getSubTitleColor());
        this.stdDeviationArea = new Rectangle();
        Helper.enableNode((Node)this.stdDeviationArea, this.gauge.isAverageVisible());
        this.averageLine = new Line();
        this.averageLine.setStroke((Paint)this.gauge.getAverageColor());
        this.averageLine.getStrokeDashArray().addAll((Object[])new Double[]{1.25, 1.25});
        Helper.enableNode((Node)this.averageLine, this.gauge.isAverageVisible());
        this.pathElements = new ArrayList<PathElement>(this.noOfDatapoints);
        this.pathElements.add(0, (PathElement)new MoveTo());
        for (int i = 1; i < this.noOfDatapoints; ++i) {
            this.pathElements.add(i, (PathElement)new LineTo());
        }
        this.sparkLine = new Path();
        this.sparkLine.getElements().addAll(this.pathElements);
        this.sparkLine.setFill(null);
        this.sparkLine.setStroke((Paint)this.gauge.getBarColor());
        this.sparkLine.setStrokeWidth(1.875);
        this.sparkLine.setStrokeLineCap(StrokeLineCap.ROUND);
        this.sparkLine.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.dot = new Circle();
        this.dot.setFill((Paint)this.gauge.getBarColor());
        this.pane = new Pane(new Node[]{this.titleText, this.valueText, this.unitText, this.stdDeviationArea, this.averageLine, this.sparkLine, this.dot, this.averageText, this.highText, this.lowText, this.subTitleText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(6.25), new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(6.25), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
        this.gauge.averagingPeriodProperty().addListener(this.averagingListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = this.gauge.getMinValue();
            this.maxValue = this.gauge.getMaxValue();
            this.range = this.gauge.getRange();
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
            Helper.enableNode((Node)this.subTitleText, !this.gauge.getSubTitle().isEmpty());
            Helper.enableNode((Node)this.averageLine, this.gauge.isAverageVisible());
            Helper.enableNode((Node)this.averageText, this.gauge.isAverageVisible());
            Helper.enableNode((Node)this.stdDeviationArea, this.gauge.isAverageVisible());
            this.redraw();
        } else if (!("SECTION".equals(EVENT_TYPE) || "ALERT".equals(EVENT_TYPE) || "VALUE".equals(EVENT_TYPE))) {
            if ("CURRENT_VALUE".equals(EVENT_TYPE)) {
                if (this.gauge.isAnimated()) {
                    this.gauge.setAnimated(false);
                }
                if (!this.gauge.isAveragingEnabled()) {
                    this.gauge.setAveragingEnabled(true);
                }
                double value = Helper.clamp(this.minValue, this.maxValue, this.gauge.getValue());
                this.addData(value);
                this.drawChart(value);
            } else if ("AVERAGING_PERIOD".equals(EVENT_TYPE)) {
                int i;
                this.noOfDatapoints = this.gauge.getAveragingPeriod();
                this.dataList.clear();
                if (this.noOfDatapoints < 4) {
                    throw new IllegalArgumentException("Please increase the averaging period to a value larger than 3.");
                }
                for (i = 0; i < this.noOfDatapoints; ++i) {
                    this.dataList.add(this.minValue);
                }
                this.pathElements.clear();
                this.pathElements.add(0, (PathElement)new MoveTo());
                for (i = 1; i < this.noOfDatapoints; ++i) {
                    this.pathElements.add(i, (PathElement)new LineTo());
                }
                this.sparkLine.getElements().setAll(this.pathElements);
                this.redraw();
            }
        }
    }

    private void addData(double VALUE) {
        if (this.dataList.size() <= this.noOfDatapoints) {
            Collections.rotate(this.dataList, -1);
            this.dataList.set(this.noOfDatapoints - 1, VALUE);
        } else {
            this.dataList.add(VALUE);
        }
        this.stdDeviation = Statistics.getStdDev(this.dataList);
    }

    private void drawChart(double VALUE) {
        this.low = Statistics.getMin(this.dataList);
        this.high = Statistics.getMax(this.dataList);
        if (Double.compare(this.low, this.high) == 0) {
            this.low = this.minValue;
            this.high = this.maxValue;
        }
        this.range = this.high - this.low;
        double minX = this.graphBounds.getX();
        double maxX = minX + this.graphBounds.getWidth();
        double minY = this.graphBounds.getY();
        double maxY = minY + this.graphBounds.getHeight();
        double stepX = this.graphBounds.getWidth() / (double)(this.noOfDatapoints - 1);
        double stepY = this.graphBounds.getHeight() / this.range;
        if (this.gauge.isSmoothing()) {
            this.smooth(this.dataList);
        } else {
            MoveTo begin = (MoveTo)this.pathElements.get(0);
            begin.setX(minX);
            begin.setY(maxY - Math.abs(this.low - this.dataList.get(0)) * stepY);
            for (int i = 1; i < this.noOfDatapoints - 1; ++i) {
                LineTo lineTo = (LineTo)this.pathElements.get(i);
                lineTo.setX(minX + (double)i * stepX);
                lineTo.setY(maxY - Math.abs(this.low - this.dataList.get(i)) * stepY);
            }
            LineTo end = (LineTo)this.pathElements.get(this.noOfDatapoints - 1);
            end.setX(maxX);
            end.setY(maxY - Math.abs(this.low - this.dataList.get(this.noOfDatapoints - 1)) * stepY);
            this.dot.setCenterX(maxX);
            this.dot.setCenterY(end.getY());
        }
        double average = this.gauge.getAverage();
        double averageY = Helper.clamp(minY, maxY, maxY - Math.abs(this.low - average) * stepY);
        this.averageLine.setStartX(minX);
        this.averageLine.setEndX(maxX);
        this.averageLine.setStartY(averageY);
        this.averageLine.setEndY(averageY);
        this.stdDeviationArea.setY(this.averageLine.getStartY() - this.stdDeviation * 0.5 * stepY);
        this.stdDeviationArea.setHeight(this.stdDeviation * stepY);
        this.valueText.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.averageText.setText(String.format(this.locale, this.formatString, average));
        this.highText.setText(String.format(this.locale, this.formatString, this.high));
        this.lowText.setText(String.format(this.locale, this.formatString, this.low));
        this.resizeDynamicText();
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        this.gauge.averagingPeriodProperty().removeListener(this.averagingListener);
        super.dispose();
    }

    public void smooth(List<Double> DATA_LIST) {
        int size = DATA_LIST.size();
        double[] x = new double[size];
        double[] y = new double[size];
        this.low = Statistics.getMin(DATA_LIST);
        this.high = Statistics.getMax(DATA_LIST);
        if (Double.compare(this.low, this.high) == 0) {
            this.low = this.minValue;
            this.high = this.maxValue;
        }
        this.range = this.high - this.low;
        double minX = this.graphBounds.getX();
        double maxX = minX + this.graphBounds.getWidth();
        double minY = this.graphBounds.getY();
        double maxY = minY + this.graphBounds.getHeight();
        double stepX = this.graphBounds.getWidth() / (double)(this.noOfDatapoints - 1);
        double stepY = this.graphBounds.getHeight() / this.range;
        for (int i = 0; i < size; ++i) {
            x[i] = minX + (double)i * stepX;
            y[i] = maxY - Math.abs(this.low - DATA_LIST.get(i)) * stepY;
        }
        Pair<Double[], Double[]> px = this.computeControlPoints(x);
        Pair<Double[], Double[]> py = this.computeControlPoints(y);
        this.sparkLine.getElements().clear();
        for (int i = 0; i < size - 1; ++i) {
            this.sparkLine.getElements().add((Object)new MoveTo(x[i], y[i]));
            this.sparkLine.getElements().add((Object)new CubicCurveTo(((Double[])px.getKey())[i].doubleValue(), ((Double[])py.getKey())[i].doubleValue(), ((Double[])px.getValue())[i].doubleValue(), ((Double[])py.getValue())[i].doubleValue(), x[i + 1], y[i + 1]));
        }
        this.dot.setCenterX(maxX);
        this.dot.setCenterY(y[size - 1]);
    }

    private Pair<Double[], Double[]> computeControlPoints(double[] K) {
        int i;
        int n = K.length - 1;
        Double[] p1 = new Double[n];
        Double[] p2 = new Double[n];
        double[] a = new double[n];
        double[] b = new double[n];
        double[] c = new double[n];
        double[] r = new double[n];
        a[0] = 0.0;
        b[0] = 2.0;
        c[0] = 1.0;
        r[0] = K[0] + 2.0 * K[1];
        for (i = 1; i < n - 1; ++i) {
            a[i] = 1.0;
            b[i] = 4.0;
            c[i] = 1.0;
            r[i] = 4.0 * K[i] + 2.0 * K[i + 1];
        }
        a[n - 1] = 2.0;
        b[n - 1] = 7.0;
        c[n - 1] = 0.0;
        r[n - 1] = 8.0 * K[n - 1] + K[n];
        for (i = 1; i < n; ++i) {
            double m = a[i] / b[i - 1];
            b[i] = b[i] - m * c[i - 1];
            r[i] = r[i] - m * r[i - 1];
        }
        p1[n - 1] = r[n - 1] / b[n - 1];
        for (i = n - 2; i >= 0; --i) {
            p1[i] = (r[i] - c[i] * p1[i + 1]) / b[i];
        }
        for (i = 0; i < n - 1; ++i) {
            p2[i] = 2.0 * K[i + 1] - p1[i + 1];
        }
        p2[n - 1] = 0.5 * (K[n] + p1[n - 1]);
        return new Pair((Object)p1, (Object)p2);
    }

    private void resizeDynamicText() {
        double maxWidth = this.unitText.isManaged() ? this.size * 0.725 : this.size * 0.9;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        if (this.unitText.isVisible()) {
            this.valueText.relocate(this.size * 0.925 - this.valueText.getLayoutBounds().getWidth() - this.unitText.getLayoutBounds().getWidth(), this.size * 0.15);
        } else {
            this.valueText.relocate(this.size * 0.95 - this.valueText.getLayoutBounds().getWidth(), this.size * 0.15);
        }
        maxWidth = this.size * 0.3;
        fontSize = this.size * 0.05;
        this.averageText.setFont(Fonts.latoRegular(fontSize));
        if (this.averageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.averageText, maxWidth, fontSize);
        }
        if (this.averageLine.getStartY() < this.graphBounds.getY() + this.graphBounds.getHeight() * 0.5) {
            this.averageText.setY(this.averageLine.getStartY() + this.size * 0.0425);
        } else {
            this.averageText.setY(this.averageLine.getStartY() - this.size * 0.0075);
        }
        this.highText.setFont(Fonts.latoRegular(fontSize));
        if (this.highText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.highText, maxWidth, fontSize);
        }
        this.highText.setY(this.graphBounds.getY() - this.size * 0.0125);
        this.lowText.setFont(Fonts.latoRegular(fontSize));
        if (this.lowText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.lowText, maxWidth, fontSize);
        }
        this.lowText.setY(this.size * 0.9);
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.9;
        double fontSize = this.size * 0.06;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.05, this.size * 0.05);
        maxWidth = this.size * 0.15;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate(this.size * 0.95 - this.unitText.getLayoutBounds().getWidth(), this.size * 0.3275);
        this.averageText.setX(this.size * 0.05);
        this.highText.setX(this.size * 0.05);
        this.lowText.setX(this.size * 0.05);
        maxWidth = this.size * 0.75;
        fontSize = this.size * 0.05;
        this.subTitleText.setFont(Fonts.latoRegular(fontSize));
        if (this.subTitleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.subTitleText, maxWidth, fontSize);
        }
        this.subTitleText.relocate(this.size * 0.95 - this.subTitleText.getLayoutBounds().getWidth(), this.size * 0.9);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.graphBounds = new Rectangle(this.size * 0.05, this.size * 0.5, this.size * 0.9, this.size * 0.39);
            this.stdDeviationArea.setX(this.graphBounds.getX());
            this.stdDeviationArea.setWidth(this.graphBounds.getWidth());
            this.averageLine.getStrokeDashArray().setAll((Object[])new Double[]{this.graphBounds.getWidth() * 0.01, this.graphBounds.getWidth() * 0.01});
            this.drawChart(this.gauge.getValue());
            this.sparkLine.setStrokeWidth(this.size * 0.01);
            this.dot.setRadius(this.size * 0.014);
            this.resizeStaticText();
            this.resizeDynamicText();
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(this.size * 0.025), new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(this.size * 0.025), Insets.EMPTY)}));
        this.locale = this.gauge.getLocale();
        this.formatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        this.titleText.setText(this.gauge.getTitle());
        this.subTitleText.setText(this.gauge.getSubTitle());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.averageText.setFill((Paint)this.gauge.getAverageColor());
        this.highText.setFill((Paint)this.gauge.getValueColor());
        this.lowText.setFill((Paint)this.gauge.getValueColor());
        this.subTitleText.setFill((Paint)this.gauge.getSubTitleColor());
        this.sparkLine.setStroke((Paint)this.gauge.getBarColor());
        this.stdDeviationArea.setFill((Paint)Helper.getTranslucentColorFrom(this.gauge.getAverageColor(), 0.1));
        this.averageLine.setStroke((Paint)this.gauge.getAverageColor());
        this.dot.setFill((Paint)this.gauge.getBarColor());
    }
}

