/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.tools;

import eu.hansolo.medusa.tools.Data;
import eu.hansolo.medusa.tools.Helper;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MovingAverage {
    public static final int MAX_PERIOD = 2073600;
    private static final int DEFAULT_PERIOD = 10;
    private final Queue<Data> window;
    private int period;
    private double sum;

    public MovingAverage() {
        this(10);
    }

    public MovingAverage(int PERIOD) {
        this.period = Helper.clamp(0, 2073600, PERIOD);
        this.window = new ConcurrentLinkedQueue<Data>();
    }

    public void addData(Data DATA) {
        this.sum += DATA.getValue();
        this.window.add(DATA);
        if (this.window.size() > this.period) {
            this.sum -= this.window.remove().getValue();
        }
    }

    public void addValue(double VALUE) {
        this.addData(new Data(VALUE));
    }

    public Queue<Data> getWindow() {
        return new LinkedList<Data>(this.window);
    }

    public double getAverage() {
        if (this.window.isEmpty()) {
            return 0.0;
        }
        return this.sum / (double)this.window.size();
    }

    public double getTimeBasedAverageOf(Duration DURATION) {
        assert (!DURATION.isNegative()) : "Time period must be positive";
        Instant now = Instant.now();
        return this.window.stream().filter(v -> v.getTimestamp().isAfter(now.minus(DURATION))).mapToDouble(Data::getValue).average().getAsDouble();
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int PERIOD) {
        this.period = Helper.clamp(0, 2073600, PERIOD);
        this.reset();
    }

    public boolean isFilling() {
        return this.window.size() < this.period;
    }

    public void reset() {
        this.window.clear();
    }
}

