/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import java.util.UUID;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class Section
implements Comparable<Section> {
    public final SectionEvent ENTERED_EVENT = new SectionEvent(this, null, SectionEvent.SECTION_ENTERED);
    public final SectionEvent LEFT_EVENT = new SectionEvent(this, null, SectionEvent.SECTION_LEFT);
    public final SectionEvent UPDATE_EVENT = new SectionEvent(this, null, SectionEvent.SECTION_UPDATE);
    private double _start;
    private DoubleProperty start;
    private double _stop;
    private DoubleProperty stop;
    private DoubleProperty range;
    private String _text;
    private StringProperty text;
    private Image _icon;
    private ObjectProperty<Image> icon;
    private Color _color;
    private ObjectProperty<Color> color;
    private Color _highlightColor;
    private ObjectProperty<Color> highlightColor;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private double checkedValue;
    private String styleClass;
    private ObjectProperty<EventHandler<SectionEvent>> onSectionEntered = new SimpleObjectProperty((Object)this, "onSectionEntered");
    private ObjectProperty<EventHandler<SectionEvent>> onSectionLeft = new SimpleObjectProperty((Object)this, "onSectionLeft");
    private ObjectProperty<EventHandler<SectionEvent>> onSectionUpdate = new SimpleObjectProperty((Object)this, "onSectionUpdate");

    public Section() {
        this(-1.0, -1.0, "", null, Color.TRANSPARENT, Color.TRANSPARENT, Color.TRANSPARENT, "");
    }

    public Section(double START, double STOP) {
        this(START, STOP, "", null, Color.TRANSPARENT, Color.TRANSPARENT, Color.TRANSPARENT, "");
    }

    public Section(double START, double STOP, Color COLOR) {
        this(START, STOP, "", null, COLOR, COLOR, Color.TRANSPARENT, "");
    }

    public Section(double START, double STOP, Color COLOR, Color HIGHLIGHT_COLOR) {
        this(START, STOP, "", null, COLOR, HIGHLIGHT_COLOR, Color.TRANSPARENT, "");
    }

    public Section(double START, double STOP, Image ICON, Color COLOR) {
        this(START, STOP, "", ICON, COLOR, COLOR, Color.WHITE, "");
    }

    public Section(double START, double STOP, String TEXT, Color COLOR) {
        this(START, STOP, TEXT, null, COLOR, COLOR, Color.WHITE, "");
    }

    public Section(double START, double STOP, String TEXT, Color COLOR, Color TEXT_COLOR) {
        this(START, STOP, TEXT, null, COLOR, COLOR, TEXT_COLOR, "");
    }

    public Section(double START, double STOP, String TEXT, Image ICON, Color COLOR, Color TEXT_COLOR) {
        this(START, STOP, TEXT, ICON, COLOR, COLOR, TEXT_COLOR, "");
    }

    public Section(double START, double STOP, String TEXT, Image ICON, Color COLOR, Color HIGHLIGHT_COLOR, Color TEXT_COLOR) {
        this(START, STOP, TEXT, ICON, COLOR, HIGHLIGHT_COLOR, TEXT_COLOR, "");
    }

    public Section(double START, double STOP, String TEXT, Image ICON, Color COLOR, Color HIGHLIGHT_COLOR, Color TEXT_COLOR, String STYLE_CLASS) {
        this._start = START;
        this._stop = STOP;
        this.range = new DoublePropertyBase(Math.abs(this._stop - this._start)){

            public Object getBean() {
                return Section.this;
            }

            public String getName() {
                return "range";
            }
        };
        this._text = TEXT;
        this._icon = ICON;
        this._color = COLOR;
        this._highlightColor = HIGHLIGHT_COLOR;
        this._textColor = TEXT_COLOR;
        this.checkedValue = -1.7976931348623157E308;
        this.styleClass = STYLE_CLASS;
    }

    public double getStart() {
        return null == this.start ? this._start : this.start.get();
    }

    public void setStart(double START) {
        if (null == this.start) {
            this._start = START;
            this.range.set(Math.abs(this.getStop() - this._start));
            this.fireSectionEvent(this.UPDATE_EVENT);
        } else {
            this.start.set(START);
        }
    }

    public DoubleProperty startProperty() {
        if (null == this.start) {
            this.start = new DoublePropertyBase(this._start){

                protected void invalidated() {
                    Section.this.range.set(Math.abs(Section.this.getStop() - this.get()));
                    Section.this.fireSectionEvent(Section.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Section.this;
                }

                public String getName() {
                    return "start";
                }
            };
        }
        return this.start;
    }

    public double getStop() {
        return null == this.stop ? this._stop : this.stop.get();
    }

    public void setStop(double STOP) {
        if (null == this.stop) {
            this._stop = STOP;
            this.range.set(Math.abs(this._stop - this.getStart()));
            this.fireSectionEvent(this.UPDATE_EVENT);
        } else {
            this.stop.set(STOP);
        }
    }

    public DoubleProperty stopProperty() {
        if (null == this.stop) {
            this.stop = new DoublePropertyBase(this._stop){

                protected void invalidated() {
                    Section.this.range.set(Math.abs(this.get() - Section.this.getStart()));
                    Section.this.fireSectionEvent(Section.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Section.this;
                }

                public String getName() {
                    return "stop";
                }
            };
        }
        return this.stop;
    }

    public double getRange() {
        return this.range.get();
    }

    public ReadOnlyDoubleProperty rangeProperty() {
        return this.range;
    }

    public String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
            this.fireSectionEvent(this.UPDATE_EVENT);
        } else {
            this.text.set((Object)TEXT);
        }
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new StringPropertyBase(this._text){

                protected void invalidated() {
                    Section.this.fireSectionEvent(Section.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Section.this;
                }

                public String getName() {
                    return "text";
                }
            };
        }
        return this.text;
    }

    public Image getImage() {
        return null == this.icon ? this._icon : (Image)this.icon.get();
    }

    public void setIcon(Image IMAGE) {
        if (null == this.icon) {
            this._icon = IMAGE;
            this.fireSectionEvent(this.UPDATE_EVENT);
        } else {
            this.icon.set((Object)IMAGE);
        }
    }

    public ObjectProperty<Image> iconProperty() {
        if (null == this.icon) {
            this.icon = new ObjectPropertyBase<Image>(this._icon){

                protected void invalidated() {
                    Section.this.fireSectionEvent(Section.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Section.this;
                }

                public String getName() {
                    return "icon";
                }
            };
        }
        return this.icon;
    }

    public Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public void setColor(Color COLOR) {
        if (null == this.color) {
            this._color = COLOR;
            this.fireSectionEvent(this.UPDATE_EVENT);
        } else {
            this.color.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new ObjectPropertyBase<Color>(this._color){

                protected void invalidated() {
                    Section.this.fireSectionEvent(Section.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Section.this;
                }

                public String getName() {
                    return "color";
                }
            };
        }
        return this.color;
    }

    public Color getHighlightColor() {
        return null == this.highlightColor ? this._highlightColor : (Color)this.highlightColor.get();
    }

    public void setHighlightColor(Color COLOR) {
        if (null == this.highlightColor) {
            this._highlightColor = COLOR;
            this.fireSectionEvent(this.UPDATE_EVENT);
        } else {
            this.highlightColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> highlightColorProperty() {
        if (null == this.highlightColor) {
            this.highlightColor = new ObjectPropertyBase<Color>(this._highlightColor){

                protected void invalidated() {
                    Section.this.fireSectionEvent(Section.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Section.this;
                }

                public String getName() {
                    return "highlightColor";
                }
            };
        }
        return this.highlightColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.fireSectionEvent(this.UPDATE_EVENT);
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    Section.this.fireSectionEvent(Section.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return Section.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
        }
        return this.textColor;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String STYLE_CLASS) {
        this.styleClass = STYLE_CLASS;
    }

    public boolean contains(double VALUE) {
        return Double.compare(VALUE, this.getStart()) >= 0 && Double.compare(VALUE, this.getStop()) <= 0;
    }

    public void checkForValue(double VALUE) {
        boolean wasInSection = this.contains(this.checkedValue);
        boolean isInSection = this.contains(VALUE);
        if (!wasInSection && isInSection) {
            this.fireSectionEvent(this.ENTERED_EVENT);
        } else if (wasInSection && !isInSection) {
            this.fireSectionEvent(this.LEFT_EVENT);
        }
        this.checkedValue = VALUE;
    }

    public boolean equals(Section SECTION) {
        return Double.compare(SECTION.getStart(), this.getStart()) == 0 && Double.compare(SECTION.getStop(), this.getStop()) == 0 && SECTION.getText().equals(this.getText());
    }

    @Override
    public int compareTo(Section SECTION) {
        if (Double.compare(this.getStart(), SECTION.getStart()) < 0) {
            return -1;
        }
        if (Double.compare(this.getStart(), SECTION.getStart()) > 0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "{\n" + "\"text\":\"" + this.getText() + "\",\n" + "\"startValue\":" + this.getStart() + ",\n" + "\"stopValue\":" + this.getStop() + ",\n" + "\"color\":\"" + this.getColor().toString().substring(0, 8).replace("0x", "#") + "\",\n" + "\"highlightColor\":\"" + this.getHighlightColor().toString().substring(0, 8).replace("0x", "#") + "\",\n" + "\"textColor\":\"" + this.getTextColor().toString().substring(0, 8).replace("0x", "#") + "\"\n" + "}";
    }

    public final ObjectProperty<EventHandler<SectionEvent>> onSectionEnteredProperty() {
        return this.onSectionEntered;
    }

    public final void setOnSectionEntered(EventHandler<SectionEvent> value) {
        this.onSectionEnteredProperty().set(value);
    }

    public final EventHandler<SectionEvent> getOnSectionEntered() {
        return (EventHandler)this.onSectionEnteredProperty().get();
    }

    public final ObjectProperty<EventHandler<SectionEvent>> onSectionLeftProperty() {
        return this.onSectionLeft;
    }

    public final void setOnSectionLeft(EventHandler<SectionEvent> value) {
        this.onSectionLeftProperty().set(value);
    }

    public final EventHandler<SectionEvent> getOnSectionLeft() {
        return (EventHandler)this.onSectionLeftProperty().get();
    }

    public final ObjectProperty<EventHandler<SectionEvent>> onSectionUpdateProperty() {
        return this.onSectionUpdate;
    }

    public final void setOnSectionUpdate(EventHandler<SectionEvent> value) {
        this.onSectionUpdateProperty().set(value);
    }

    public final EventHandler<SectionEvent> getOnSectionUpdate() {
        return (EventHandler)this.onSectionUpdateProperty().get();
    }

    public void fireSectionEvent(SectionEvent EVENT) {
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = SectionEvent.SECTION_ENTERED == TYPE ? this.getOnSectionEntered() : (SectionEvent.SECTION_LEFT == TYPE ? this.getOnSectionLeft() : (SectionEvent.SECTION_UPDATE == TYPE ? this.getOnSectionUpdate() : null));
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle((Event)EVENT);
    }

    public static class SectionEvent
    extends Event {
        public static final EventType<SectionEvent> SECTION_ENTERED = new EventType(ANY, "SECTION_ENTERED" + UUID.randomUUID().toString());
        public static final EventType<SectionEvent> SECTION_LEFT = new EventType(ANY, "SECTION_LEFT" + UUID.randomUUID().toString());
        public static final EventType<SectionEvent> SECTION_UPDATE = new EventType(ANY, "SECTION_UPDATE" + UUID.randomUUID().toString());

        public SectionEvent(Object SOURCE, EventTarget TARGET, EventType<SectionEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }
}

