/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Marker;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class BulletChartSkin
extends GaugeSkinBase {
    private double preferredWidth = 400.0;
    private double preferredHeight = 64.0;
    private Pane pane;
    private double width;
    private double height;
    private double size;
    private double aspectRatio;
    private Orientation orientation;
    private Canvas tickMarkCanvas;
    private GraphicsContext tickMarksCtx;
    private Canvas sectionsCanvas;
    private GraphicsContext sectionsCtx;
    private Text titleText;
    private Text unitText;
    private Rectangle barRect;
    private Rectangle thresholdRect;
    private double stepSize;
    private Tooltip barTooltip;
    private Tooltip thresholdTooltip;
    private ListChangeListener<Section> sectionListener;
    private ListChangeListener<Marker> markerListener;
    private InvalidationListener currentValueListener;
    private InvalidationListener paneSizeListener;

    public BulletChartSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.orientation = gauge.getOrientation();
        this.barTooltip = new Tooltip();
        this.thresholdTooltip = new Tooltip();
        this.sectionListener = c -> this.redraw();
        this.markerListener = c -> this.redraw();
        this.currentValueListener = o -> this.updateBar();
        this.paneSizeListener = o -> this.handleEvents("RESIZE");
        if (Orientation.VERTICAL == this.orientation) {
            this.preferredWidth = 64.0;
            this.preferredHeight = 400.0;
        } else {
            this.preferredWidth = 400.0;
            this.preferredHeight = 64.0;
        }
        gauge.setPrefSize(this.preferredWidth, this.preferredHeight);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(this.preferredWidth, this.preferredHeight);
            }
        }
        this.orientation = this.gauge.getOrientation();
        this.aspectRatio = this.preferredHeight / this.preferredWidth;
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.tickMarkCanvas = new Canvas(0.79699248 * this.preferredWidth, 0.08333333 * this.preferredHeight);
        this.tickMarksCtx = this.tickMarkCanvas.getGraphicsContext2D();
        this.sectionsCanvas = new Canvas(0.79699248 * this.preferredWidth, 0.5 * this.preferredHeight);
        this.sectionsCtx = this.sectionsCanvas.getGraphicsContext2D();
        this.barRect = new Rectangle();
        Tooltip.install((Node)this.barRect, (Tooltip)this.barTooltip);
        this.thresholdRect = new Rectangle();
        Tooltip.install((Node)this.thresholdRect, (Tooltip)this.thresholdTooltip);
        this.pane = new Pane(new Node[]{this.titleText, this.unitText, this.tickMarkCanvas, this.sectionsCanvas, this.barRect, this.thresholdRect});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.getSections().addListener(this.sectionListener);
        this.gauge.getTickMarkSections().addListener(this.sectionListener);
        this.gauge.getTickLabelSections().addListener(this.sectionListener);
        this.gauge.getMarkers().addListener(this.markerListener);
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
        this.pane.widthProperty().addListener(this.paneSizeListener);
        this.pane.heightProperty().addListener(this.paneSizeListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
            this.redraw();
        } else if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            if (Orientation.VERTICAL == this.orientation) {
                this.width = this.height / this.aspectRatio;
                this.stepSize = 0.79699248 * this.height / this.gauge.getRange();
            } else {
                this.height = this.width / this.aspectRatio;
                this.stepSize = 0.79699248 * this.width / this.gauge.getRange();
            }
            this.resize();
            this.redraw();
            this.updateBar();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            this.barTooltip.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getValue()));
        }
    }

    @Override
    public void dispose() {
        this.gauge.getSections().removeListener(this.sectionListener);
        this.gauge.getTickMarkSections().removeListener(this.sectionListener);
        this.gauge.getTickLabelSections().removeListener(this.sectionListener);
        this.gauge.getMarkers().removeListener(this.markerListener);
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        this.pane.widthProperty().removeListener(this.paneSizeListener);
        this.pane.heightProperty().removeListener(this.paneSizeListener);
        super.dispose();
    }

    private void drawTickMarks(GraphicsContext CTX) {
        this.tickMarkCanvas.setCache(false);
        CTX.clearRect(0.0, 0.0, this.tickMarkCanvas.getWidth(), this.tickMarkCanvas.getHeight());
        CTX.setFill((Paint)this.gauge.getMajorTickMarkColor());
        ObservableList<Section> tickMarkSections = this.gauge.getTickMarkSections();
        ObservableList<Section> tickLabelSections = this.gauge.getTickLabelSections();
        Color majorTickMarkColor = this.gauge.getTickMarkColor();
        Color tickLabelColor = this.gauge.getTickLabelColor();
        boolean smallRange = Double.compare(this.gauge.getRange(), 10.0) <= 0;
        double minValue = this.gauge.getMinValue();
        double maxValue = this.gauge.getMaxValue();
        double tmpStepSize = smallRange ? this.stepSize / 10.0 : this.stepSize;
        Font tickLabelFont = Fonts.robotoRegular(0.1 * this.size);
        boolean tickMarkSectionsVisible = this.gauge.getTickMarkSectionsVisible();
        boolean tickLabelSectionsVisible = this.gauge.getTickLabelSectionsVisible();
        double offsetX = 0.18345865 * this.width;
        double offsetY = 0.1 * this.height;
        double innerPointX = 0.0;
        double innerPointY = 0.0;
        double outerPointX = 0.07 * this.width;
        double outerPointY = 0.08 * this.height;
        double textPointX = Orientation.HORIZONTAL == this.orientation ? 0.55 * this.tickMarkCanvas.getWidth() : outerPointX + this.size * 0.05;
        double textPointY = 0.7 * this.tickMarkCanvas.getHeight();
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(this.gauge.getMinorTickSpace());
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(this.gauge.getMajorTickSpace());
        BigDecimal counterBD = BigDecimal.valueOf(this.gauge.getMinValue());
        double counter = minValue;
        double range = this.gauge.getRange();
        double i = 0.0;
        while (Double.compare(i, range) <= 0) {
            if (Orientation.VERTICAL == this.orientation) {
                outerPointY = innerPointY = counter * tmpStepSize + offsetY;
                textPointY = innerPointY;
            } else {
                outerPointX = innerPointX = counter * tmpStepSize + offsetX;
                textPointX = innerPointX;
            }
            CTX.setStroke((Paint)this.gauge.getTickMarkColor());
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                if (this.gauge.getMajorTickMarksVisible()) {
                    CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    CTX.setLineWidth(1.0);
                    CTX.strokeLine(innerPointX, innerPointY, outerPointX, outerPointY);
                }
                if (this.gauge.getTickLabelsVisible()) {
                    CTX.save();
                    CTX.translate(textPointX, textPointY);
                    CTX.setFont(tickLabelFont);
                    CTX.setTextAlign(Orientation.HORIZONTAL == this.orientation ? TextAlignment.CENTER : TextAlignment.LEFT);
                    CTX.setTextBaseline(VPos.CENTER);
                    CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : tickLabelColor));
                    if (Orientation.VERTICAL == this.orientation) {
                        CTX.fillText(Integer.toString((int)(maxValue - counter)), 0.0, 0.0);
                    } else {
                        CTX.fillText(Integer.toString((int)counter), 0.0, 0.0);
                    }
                    CTX.restore();
                }
            }
            if ((counter = (counterBD = counterBD.add(minorTickSpaceBD)).doubleValue()) > maxValue) break;
            i += 1.0;
        }
        this.tickMarkCanvas.setCache(true);
        this.tickMarkCanvas.setCacheHint(CacheHint.QUALITY);
    }

    private void drawSections(GraphicsContext CTX) {
        this.sectionsCanvas.setCache(false);
        CTX.clearRect(0.0, 0.0, this.sectionsCanvas.getWidth(), this.sectionsCanvas.getHeight());
        CTX.setFill(this.gauge.getBackgroundPaint());
        if (Orientation.VERTICAL == this.orientation) {
            CTX.fillRect(0.0, 0.0, 0.5 * this.width, 0.9 * this.height);
        } else {
            CTX.fillRect(0.0, 0.0, 0.79699248 * this.width, 0.5 * this.height);
        }
        double tmpStepSize = this.stepSize * 1.11111111;
        double minValue = this.gauge.getMinValue();
        double maxValue = this.gauge.getMaxValue();
        int listSize = this.gauge.getSections().size();
        for (int i = 0; i < listSize; ++i) {
            Section SECTION = (Section)this.gauge.getSections().get(i);
            double SECTION_SIZE = SECTION.getRange() * tmpStepSize;
            if (Double.compare(SECTION.getStart(), maxValue) > 0 || Double.compare(SECTION.getStop(), minValue) < 0) continue;
            double SECTION_START = Double.compare(SECTION.getStart(), minValue) < 0 && Double.compare(SECTION.getStop(), maxValue) < 0 ? minValue * tmpStepSize : this.height - SECTION.getStart() * tmpStepSize - SECTION_SIZE;
            CTX.save();
            CTX.setFill((Paint)SECTION.getColor());
            if (Orientation.VERTICAL == this.orientation) {
                CTX.fillRect(0.0, SECTION_START, 0.5 * this.width, SECTION_SIZE);
            } else {
                CTX.fillRect(SECTION_START, 0.0, SECTION_SIZE, 0.5 * this.height);
            }
            CTX.restore();
        }
        this.sectionsCanvas.setCache(true);
        this.sectionsCanvas.setCacheHint(CacheHint.QUALITY);
    }

    private void updateBar() {
        double currentValue = this.gauge.getCurrentValue();
        if (Orientation.VERTICAL == this.orientation) {
            this.barRect.setHeight(currentValue * this.stepSize);
            this.barRect.setY(this.height - this.barRect.getHeight());
            this.thresholdRect.setY(this.height - this.gauge.getThreshold() * this.stepSize - 0.03125 * this.size);
        } else {
            this.barRect.setWidth(currentValue * this.stepSize);
            this.thresholdRect.setX(this.gauge.getThreshold() * this.stepSize - 0.03125 * this.height + 0.1835 * this.width);
        }
    }

    @Override
    protected void resize() {
        this.width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom();
        double currentValue = this.gauge.getCurrentValue();
        this.orientation = this.gauge.getOrientation();
        if (Orientation.VERTICAL == this.orientation) {
            this.width = this.height / this.aspectRatio;
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
            this.width = this.pane.getLayoutBounds().getWidth();
            this.height = this.pane.getLayoutBounds().getHeight();
            this.size = this.width < this.height ? this.width : this.height;
            this.stepSize = 0.9 * this.height / this.gauge.getRange();
            this.tickMarkCanvas.setWidth(0.39 * this.width);
            this.tickMarkCanvas.setHeight(this.height);
            this.tickMarkCanvas.relocate(0.578125 * this.width, 0.0);
            this.sectionsCanvas.setWidth(0.5 * this.width);
            this.sectionsCanvas.setHeight(0.9 * this.height);
            this.sectionsCanvas.relocate(0.078125 * this.width, 0.1 * this.height);
            this.barRect.setWidth(0.16666667 * this.width);
            this.barRect.setHeight(currentValue * this.stepSize);
            this.barRect.setX(0.078125 * this.width + (0.5 * this.width - this.barRect.getWidth()) * 0.5);
            this.barRect.setY(this.height - currentValue * this.stepSize);
            this.thresholdRect.setX(0.16145833 * this.width);
            this.thresholdRect.setY(this.height - this.gauge.getThreshold() * this.stepSize - 0.03125 * this.size);
            this.thresholdRect.setWidth(0.33333333 * this.width);
            this.thresholdRect.setHeight(0.0625 * this.size);
            double maxTextWidth = this.width;
            double fontSize = 0.24 * this.size;
            this.titleText.setFont(Fonts.robotoRegular(fontSize));
            if (this.titleText.getLayoutBounds().getWidth() > maxTextWidth) {
                Helper.adjustTextSize(this.titleText, maxTextWidth, fontSize);
            }
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.03 * this.height);
            fontSize = 0.15 * this.size;
            this.unitText.setFont(Fonts.robotoRegular(fontSize));
            if (this.unitText.getLayoutBounds().getWidth() > maxTextWidth) {
                Helper.adjustTextSize(this.unitText, maxTextWidth, fontSize);
            }
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.35 * this.width);
        } else {
            this.height = this.width * this.aspectRatio;
            this.stepSize = 0.79699248 * this.width / this.gauge.getRange();
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
            this.width = this.pane.getLayoutBounds().getWidth();
            this.height = this.pane.getLayoutBounds().getHeight();
            this.size = this.width < this.height ? this.width : this.height;
            this.tickMarkCanvas.setWidth(this.width);
            this.tickMarkCanvas.setHeight(0.29166667 * this.height);
            this.tickMarkCanvas.relocate(0.0, 0.60416667 * this.height);
            this.sectionsCanvas.setWidth(0.79699248 * this.width);
            this.sectionsCanvas.setHeight(0.5 * this.height);
            this.sectionsCanvas.relocate(0.18345865 * this.width, 0.10416667 * this.height);
            this.barRect.setWidth(currentValue * this.stepSize);
            this.barRect.setHeight(0.16666667 * this.height);
            this.barRect.setX(0.18345865 * this.width);
            this.barRect.setY(0.10416667 * this.height + (0.5 * this.height - this.barRect.getHeight()) * 0.5);
            this.thresholdRect.setX(this.gauge.getThreshold() * this.stepSize - 0.03125 * this.height + 0.20300752 * this.width);
            this.thresholdRect.setY(0.1875 * this.height);
            this.thresholdRect.setWidth(0.0625 * this.height);
            this.thresholdRect.setHeight(0.33333333 * this.height);
            double maxTextWidth = 0.20300752 * this.width;
            double fontSize = 0.24 * this.size;
            this.titleText.setFont(Fonts.robotoMedium(fontSize));
            if (this.titleText.getLayoutBounds().getWidth() > maxTextWidth) {
                Helper.adjustTextSize(this.titleText, maxTextWidth, fontSize);
            }
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.075 * this.height);
            fontSize = 0.15 * this.size;
            this.unitText.setFont(Fonts.robotoRegular(fontSize));
            if (this.unitText.getLayoutBounds().getWidth() > maxTextWidth) {
                Helper.adjustTextSize(this.unitText, maxTextWidth, fontSize);
            }
            this.unitText.relocate(0.17593985 * this.width - this.unitText.getLayoutBounds().getWidth(), 0.4 * this.height);
        }
        this.redraw();
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.drawTickMarks(this.tickMarksCtx);
        this.drawSections(this.sectionsCtx);
        this.thresholdRect.setFill((Paint)this.gauge.getThresholdColor());
        this.thresholdTooltip.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getThreshold()));
        this.barRect.setFill((Paint)this.gauge.getBarColor());
        Helper.enableNode((Node)this.titleText, true);
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        this.updateBar();
    }
}

