/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.AngleConicalGradient;
import eu.hansolo.medusa.tools.Helper;
import java.util.HashMap;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;

public class NasaSkin
extends GaugeSkinBase {
    private static final double ANGLE_RANGE = 216.0;
    private double size;
    private double oldSize;
    private Arc lowerFrame;
    private Arc barBackground;
    private Circle outerCircle;
    private Circle innerCircle;
    private Line separator;
    private Arc bar;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Pane pane;
    private AngleConicalGradient gradient;
    private Rectangle gradientRect;
    private boolean gradientNeedsRefresh;
    private InvalidationListener decimalListener;
    private InvalidationListener currentValueListener;

    public NasaSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.decimalListener = o -> this.handleEvents("DECIMALS");
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.gradientNeedsRefresh = true;
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.outerCircle = new Circle();
        this.outerCircle.setFill(null);
        this.innerCircle = new Circle();
        this.innerCircle.setFill(null);
        this.lowerFrame = new Arc(125.0, 125.0, 100.0, 100.0, this.gauge.getStartAngle() + 90.0, 144.0);
        this.lowerFrame.setType(ArcType.OPEN);
        this.lowerFrame.setStroke((Paint)this.gauge.getValueColor());
        this.lowerFrame.setStrokeWidth(15.10989);
        this.lowerFrame.setStrokeLineCap(StrokeLineCap.BUTT);
        this.lowerFrame.setFill(null);
        this.barBackground = new Arc(125.0, 125.0, 100.0, 100.0, this.gauge.getStartAngle() + 90.0, -216.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.gauge.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(15.10989);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.separator = new Line();
        this.separator.setStroke((Paint)this.gauge.getValueColor());
        this.separator.setFill((Paint)this.gauge.getValueColor());
        this.separator.setStrokeWidth(Helper.clamp(1.0, Double.MAX_VALUE, 1.3736275));
        this.bar = new Arc(125.0, 125.0, 100.0, 100.0, this.gauge.getStartAngle() + 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)this.gauge.getBarColor());
        this.bar.setStrokeWidth(15.10989);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text();
        this.valueText.setStroke(null);
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.unitText = new Text();
        this.unitText.setStroke(null);
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, this.gauge.isValueVisible() && !this.gauge.getUnit().isEmpty());
        if (this.gauge.isGradientBarEnabled()) {
            this.setupGradient();
        }
        this.pane = new Pane(new Node[]{this.outerCircle, this.innerCircle, this.lowerFrame, this.barBackground, this.separator, this.titleText, this.valueText, this.unitText, this.bar, this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.decimalsProperty().addListener(this.decimalListener);
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, this.gauge.isValueVisible() && !this.gauge.getUnit().isEmpty());
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.redraw();
            this.setBar(this.gauge.getCurrentValue());
        }
    }

    @Override
    public void dispose() {
        this.gauge.decimalsProperty().removeListener(this.decimalListener);
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void setBar(double VALUE) {
        double barLength = 0.0;
        double barStart = 0.0;
        double min = this.gauge.getMinValue();
        double max = this.gauge.getMaxValue();
        double step = this.gauge.getAngleStep();
        double clampedValue = Helper.clamp(min, max, VALUE);
        if (this.gauge.isStartFromZero()) {
            if ((VALUE > min || min < 0.0) && (VALUE < max || max > 0.0)) {
                if (max < 0.0) {
                    barStart = this.gauge.getStartAngle() + 90.0 - this.gauge.getAngleRange();
                    barLength = (max - clampedValue) * step;
                } else if (min > 0.0) {
                    barStart = this.gauge.getStartAngle() + 90.0;
                    barLength = (min - clampedValue) * step;
                } else {
                    barStart = this.gauge.getStartAngle() + 90.0 + min * step;
                    barLength = -clampedValue * step;
                }
            }
        } else {
            barStart = this.gauge.getStartAngle() + 90.0;
            barLength = (min - clampedValue) * step;
        }
        this.bar.setStartAngle(barStart);
        this.bar.setLength(barLength);
        if (this.gauge.isGradientBarEnabled() && this.gauge.getGradientBarStops().size() > 1) {
            this.bar.setStroke((Paint)this.gauge.getGradientLookup().getColorAt((VALUE - this.gauge.getMinValue()) / this.gauge.getRange()));
            this.bar.setStroke((Paint)this.gradient.getImagePattern(this.gradientRect));
        } else {
            this.bar.setStroke((Paint)this.gauge.getBarColor());
        }
        this.valueText.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.valueText.setLayoutX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
    }

    private void drawTicks() {
        double stepSize = 2.16;
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        Helper.drawRadialTickMarks(this.gauge, this.ctx, this.gauge.getMinValue(), this.gauge.getMaxValue(), -72.0, 216.0, stepSize, this.size * 0.5, this.size * 0.5, this.size * 1.045);
    }

    private void drawBackground() {
        this.outerCircle.setStroke((Paint)this.gauge.getValueColor());
        this.innerCircle.setStroke((Paint)this.gauge.getValueColor());
        this.lowerFrame.setStroke((Paint)this.gauge.getValueColor());
        this.barBackground.setStroke((Paint)this.gauge.getBarBackgroundColor());
        this.separator.setStroke((Paint)this.gauge.getValueColor());
    }

    private void resizeValueText() {
        double maxWidth = this.size * 0.71;
        double fontSize = this.size * 0.21;
        this.valueText.setFont(Fonts.estrictaMedium(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.275);
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.67;
        double fontSize = this.size * 0.13;
        this.titleText.setFont(Fonts.estrictaRegularItalic(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.64);
        this.titleText.setFill((Paint)Color.RED);
        fontSize = this.size * 0.08;
        this.unitText.setFont(Fonts.estrictaRegularItalic(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.52);
    }

    private void setupGradient() {
        List<Stop> stops = this.gauge.getGradientBarStops();
        HashMap<Double, Color> stopAngleMap = new HashMap<Double, Color>(stops.size());
        for (Stop stop : stops) {
            stopAngleMap.put(stop.getOffset() * 216.0, stop.getColor());
        }
        this.gradient = new AngleConicalGradient(this.size * 0.5, this.size * 0.5, 252.0, stopAngleMap, this.gauge.getScaleDirection());
        this.gradientRect = new Rectangle(0.0, 0.0, this.size, this.size);
        this.gradientNeedsRefresh = false;
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.gauge.getWidth() - this.size) * 0.5, (this.gauge.getHeight() - this.size) * 0.5);
            if (this.oldSize != this.size) {
                this.gradientNeedsRefresh = true;
            }
            if (this.gauge.isGradientBarEnabled() && this.gradientNeedsRefresh) {
                this.setupGradient();
            }
            double centerX = this.size * 0.5;
            double centerY = this.size * 0.5;
            this.outerCircle.setCenterX(centerX);
            this.outerCircle.setCenterY(centerY);
            this.outerCircle.setRadius(this.size * 0.5);
            this.outerCircle.setStrokeWidth(1.0);
            this.innerCircle.setCenterX(centerX);
            this.innerCircle.setCenterY(centerY);
            this.innerCircle.setRadius(this.size * 0.43956044);
            this.innerCircle.setStrokeWidth(1.0);
            this.lowerFrame.setCenterX(centerX);
            this.lowerFrame.setCenterY(centerY);
            this.lowerFrame.setRadiusX(this.size * 0.46978022);
            this.lowerFrame.setRadiusY(this.size * 0.46978022);
            this.lowerFrame.setStrokeWidth(this.size * 0.06043956);
            this.barBackground.setCenterX(centerX);
            this.barBackground.setCenterY(centerY);
            this.barBackground.setRadiusX(this.size * 0.46978022);
            this.barBackground.setRadiusY(this.size * 0.46978022);
            this.barBackground.setStrokeWidth(this.size * 0.06043956);
            this.separator.setStartX(this.size * 0.16483516);
            this.separator.setStartY(this.size * 0.6456044);
            this.separator.setEndX(this.size * 0.83516484);
            this.separator.setEndY(this.size * 0.6456044);
            this.separator.setStrokeWidth(Helper.clamp(1.0, Double.MAX_VALUE, this.size * 0.00549451));
            this.bar.setCenterX(centerX);
            this.bar.setCenterY(centerY);
            this.bar.setRadiusX(this.size * 0.46978022);
            this.bar.setRadiusY(this.size * 0.46978022);
            this.bar.setStrokeWidth(this.size * 0.06043956);
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.redraw();
        }
        this.oldSize = this.size;
    }

    @Override
    protected void redraw() {
        if (this.gauge.isGradientBarEnabled() && this.gradientNeedsRefresh) {
            this.setupGradient();
        }
        this.drawBackground();
        this.setBar(this.gauge.getCurrentValue());
        this.drawTicks();
        this.resizeValueText();
        this.titleText.setText(this.gauge.getTitle());
        this.unitText.setText(this.gauge.getUnit());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
    }
}

