/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.tools;

import eu.hansolo.medusa.Alarm;
import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelLocation;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.TickMarkType;
import eu.hansolo.medusa.TimeSection;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class Helper {
    public static final double MAX_TICK_MARK_LENGTH = 0.125;
    public static final double MAX_TICK_MARK_WIDTH = 0.02;
    public static final Color INACTIVE_ALARM_COLOR = Color.rgb((int)90, (int)90, (int)90, (double)0.5);
    public static final double MIN_FONT_SIZE = 5.0;

    public static final <T extends Number> T clamp(T MIN, T MAX, T VALUE) {
        if (VALUE.doubleValue() < MIN.doubleValue()) {
            return MIN;
        }
        if (VALUE.doubleValue() > MAX.doubleValue()) {
            return MAX;
        }
        return VALUE;
    }

    public static final int clamp(int MIN, int MAX, int VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final long clamp(long MIN, long MAX, long VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final double clamp(double MIN, double MAX, double VALUE) {
        if (Double.compare(VALUE, MIN) < 0) {
            return MIN;
        }
        if (Double.compare(VALUE, MAX) > 0) {
            return MAX;
        }
        return VALUE;
    }

    public static final double clampMin(double MIN, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        return VALUE;
    }

    public static final double clampMax(double MAX, double VALUE) {
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static final double round(double VALUE, int PRECISION) {
        int SCALE = (int)Math.pow(10.0, PRECISION);
        return (double)Math.round(VALUE * (double)SCALE) / (double)SCALE;
    }

    public static final double roundTo(double VALUE, double TARGET) {
        return TARGET * (double)Math.round(VALUE / TARGET);
    }

    public static final double roundToHalf(double VALUE) {
        return (double)Math.round(VALUE * 2.0) / 2.0;
    }

    public static final double nearest(double SMALLER, double VALUE, double LARGER) {
        return VALUE - SMALLER < LARGER - VALUE ? SMALLER : LARGER;
    }

    public static final int roundDoubleToInt(double VALUE) {
        int i;
        double dAbs = Math.abs(VALUE);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return VALUE < 0.0 ? -i : i;
        }
        return VALUE < 0.0 ? -(i + 1) : i + 1;
    }

    public static final double[] calcAutoScale(double MIN_VALUE, double MAX_VALUE) {
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        double niceRange = Helper.calcNiceNumber(MAX_VALUE - MIN_VALUE, false);
        double majorTickSpace = Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true);
        double niceMinValue = Math.floor(MIN_VALUE / majorTickSpace) * majorTickSpace;
        double niceMaxValue = Math.ceil(MAX_VALUE / majorTickSpace) * majorTickSpace;
        double minorTickSpace = Helper.calcNiceNumber(majorTickSpace / (maxNoOfMinorTicks - 1.0), true);
        return new double[]{niceMinValue, niceMaxValue, majorTickSpace, minorTickSpace};
    }

    public static final double[] getNiceScale(double MIN, double MAX) {
        return Helper.getNiceScale(MIN, MAX, 20);
    }

    public static final double[] getNiceScale(double MIN, double MAX, int MAX_NO_OF_TICKS) {
        double niceMax;
        double minimum = MIN;
        double maximum = MAX;
        double epsilon = (MAX - MIN) / 1000000.0;
        double range = (maximum += epsilon) - (minimum -= epsilon);
        int stepCount = MAX_NO_OF_TICKS;
        double roughStep = range / (double)(stepCount - 1);
        double[] goodNormalizedSteps = new double[]{1.0, 2.0, 5.0, 10.0};
        double stepPower = Math.pow(10.0, -Math.floor(Math.log10(Math.abs(roughStep))));
        double normalizedStep = roughStep * stepPower;
        double goodNormalizedStep = Arrays.stream(goodNormalizedSteps).filter(n -> Double.compare(n, normalizedStep) >= 0).findFirst().getAsDouble();
        double niceStep = goodNormalizedStep / stepPower;
        double niceMin = minimum < 0.0 ? Math.floor(minimum / niceStep) * niceStep : Math.ceil(minimum / niceStep) * niceStep;
        double d = niceMax = maximum < 0.0 ? Math.floor(maximum / niceStep) * niceStep : Math.ceil(maximum / niceStep) * niceStep;
        if (MIN % niceStep == 0.0) {
            niceMin = MIN;
        }
        if (MAX % niceStep == 0.0) {
            niceMax = MAX;
        }
        double niceRange = niceMax - niceMin;
        return new double[]{niceMin, niceMax, niceRange, niceStep};
    }

    public static final double snapToTicks(double MIN_VALUE, double MAX_VALUE, double VALUE, int MINOR_TICK_COUNT, double MAJOR_TICK_UNIT) {
        double v = VALUE;
        int minorTickCount = Helper.clamp(0, 10, MINOR_TICK_COUNT);
        double majorTickUnit = Double.compare(MAJOR_TICK_UNIT, 0.0) <= 0 ? 0.25 : MAJOR_TICK_UNIT;
        double tickSpacing = minorTickCount != 0 ? majorTickUnit / (double)(Math.max(minorTickCount, 0) + 1) : majorTickUnit;
        int prevTick = (int)((v - MIN_VALUE) / tickSpacing);
        double prevTickValue = (double)prevTick * tickSpacing + MIN_VALUE;
        double nextTickValue = (double)(prevTick + 1) * tickSpacing + MIN_VALUE;
        v = Helper.nearest(prevTickValue, v, nextTickValue);
        return Helper.clamp(MIN_VALUE, MAX_VALUE, v);
    }

    public static final double calcNiceNumber(double RANGE, boolean ROUND) {
        double exponent = Math.floor(Math.log10(RANGE));
        double fraction = RANGE / Math.pow(10.0, exponent);
        double niceFraction = ROUND ? (fraction < 1.5 ? 1.0 : (fraction < 3.0 ? 2.0 : (fraction < 7.0 ? 5.0 : 10.0))) : (fraction <= 1.0 ? 1.0 : (fraction <= 2.0 ? 2.0 : (fraction <= 5.0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    public static final Color getColorOfSection(List<Section> SECTIONS, double VALUE, Color DEFAULT_COLOR) {
        for (Section section : SECTIONS) {
            if (!section.contains(VALUE)) continue;
            return section.getColor();
        }
        return DEFAULT_COLOR;
    }

    public static final void rotateContextForText(GraphicsContext CTX, double START_ANGLE, double ANGLE, TickLabelOrientation ORIENTATION) {
        switch (ORIENTATION) {
            case ORTHOGONAL: {
                if ((360.0 - START_ANGLE - ANGLE) % 360.0 > 90.0 && (360.0 - START_ANGLE - ANGLE) % 360.0 < 270.0) {
                    CTX.rotate((180.0 - START_ANGLE - ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((360.0 - START_ANGLE - ANGLE) % 360.0);
                break;
            }
            case TANGENT: {
                if ((360.0 - START_ANGLE - ANGLE - 90.0) % 360.0 > 90.0 && (360.0 - START_ANGLE - ANGLE - 90.0) % 360.0 < 270.0) {
                    CTX.rotate((90.0 - START_ANGLE - ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((270.0 - START_ANGLE - ANGLE) % 360.0);
                break;
            }
        }
    }

    public static final void adjustTextSize(Text TEXT, double MAX_WIDTH, double FONT_SIZE) {
        String FONT_NAME = TEXT.getFont().getName();
        double adjustableFontSize = FONT_SIZE;
        while (TEXT.getLayoutBounds().getWidth() > MAX_WIDTH && adjustableFontSize > 5.0) {
            TEXT.setFont(new Font(FONT_NAME, adjustableFontSize -= 0.1));
        }
    }

    public static final void adjustTextSize(Label TEXT, double MAX_WIDTH, double FONT_SIZE) {
        String FONT_NAME = TEXT.getFont().getName();
        double adjustableFontSize = FONT_SIZE;
        while (TEXT.getLayoutBounds().getWidth() > MAX_WIDTH && adjustableFontSize > 5.0) {
            TEXT.setFont(new Font(FONT_NAME, adjustableFontSize -= 0.1));
        }
    }

    public static final DateTimeFormatter getDateFormat(Locale LOCALE) {
        if (Locale.US == LOCALE) {
            return DateTimeFormatter.ofPattern("MM/dd/YYYY");
        }
        if (Locale.CHINA == LOCALE) {
            return DateTimeFormatter.ofPattern("YYYY.MM.dd");
        }
        return DateTimeFormatter.ofPattern("dd.MM.YYYY");
    }

    public static final DateTimeFormatter getLocalizedDateFormat(Locale LOCALE) {
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(LOCALE);
    }

    public static final void enableNode(Node NODE, boolean ENABLE) {
        NODE.setManaged(ENABLE);
        NODE.setVisible(ENABLE);
    }

    public static final String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    public static final ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    public static final void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    public static final ImagePattern createCarbonPattern() {
        double SIZE = 12.0;
        Canvas CANVAS = new Canvas(12.0, 12.0);
        GraphicsContext CTX = CANVAS.getGraphicsContext2D();
        CTX.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 6.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)35, (int)35, (int)35)), new Stop(1.0, Color.rgb((int)23, (int)23, (int)23))}));
        CTX.fillRect(0.0, 0.0, 6.0, 6.0);
        CTX.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 4.999992, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)30, (int)30, (int)30))}));
        CTX.fillRect(0.9999960000000001, 0.0, 3.999996, 4.999992);
        CTX.setFill((Paint)new LinearGradient(0.0, 6.0, 0.0, 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)35, (int)35, (int)35)), new Stop(1.0, Color.rgb((int)23, (int)23, (int)23))}));
        CTX.fillRect(6.0, 6.0, 6.0, 6.0);
        CTX.setFill((Paint)new LinearGradient(0.0, 6.0, 0.0, 10.999991999999999, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)30, (int)30, (int)30))}));
        CTX.fillRect(6.999995999999999, 6.0, 3.999996, 4.999992);
        CTX.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 6.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)48, (int)48, (int)48)), new Stop(1.0, Color.rgb((int)40, (int)40, (int)40))}));
        CTX.fillRect(6.0, 0.0, 6.0, 6.0);
        CTX.setFill((Paint)new LinearGradient(0.0, 0.9999960000000001, 0.0, 6.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)53, (int)53, (int)53)), new Stop(1.0, Color.rgb((int)45, (int)45, (int)45))}));
        CTX.fillRect(6.999995999999999, 0.9999960000000001, 3.999996, 4.999992);
        CTX.setFill((Paint)new LinearGradient(0.0, 6.0, 0.0, 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)48, (int)48, (int)48)), new Stop(1.0, Color.rgb((int)40, (int)40, (int)40))}));
        CTX.fillRect(0.0, 6.0, 6.0, 6.0);
        CTX.setFill((Paint)new LinearGradient(0.0, 6.999995999999999, 0.0, 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)53, (int)53, (int)53)), new Stop(1.0, Color.rgb((int)45, (int)45, (int)45))}));
        CTX.fillRect(0.9999960000000001, 6.999995999999999, 3.999996, 4.999992);
        WritableImage PATTERN_IMAGE = CANVAS.snapshot(new SnapshotParameters(), null);
        ImagePattern PATTERN = new ImagePattern((Image)PATTERN_IMAGE, 0.0, 0.0, 12.0, 12.0, false);
        return PATTERN;
    }

    public static final void drawTrapezoid(GraphicsContext CTX, double PI1X, double PI1Y, double PI2X, double PI2Y, double PO1X, double PO1Y, double PO2X, double PO2Y) {
        CTX.beginPath();
        CTX.moveTo(PI2X, PI2Y);
        CTX.lineTo(PI1X, PI1Y);
        CTX.lineTo(PO1X, PO1Y);
        CTX.lineTo(PO2X, PO2Y);
        CTX.closePath();
        CTX.fill();
    }

    public static final void drawTriangle(GraphicsContext CTX, double PIX, double PIY, double PO1X, double PO1Y, double PO2X, double PO2Y) {
        CTX.beginPath();
        CTX.moveTo(PIX, PIY);
        CTX.lineTo(PO1X, PO1Y);
        CTX.lineTo(PO2X, PO2Y);
        CTX.closePath();
        CTX.fill();
    }

    public static final void drawDot(GraphicsContext CTX, double CENTER_X, double CENTER_Y, double SIZE) {
        CTX.fillOval(CENTER_X, CENTER_Y, SIZE, SIZE);
    }

    public static final void drawLine(GraphicsContext CTX, double P1X, double P1Y, double P2X, double P2Y) {
        CTX.strokeLine(P1X, P1Y, P2X, P2Y);
    }

    public static final boolean isMonochrome(Color COLOR) {
        return Double.compare(COLOR.getRed(), COLOR.getGreen()) == 0 && Double.compare(COLOR.getGreen(), COLOR.getBlue()) == 0;
    }

    public static final double colorDistance(Color COLOR_1, Color COLOR_2) {
        double DELTA_R = COLOR_2.getRed() - COLOR_1.getRed();
        double DELTA_G = COLOR_2.getGreen() - COLOR_1.getGreen();
        double DELTA_B = COLOR_2.getBlue() - COLOR_1.getBlue();
        return Math.sqrt(DELTA_R * DELTA_R + DELTA_G * DELTA_G + DELTA_B * DELTA_B);
    }

    public static final boolean isBright(Color COLOR) {
        return !Helper.isDark(COLOR);
    }

    public static final boolean isDark(Color COLOR) {
        double DISTANCE_TO_WHITE = Helper.colorDistance(COLOR, Color.WHITE);
        double DISTANCE_TO_BLACK = Helper.colorDistance(COLOR, Color.BLACK);
        return DISTANCE_TO_BLACK < DISTANCE_TO_WHITE;
    }

    public static final Color getTranslucentColorFrom(Color COLOR, double FACTOR) {
        return Color.color((double)COLOR.getRed(), (double)COLOR.getGreen(), (double)COLOR.getBlue(), (double)Helper.clamp(0.0, 1.0, FACTOR));
    }

    /*
     * WARNING - void declaration
     */
    public static final void drawRadialTickMarks(Gauge GAUGE, GraphicsContext CTX, double MIN_VALUE, double MAX_VALUE, double START_ANGLE, double ANGLE_RANGE, double ANGLE_STEP, double CENTER_X, double CENTER_Y, double SIZE) {
        double tickLabelFontSize;
        double minorHalfDotSize;
        double minorDotSize;
        double mediumHalfDotSize;
        double mediumDotSize;
        double majorHalfDotSize;
        double majorDotSize;
        double orthTextFactor;
        double textDisplacementFactor;
        List<String> customTickLabels;
        double centerX = CENTER_X;
        double centerY = CENTER_Y;
        int tickLabelDecimals = GAUGE.getTickLabelDecimals();
        String tickLabelFormatString = "%." + tickLabelDecimals + "f";
        double minorTickSpace = GAUGE.getMinorTickSpace();
        double tmpAngleStep = ANGLE_STEP * minorTickSpace;
        TickLabelOrientation tickLabelOrientation = GAUGE.getTickLabelOrientation();
        TickLabelLocation tickLabelLocation = GAUGE.getTickLabelLocation();
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(GAUGE.getMajorTickSpace());
        BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
        BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
        BigDecimal counterBD = BigDecimal.valueOf(MIN_VALUE);
        double counter = MIN_VALUE;
        ObservableList<Section> tickMarkSections = GAUGE.getTickMarkSections();
        ObservableList<Section> tickLabelSections = GAUGE.getTickLabelSections();
        Color tickMarkColor = GAUGE.getTickMarkColor();
        Color majorTickMarkColor = GAUGE.getMajorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : GAUGE.getMajorTickMarkColor();
        Color mediumTickMarkColor = GAUGE.getMediumTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : GAUGE.getMediumTickMarkColor();
        Color minorTickMarkColor = GAUGE.getMinorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : GAUGE.getMinorTickMarkColor();
        double majorTickMarkLengthFactor = GAUGE.getMajorTickMarkLengthFactor();
        double majorTickMarkWidthFactor = GAUGE.getMajorTickMarkWidthFactor();
        double mediumTickMarkLengthFactor = GAUGE.getMediumTickMarkLengthFactor();
        double mediumTickMarkWidthFactor = GAUGE.getMediumTickMarkWidthFactor();
        double minorTickMarkLengthFactor = GAUGE.getMinorTickMarkLengthFactor();
        double minorTickMarkWidthFactor = GAUGE.getMinorTickMarkWidthFactor();
        Color tickLabelColor = GAUGE.getTickLabelColor();
        Color zeroColor = GAUGE.getZeroColor();
        boolean isNotZero = true;
        TickMarkType majorTickMarkType = GAUGE.getMajorTickMarkType();
        TickMarkType mediumTickMarkType = GAUGE.getMediumTickMarkType();
        TickMarkType minorTickMarkType = GAUGE.getMinorTickMarkType();
        boolean tickMarkSectionsVisible = GAUGE.getTickMarkSectionsVisible();
        boolean tickLabelSectionsVisible = GAUGE.getTickLabelSectionsVisible();
        boolean majorTickMarksVisible = GAUGE.getMajorTickMarksVisible();
        boolean mediumTickMarksVisible = GAUGE.getMediumTickMarksVisible();
        boolean minorTickMarksVisible = GAUGE.getMinorTickMarksVisible();
        boolean tickLabelsVisible = GAUGE.getTickLabelsVisible();
        boolean onlyFirstAndLastLabelVisible = GAUGE.isOnlyFirstAndLastTickLabelVisible();
        boolean customTickLabelsEnabled = GAUGE.getCustomTickLabelsEnabled();
        Locale locale = GAUGE.getLocale();
        List<String> list = customTickLabels = customTickLabelsEnabled ? GAUGE.getCustomTickLabels() : null;
        double d = majorTickMarkType == TickMarkType.DOT ? (TickLabelLocation.OUTSIDE == tickLabelLocation ? 0.95 : 1.05) : (textDisplacementFactor = 1.0);
        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
            orthTextFactor = 0.45 * textDisplacementFactor;
            majorDotSize = 0.02 * SIZE;
            majorHalfDotSize = majorDotSize * 0.5;
            mediumDotSize = 0.01375 * SIZE;
            mediumHalfDotSize = mediumDotSize * 0.5;
            minorDotSize = 0.0075 * SIZE;
            minorHalfDotSize = minorDotSize * 0.5;
        } else {
            orthTextFactor = TickLabelOrientation.ORTHOGONAL == tickLabelOrientation ? 0.38 * textDisplacementFactor : 0.37 * textDisplacementFactor;
            majorDotSize = 0.025 * SIZE;
            majorHalfDotSize = majorDotSize * 0.5;
            mediumDotSize = 0.01875 * SIZE;
            mediumHalfDotSize = mediumDotSize * 0.5;
            minorDotSize = 0.0125 * SIZE;
            minorHalfDotSize = minorDotSize * 0.5;
        }
        double customFontSizeFactor = GAUGE.getCustomTickLabelFontSize() / 400.0;
        boolean fullRange = MIN_VALUE < 0.0 && MAX_VALUE > 0.0;
        double d2 = tickLabelFontSize = tickLabelDecimals == 0 ? 0.054 * SIZE : 0.051 * SIZE;
        if (GAUGE.getCustomTickLabelsEnabled() || GAUGE.getCustomTickLabelFontSizeEnabled()) {
            tickLabelFontSize = customFontSizeFactor * SIZE;
        }
        double tickMarkFontSize = tickLabelDecimals == 0 ? 0.047 * SIZE : 0.044 * SIZE;
        double tickLabelOrientationFactor = TickLabelOrientation.HORIZONTAL == tickLabelOrientation ? 0.9 : 1.0;
        Font tickLabelFont = Fonts.robotoCondensedRegular(tickLabelFontSize * tickLabelOrientationFactor);
        Font tickMarkFont = Fonts.robotoCondensedRegular(tickMarkFontSize * tickLabelOrientationFactor);
        Font tickLabelZeroFont = fullRange ? Fonts.robotoCondensedBold(tickLabelFontSize * tickLabelOrientationFactor) : tickLabelFont;
        Font tickMarkZeroFont = fullRange ? Fonts.robotoCondensedBold(tickMarkFontSize * tickLabelOrientationFactor) : tickMarkFont;
        Gauge.ScaleDirection scaleDirection = GAUGE.getScaleDirection();
        if (GAUGE.isTickMarkRingVisible()) {
            Gauge.SkinType skinType = GAUGE.getSkinType();
            double xy = TickLabelLocation.INSIDE == tickLabelLocation ? SIZE * 0.026 : SIZE * 0.14;
            double wh = TickLabelLocation.INSIDE == tickLabelLocation ? SIZE * 0.948 : SIZE * 0.72;
            double offset = -90.0 + START_ANGLE;
            double horVerOffset = SIZE * 0.055555555;
            CTX.setLineWidth(SIZE * 0.004);
            CTX.setLineCap(StrokeLineCap.SQUARE);
            CTX.save();
            CTX.setStroke((Paint)tickMarkColor);
            switch (skinType) {
                case HORIZONTAL: {
                    CTX.strokeArc(xy + horVerOffset, xy, wh, wh, offset, -ANGLE_RANGE, ArcType.OPEN);
                    break;
                }
                case VERTICAL: {
                    CTX.strokeArc(xy, xy + horVerOffset, wh, wh, offset, -ANGLE_RANGE, ArcType.OPEN);
                    break;
                }
                default: {
                    CTX.strokeArc(xy, xy, wh, wh, offset, -ANGLE_RANGE, ArcType.OPEN);
                }
            }
            CTX.restore();
            if (tickMarkSections.size() > 0) {
                void i;
                int listSize = tickMarkSections.size();
                boolean bl = false;
                while (i < listSize) {
                    double sectionAngleExtend;
                    double sectionStartAngle;
                    void section;
                    Section section2 = (Section)tickMarkSections.get((int)i);
                    if (Double.compare(section.getStart(), MIN_VALUE) < 0 && Double.compare(section.getStop(), MAX_VALUE) < 0) {
                        sectionStartAngle = 0.0;
                    } else {
                        double d3 = sectionStartAngle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? (section.getStart() - MIN_VALUE) * ANGLE_STEP : -(section.getStart() - MIN_VALUE) * ANGLE_STEP;
                    }
                    if (Double.compare(section.getStop(), MAX_VALUE) > 0) {
                        double d4 = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? (MAX_VALUE - section.getStart()) * ANGLE_STEP : -(MAX_VALUE - section.getStart()) * ANGLE_STEP;
                    } else {
                        sectionAngleExtend = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? (section.getStop() - section.getStart()) * ANGLE_STEP : -(section.getStop() - section.getStart()) * ANGLE_STEP;
                    }
                    CTX.save();
                    CTX.setStroke((Paint)section.getColor());
                    switch (skinType) {
                        case HORIZONTAL: {
                            CTX.strokeArc(xy + horVerOffset, xy, wh, wh, offset - sectionStartAngle, -sectionAngleExtend, ArcType.OPEN);
                            break;
                        }
                        case VERTICAL: {
                            CTX.strokeArc(xy, xy + horVerOffset, wh, wh, offset - sectionStartAngle, -sectionAngleExtend, ArcType.OPEN);
                            break;
                        }
                        default: {
                            CTX.strokeArc(xy, xy, wh, wh, offset - sectionStartAngle, -sectionAngleExtend, ArcType.OPEN);
                        }
                    }
                    CTX.restore();
                    ++i;
                }
            }
        }
        BigDecimal tmpStepBD = new BigDecimal(tmpAngleStep);
        tmpStepBD = tmpStepBD.setScale(3, 4);
        double tmpStep = tmpStepBD.doubleValue();
        double angle = 0.0;
        int customTickLabelCounter = 0;
        double i = 0.0;
        while (Double.compare(-ANGLE_RANGE - tmpStep, i) <= 0) {
            double triangleMinorOuterPointX;
            double triangleMinorInnerPointY;
            double triangleMinorInnerPointX;
            double triangleMediumOuterPointY;
            double triangleMediumOuterPointX;
            double triangleMediumInnerPointY;
            double triangleMediumInnerPointX;
            double triangleMajorOuterPointY;
            double triangleMajorOuterPointX;
            double triangleMajorInnerPointY;
            double triangleMajorInnerPointX;
            double trapezoidMinorOuterPoint2Y;
            double trapezoidMinorOuterPoint2X;
            double trapezoidMinorOuterPoint1Y;
            double trapezoidMinorOuterPoint1X;
            double trapezoidMinorInnerPoint2Y;
            double trapezoidMinorInnerPoint2X;
            double trapezoidMinorInnerPoint1Y;
            double trapezoidMinorInnerPoint1X;
            double trapezoidMediumOuterPoint2Y;
            double trapezoidMediumOuterPoint2X;
            double trapezoidMediumOuterPoint1Y;
            double trapezoidMediumOuterPoint1X;
            double trapezoidMediumInnerPoint2Y;
            double trapezoidMediumInnerPoint2X;
            double trapezoidMediumInnerPoint1Y;
            double trapezoidMediumInnerPoint1X;
            double trapezoidMajorOuterPoint2Y;
            double trapezoidMajorOuterPoint2X;
            double trapezoidMajorOuterPoint1Y;
            double trapezoidMajorOuterPoint1X;
            double trapezoidMajorInnerPoint2Y;
            double trapezoidMajorInnerPoint2X;
            double trapezoidMajorInnerPoint1Y;
            double trapezoidMajorInnerPoint1X;
            double tickLabelTickMarkY;
            double tickLabelTickMarkX;
            double dotMinorCenterY;
            double dotMinorCenterX;
            double dotMediumCenterY;
            double dotMediumCenterX;
            double dotCenterY;
            double dotCenterX;
            double textPointY;
            double textPointX;
            double outerMinorPointY;
            double outerMinorPointX;
            double outerMediumPointY;
            double outerMediumPointX;
            double outerPointY;
            double outerPointX;
            double innerMinorPointY;
            double innerMinorPointX;
            double innerMediumPointY;
            double innerMediumPointX;
            double innerPointY;
            double innerPointX;
            double sinValue = Math.sin(Math.toRadians(angle + START_ANGLE));
            double cosValue = Math.cos(Math.toRadians(angle + START_ANGLE));
            double triangleMinorOuterPointY = switch (tickLabelLocation) {
                case TickLabelLocation.OUTSIDE -> {
                    innerPointX = centerX + SIZE * 0.3585 * sinValue;
                    innerPointY = centerY + SIZE * 0.3585 * cosValue;
                    innerMediumPointX = innerPointX;
                    innerMediumPointY = innerPointY;
                    innerMinorPointX = innerPointX;
                    innerMinorPointY = innerPointY;
                    outerPointX = centerX + SIZE * (0.3585 + 0.125 * majorTickMarkLengthFactor) * sinValue;
                    outerPointY = centerY + SIZE * (0.3585 + 0.125 * majorTickMarkLengthFactor) * cosValue;
                    outerMediumPointX = centerX + SIZE * (0.3585 + 0.125 * mediumTickMarkLengthFactor) * sinValue;
                    outerMediumPointY = centerY + SIZE * (0.3585 + 0.125 * mediumTickMarkLengthFactor) * cosValue;
                    outerMinorPointX = centerX + SIZE * (0.3585 + 0.125 * minorTickMarkLengthFactor) * sinValue;
                    outerMinorPointY = centerY + SIZE * (0.3585 + 0.125 * minorTickMarkLengthFactor) * cosValue;
                    textPointX = centerX + SIZE * orthTextFactor * sinValue;
                    textPointY = centerY + SIZE * orthTextFactor * cosValue;
                    dotCenterX = centerX + SIZE * 0.3685 * sinValue;
                    dotCenterY = centerY + SIZE * 0.3685 * cosValue;
                    dotMediumCenterX = centerX + SIZE * 0.365375 * sinValue;
                    dotMediumCenterY = centerY + SIZE * 0.365375 * cosValue;
                    dotMinorCenterX = centerX + SIZE * 0.36225 * sinValue;
                    dotMinorCenterY = centerY + SIZE * 0.36225 * cosValue;
                    tickLabelTickMarkX = centerX + SIZE * 0.3805 * sinValue;
                    tickLabelTickMarkY = centerY + SIZE * 0.3805 * cosValue;
                    double trapezoidMajorInnerAngle1 = Math.toRadians(angle - 1.2 + START_ANGLE);
                    double trapezoidMajorInnerAngle2 = Math.toRadians(angle + 1.2 + START_ANGLE);
                    double trapezoidMajorOuterAngle1 = Math.toRadians(angle - 0.8 + START_ANGLE);
                    double trapezoidMajorOuterAngle2 = Math.toRadians(angle + 0.8 + START_ANGLE);
                    trapezoidMajorInnerPoint1X = centerX + SIZE * 0.3585 * Math.sin(trapezoidMajorInnerAngle1);
                    trapezoidMajorInnerPoint1Y = centerY + SIZE * 0.3585 * Math.cos(trapezoidMajorInnerAngle1);
                    trapezoidMajorInnerPoint2X = centerX + SIZE * 0.3585 * Math.sin(trapezoidMajorInnerAngle2);
                    trapezoidMajorInnerPoint2Y = centerY + SIZE * 0.3585 * Math.cos(trapezoidMajorInnerAngle2);
                    trapezoidMajorOuterPoint1X = centerX + SIZE * 0.4105 * Math.sin(trapezoidMajorOuterAngle1);
                    trapezoidMajorOuterPoint1Y = centerY + SIZE * 0.4105 * Math.cos(trapezoidMajorOuterAngle1);
                    trapezoidMajorOuterPoint2X = centerX + SIZE * 0.4105 * Math.sin(trapezoidMajorOuterAngle2);
                    trapezoidMajorOuterPoint2Y = centerY + SIZE * 0.4105 * Math.cos(trapezoidMajorOuterAngle2);
                    double trapezoidMediumInnerAngle1 = Math.toRadians(angle - 1.0 + START_ANGLE);
                    double trapezoidMediumInnerAngle2 = Math.toRadians(angle + 1.0 + START_ANGLE);
                    double trapezoidMediumOuterAngle1 = Math.toRadians(angle - 0.7 + START_ANGLE);
                    double trapezoidMediumOuterAngle2 = Math.toRadians(angle + 0.7 + START_ANGLE);
                    trapezoidMediumInnerPoint1X = centerX + SIZE * 0.3585 * Math.sin(trapezoidMediumInnerAngle1);
                    trapezoidMediumInnerPoint1Y = centerY + SIZE * 0.3585 * Math.cos(trapezoidMediumInnerAngle1);
                    trapezoidMediumInnerPoint2X = centerX + SIZE * 0.3585 * Math.sin(trapezoidMediumInnerAngle2);
                    trapezoidMediumInnerPoint2Y = centerY + SIZE * 0.3585 * Math.cos(trapezoidMediumInnerAngle2);
                    trapezoidMediumOuterPoint1X = centerX + SIZE * 0.3985 * Math.sin(trapezoidMajorOuterAngle1);
                    trapezoidMediumOuterPoint1Y = centerY + SIZE * 0.3985 * Math.cos(trapezoidMediumOuterAngle1);
                    trapezoidMediumOuterPoint2X = centerX + SIZE * 0.3985 * Math.sin(trapezoidMediumOuterAngle2);
                    trapezoidMediumOuterPoint2Y = centerY + SIZE * 0.3985 * Math.cos(trapezoidMediumOuterAngle2);
                    double trapezoidMinorInnerAngle1 = Math.toRadians(angle - 0.8 + START_ANGLE);
                    double trapezoidMinorInnerAngle2 = Math.toRadians(angle + 0.8 + START_ANGLE);
                    double trapezoidMinorOuterAngle1 = Math.toRadians(angle - 0.6 + START_ANGLE);
                    double trapezoidMinorOuterAngle2 = Math.toRadians(angle + 0.6 + START_ANGLE);
                    trapezoidMinorInnerPoint1X = centerX + SIZE * 0.3585 * Math.sin(trapezoidMinorInnerAngle1);
                    trapezoidMinorInnerPoint1Y = centerY + SIZE * 0.3585 * Math.cos(trapezoidMinorInnerAngle1);
                    trapezoidMinorInnerPoint2X = centerX + SIZE * 0.3585 * Math.sin(trapezoidMinorInnerAngle2);
                    trapezoidMinorInnerPoint2Y = centerY + SIZE * 0.3585 * Math.cos(trapezoidMinorInnerAngle2);
                    trapezoidMinorOuterPoint1X = centerX + SIZE * 0.3975 * Math.sin(trapezoidMinorOuterAngle1);
                    trapezoidMinorOuterPoint1Y = centerY + SIZE * 0.3975 * Math.cos(trapezoidMinorOuterAngle1);
                    trapezoidMinorOuterPoint2X = centerX + SIZE * 0.3975 * Math.sin(trapezoidMinorOuterAngle2);
                    trapezoidMinorOuterPoint2Y = centerY + SIZE * 0.3975 * Math.cos(trapezoidMinorOuterAngle2);
                    triangleMajorInnerPointX = centerX + SIZE * 0.3585 * sinValue;
                    triangleMajorInnerPointY = centerY + SIZE * 0.3585 * cosValue;
                    triangleMajorOuterPointX = centerX + SIZE * 0.4105 * sinValue;
                    triangleMajorOuterPointY = centerY + SIZE * 0.4105 * cosValue;
                    triangleMediumInnerPointX = triangleMajorInnerPointX;
                    triangleMediumInnerPointY = triangleMajorInnerPointY;
                    triangleMediumOuterPointX = centerX + SIZE * 0.4045 * sinValue;
                    triangleMediumOuterPointY = centerY + SIZE * 0.4045 * cosValue;
                    triangleMinorInnerPointX = triangleMajorInnerPointX;
                    triangleMinorInnerPointY = triangleMajorInnerPointY;
                    triangleMinorOuterPointX = centerX + SIZE * 0.3975 * sinValue;
                    yield centerY + SIZE * 0.3975 * cosValue;
                }
                default -> {
                    innerPointX = centerX + SIZE * (0.475 - 0.125 * majorTickMarkLengthFactor) * sinValue;
                    innerPointY = centerY + SIZE * (0.475 - 0.125 * majorTickMarkLengthFactor) * cosValue;
                    innerMediumPointX = centerX + SIZE * (0.475 - 0.125 * mediumTickMarkLengthFactor) * sinValue;
                    innerMediumPointY = centerY + SIZE * (0.475 - 0.125 * mediumTickMarkLengthFactor) * cosValue;
                    innerMinorPointX = centerX + SIZE * (0.475 - 0.125 * minorTickMarkLengthFactor) * sinValue;
                    innerMinorPointY = centerY + SIZE * (0.475 - 0.125 * minorTickMarkLengthFactor) * cosValue;
                    outerPointX = centerX + SIZE * 0.475 * sinValue;
                    outerPointY = centerY + SIZE * 0.475 * cosValue;
                    outerMediumPointX = outerPointX;
                    outerMediumPointY = outerPointY;
                    outerMinorPointX = outerPointX;
                    outerMinorPointY = outerPointY;
                    textPointX = centerX + SIZE * orthTextFactor * sinValue;
                    textPointY = centerY + SIZE * orthTextFactor * cosValue;
                    dotCenterX = centerX + SIZE * 0.4625 * sinValue;
                    dotCenterY = centerY + SIZE * 0.4625 * cosValue;
                    dotMediumCenterX = centerX + SIZE * 0.465625 * sinValue;
                    dotMediumCenterY = centerY + SIZE * 0.465625 * cosValue;
                    dotMinorCenterX = centerX + SIZE * 0.46875 * sinValue;
                    dotMinorCenterY = centerY + SIZE * 0.46875 * cosValue;
                    tickLabelTickMarkX = centerX + SIZE * 0.445 * sinValue;
                    tickLabelTickMarkY = centerY + SIZE * 0.445 * cosValue;
                    double trapezoidMajorInnerAngle1 = Math.toRadians(angle - 0.8 + START_ANGLE);
                    double trapezoidMajorInnerAngle2 = Math.toRadians(angle + 0.8 + START_ANGLE);
                    double trapezoidMajorOuterAngle1 = Math.toRadians(angle - 1.2 + START_ANGLE);
                    double trapezoidMajorOuterAngle2 = Math.toRadians(angle + 1.2 + START_ANGLE);
                    trapezoidMajorInnerPoint1X = centerX + SIZE * 0.423 * Math.sin(trapezoidMajorInnerAngle1);
                    trapezoidMajorInnerPoint1Y = centerY + SIZE * 0.423 * Math.cos(trapezoidMajorInnerAngle1);
                    trapezoidMajorInnerPoint2X = centerX + SIZE * 0.423 * Math.sin(trapezoidMajorInnerAngle2);
                    trapezoidMajorInnerPoint2Y = centerY + SIZE * 0.423 * Math.cos(trapezoidMajorInnerAngle2);
                    trapezoidMajorOuterPoint1X = centerX + SIZE * 0.475 * Math.sin(trapezoidMajorOuterAngle1);
                    trapezoidMajorOuterPoint1Y = centerY + SIZE * 0.475 * Math.cos(trapezoidMajorOuterAngle1);
                    trapezoidMajorOuterPoint2X = centerX + SIZE * 0.475 * Math.sin(trapezoidMajorOuterAngle2);
                    trapezoidMajorOuterPoint2Y = centerY + SIZE * 0.475 * Math.cos(trapezoidMajorOuterAngle2);
                    double trapezoidMediumInnerAngle1 = Math.toRadians(angle - 0.7 + START_ANGLE);
                    double trapezoidMediumInnerAngle2 = Math.toRadians(angle + 0.7 + START_ANGLE);
                    double trapezoidMediumOuterAngle1 = Math.toRadians(angle - 1.0 + START_ANGLE);
                    double trapezoidMediumOuterAngle2 = Math.toRadians(angle + 1.0 + START_ANGLE);
                    trapezoidMediumInnerPoint1X = centerX + SIZE * 0.435 * Math.sin(trapezoidMediumInnerAngle1);
                    trapezoidMediumInnerPoint1Y = centerY + SIZE * 0.435 * Math.cos(trapezoidMediumInnerAngle1);
                    trapezoidMediumInnerPoint2X = centerX + SIZE * 0.435 * Math.sin(trapezoidMediumInnerAngle2);
                    trapezoidMediumInnerPoint2Y = centerY + SIZE * 0.435 * Math.cos(trapezoidMediumInnerAngle2);
                    trapezoidMediumOuterPoint1X = centerX + SIZE * 0.475 * Math.sin(trapezoidMajorOuterAngle1);
                    trapezoidMediumOuterPoint1Y = centerY + SIZE * 0.475 * Math.cos(trapezoidMediumOuterAngle1);
                    trapezoidMediumOuterPoint2X = centerX + SIZE * 0.475 * Math.sin(trapezoidMediumOuterAngle2);
                    trapezoidMediumOuterPoint2Y = centerY + SIZE * 0.475 * Math.cos(trapezoidMediumOuterAngle2);
                    double trapezoidMinorInnerAngle1 = Math.toRadians(angle - 0.6 + START_ANGLE);
                    double trapezoidMinorInnerAngle2 = Math.toRadians(angle + 0.6 + START_ANGLE);
                    double trapezoidMinorOuterAngle1 = Math.toRadians(angle - 0.8 + START_ANGLE);
                    double trapezoidMinorOuterAngle2 = Math.toRadians(angle + 0.8 + START_ANGLE);
                    trapezoidMinorInnerPoint1X = centerX + SIZE * 0.44 * Math.sin(trapezoidMinorInnerAngle1);
                    trapezoidMinorInnerPoint1Y = centerY + SIZE * 0.44 * Math.cos(trapezoidMinorInnerAngle1);
                    trapezoidMinorInnerPoint2X = centerX + SIZE * 0.44 * Math.sin(trapezoidMinorInnerAngle2);
                    trapezoidMinorInnerPoint2Y = centerY + SIZE * 0.44 * Math.cos(trapezoidMinorInnerAngle2);
                    trapezoidMinorOuterPoint1X = centerX + SIZE * 0.475 * Math.sin(trapezoidMinorOuterAngle1);
                    trapezoidMinorOuterPoint1Y = centerY + SIZE * 0.475 * Math.cos(trapezoidMinorOuterAngle1);
                    trapezoidMinorOuterPoint2X = centerX + SIZE * 0.475 * Math.sin(trapezoidMinorOuterAngle2);
                    trapezoidMinorOuterPoint2Y = centerY + SIZE * 0.475 * Math.cos(trapezoidMinorOuterAngle2);
                    triangleMajorInnerPointX = centerX + SIZE * 0.423 * sinValue;
                    triangleMajorInnerPointY = centerY + SIZE * 0.423 * cosValue;
                    triangleMajorOuterPointX = centerX + SIZE * 0.475 * sinValue;
                    triangleMajorOuterPointY = centerY + SIZE * 0.475 * cosValue;
                    triangleMediumInnerPointX = centerX + SIZE * 0.43 * sinValue;
                    triangleMediumInnerPointY = centerY + SIZE * 0.43 * cosValue;
                    triangleMediumOuterPointX = triangleMajorOuterPointX;
                    triangleMediumOuterPointY = triangleMajorOuterPointY;
                    triangleMinorInnerPointX = centerX + SIZE * 0.436 * sinValue;
                    triangleMinorInnerPointY = centerY + SIZE * 0.436 * cosValue;
                    triangleMinorOuterPointX = triangleMajorOuterPointX;
                    yield triangleMajorOuterPointY;
                }
            };
            CTX.setStroke((Paint)tickMarkColor);
            CTX.setFill((Paint)tickMarkColor);
            CTX.setLineCap(StrokeLineCap.BUTT);
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                isNotZero = Double.compare(0.0, counter) != 0;
                TickMarkType tickMarkType = null;
                if (majorTickMarksVisible) {
                    tickMarkType = majorTickMarkType;
                    CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    CTX.setLineWidth(SIZE * (TickMarkType.BOX == tickMarkType || TickMarkType.PILL == tickMarkType ? 0.016 : 0.02 * majorTickMarkWidthFactor));
                    CTX.setLineCap(TickMarkType.PILL == tickMarkType ? StrokeLineCap.ROUND : StrokeLineCap.BUTT);
                } else if (minorTickMarksVisible) {
                    tickMarkType = minorTickMarkType;
                    CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                    CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                    CTX.setLineWidth(SIZE * (TickMarkType.BOX == tickMarkType || TickMarkType.PILL == tickMarkType ? 0.007 : 0.02 * minorTickMarkWidthFactor));
                    CTX.setLineCap(TickMarkType.PILL == tickMarkType ? StrokeLineCap.ROUND : StrokeLineCap.BUTT);
                }
                if (fullRange && !isNotZero) {
                    CTX.setFill((Paint)zeroColor);
                    CTX.setStroke((Paint)zeroColor);
                }
                if (null != tickMarkType) {
                    switch (tickMarkType) {
                        case TRAPEZOID: {
                            if (majorTickMarksVisible) {
                                Helper.drawTrapezoid(CTX, trapezoidMajorInnerPoint1X, trapezoidMajorInnerPoint1Y, trapezoidMajorInnerPoint2X, trapezoidMajorInnerPoint2Y, trapezoidMajorOuterPoint1X, trapezoidMajorOuterPoint1Y, trapezoidMajorOuterPoint2X, trapezoidMajorOuterPoint2Y);
                                break;
                            }
                            if (!minorTickMarksVisible) break;
                            Helper.drawTrapezoid(CTX, trapezoidMinorInnerPoint1X, trapezoidMinorInnerPoint1Y, trapezoidMinorInnerPoint2X, trapezoidMinorInnerPoint2Y, trapezoidMinorOuterPoint1X, trapezoidMinorOuterPoint1Y, trapezoidMinorOuterPoint2X, trapezoidMinorOuterPoint2Y);
                            break;
                        }
                        case TRIANGLE: {
                            if (majorTickMarksVisible) {
                                if (TickLabelLocation.INSIDE == tickLabelLocation) {
                                    Helper.drawTriangle(CTX, triangleMajorInnerPointX, triangleMajorInnerPointY, trapezoidMajorOuterPoint1X, trapezoidMajorOuterPoint1Y, trapezoidMajorOuterPoint2X, trapezoidMajorOuterPoint2Y);
                                    break;
                                }
                                Helper.drawTriangle(CTX, triangleMajorOuterPointX, triangleMajorOuterPointY, trapezoidMajorInnerPoint1X, trapezoidMajorInnerPoint1Y, trapezoidMajorInnerPoint2X, trapezoidMajorInnerPoint2Y);
                                break;
                            }
                            if (!minorTickMarksVisible) break;
                            if (TickLabelLocation.INSIDE == tickLabelLocation) {
                                Helper.drawTriangle(CTX, triangleMinorInnerPointX, triangleMinorInnerPointY, trapezoidMinorOuterPoint1X, trapezoidMinorOuterPoint1Y, trapezoidMinorOuterPoint2X, trapezoidMinorOuterPoint2Y);
                                break;
                            }
                            Helper.drawTriangle(CTX, triangleMinorOuterPointX, triangleMinorOuterPointY, trapezoidMinorInnerPoint1X, trapezoidMinorInnerPoint1Y, trapezoidMinorInnerPoint2X, trapezoidMinorInnerPoint2Y);
                            break;
                        }
                        case DOT: {
                            if (majorTickMarksVisible) {
                                Helper.drawDot(CTX, dotCenterX - majorHalfDotSize, dotCenterY - majorHalfDotSize, majorDotSize);
                                break;
                            }
                            if (!minorTickMarksVisible) break;
                            Helper.drawDot(CTX, dotMinorCenterX - minorHalfDotSize, dotMinorCenterY - minorHalfDotSize, minorDotSize);
                            break;
                        }
                        case TICK_LABEL: {
                            if (!majorTickMarksVisible) break;
                            CTX.save();
                            CTX.translate(tickLabelTickMarkX, tickLabelTickMarkY);
                            Helper.rotateContextForText(CTX, START_ANGLE, angle, tickLabelOrientation);
                            CTX.setFont(isNotZero ? tickMarkFont : tickMarkZeroFont);
                            CTX.setTextAlign(TextAlignment.CENTER);
                            CTX.setTextBaseline(VPos.CENTER);
                            CTX.fillText(String.format(locale, tickLabelFormatString, counter), 0.0, 0.0);
                            CTX.restore();
                            break;
                        }
                        default: {
                            if (majorTickMarksVisible) {
                                Helper.drawLine(CTX, innerPointX, innerPointY, outerPointX, outerPointY);
                                break;
                            }
                            if (!minorTickMarksVisible) break;
                            if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                                Helper.drawLine(CTX, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                                break;
                            }
                            Helper.drawLine(CTX, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                        }
                    }
                }
                if (tickLabelsVisible) {
                    CTX.save();
                    CTX.translate(textPointX, textPointY);
                    Helper.rotateContextForText(CTX, START_ANGLE, angle, tickLabelOrientation);
                    CTX.setFont(isNotZero ? tickLabelFont : tickLabelZeroFont);
                    CTX.setTextAlign(TextAlignment.CENTER);
                    CTX.setTextBaseline(VPos.CENTER);
                    if (!onlyFirstAndLastLabelVisible) {
                        if (isNotZero) {
                            CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : tickLabelColor));
                        } else {
                            CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : (fullRange ? zeroColor : tickLabelColor)));
                        }
                    } else if (Double.compare(counter, MIN_VALUE) == 0 || Double.compare(counter, MAX_VALUE) == 0) {
                        if (isNotZero) {
                            CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : tickLabelColor));
                        } else {
                            CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : (fullRange ? zeroColor : tickLabelColor)));
                        }
                    } else {
                        CTX.setFill((Paint)Color.TRANSPARENT);
                    }
                    if (customTickLabelsEnabled) {
                        if (customTickLabelCounter >= 0) {
                            CTX.fillText(customTickLabels.get(customTickLabelCounter), 0.0, 0.0);
                            ++customTickLabelCounter;
                        }
                        if (customTickLabelCounter > customTickLabels.size() - 1) {
                            customTickLabelCounter = -1;
                        }
                    } else {
                        CTX.fillText(String.format(locale, tickLabelFormatString, counter), 0.0, 0.0);
                    }
                    CTX.restore();
                }
            } else if (mediumTickMarksVisible && (double)Double.compare(minorTickSpaceBD.remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, mediumTickMarkColor) : mediumTickMarkColor));
                CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, mediumTickMarkColor) : mediumTickMarkColor));
                switch (mediumTickMarkType) {
                    case TRAPEZOID: {
                        Helper.drawTrapezoid(CTX, trapezoidMediumInnerPoint1X, trapezoidMediumInnerPoint1Y, trapezoidMediumInnerPoint2X, trapezoidMediumInnerPoint2Y, trapezoidMediumOuterPoint1X, trapezoidMediumOuterPoint1Y, trapezoidMediumOuterPoint2X, trapezoidMediumOuterPoint2Y);
                        break;
                    }
                    case TRIANGLE: {
                        if (TickLabelLocation.INSIDE == tickLabelLocation) {
                            Helper.drawTriangle(CTX, triangleMediumInnerPointX, triangleMediumInnerPointY, trapezoidMediumOuterPoint1X, trapezoidMediumOuterPoint1Y, trapezoidMediumOuterPoint2X, trapezoidMediumOuterPoint2Y);
                            break;
                        }
                        Helper.drawTriangle(CTX, triangleMediumOuterPointX, triangleMediumOuterPointY, trapezoidMediumInnerPoint1X, trapezoidMediumInnerPoint1Y, trapezoidMediumInnerPoint2X, trapezoidMediumInnerPoint2Y);
                        break;
                    }
                    case DOT: {
                        Helper.drawDot(CTX, dotMediumCenterX - mediumHalfDotSize, dotMediumCenterY - mediumHalfDotSize, mediumDotSize);
                        break;
                    }
                    case BOX: {
                        CTX.setLineWidth(SIZE * 0.009);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMediumPointX, innerMediumPointY, outerPointX, outerPointY);
                        break;
                    }
                    case PILL: {
                        CTX.setLineCap(StrokeLineCap.ROUND);
                        CTX.setLineWidth(SIZE * 0.009);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMediumPointX, innerMediumPointY, outerPointX, outerPointY);
                        break;
                    }
                    default: {
                        CTX.setLineWidth(SIZE * 0.02 * mediumTickMarkWidthFactor);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMediumPointX, innerMediumPointY, outerPointX, outerPointY);
                        break;
                    }
                }
            } else if (minorTickMarksVisible) {
                boolean drawMinorTicks = false;
                if (minorTickSpaceBD.stripTrailingZeros().scale() <= 0) {
                    if (Double.compare(counterBD.remainder(minorTickSpaceBD).doubleValue(), 0.0) == 0) {
                        drawMinorTicks = true;
                    }
                } else {
                    drawMinorTicks = true;
                }
                if (drawMinorTicks && TickMarkType.TICK_LABEL != majorTickMarkType) {
                    CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                    CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                    switch (minorTickMarkType) {
                        case TRAPEZOID: {
                            Helper.drawTrapezoid(CTX, trapezoidMinorInnerPoint1X, trapezoidMinorInnerPoint1Y, trapezoidMinorInnerPoint2X, trapezoidMinorInnerPoint2Y, trapezoidMinorOuterPoint1X, trapezoidMinorOuterPoint1Y, trapezoidMinorOuterPoint2X, trapezoidMinorOuterPoint2Y);
                            break;
                        }
                        case TRIANGLE: {
                            if (TickLabelLocation.INSIDE == tickLabelLocation) {
                                Helper.drawTriangle(CTX, triangleMinorInnerPointX, triangleMinorInnerPointY, trapezoidMinorOuterPoint1X, trapezoidMinorOuterPoint1Y, trapezoidMinorOuterPoint2X, trapezoidMinorOuterPoint2Y);
                                break;
                            }
                            Helper.drawTriangle(CTX, triangleMinorOuterPointX, triangleMinorOuterPointY, trapezoidMinorInnerPoint1X, trapezoidMinorInnerPoint1Y, trapezoidMinorInnerPoint2X, trapezoidMinorInnerPoint2Y);
                            break;
                        }
                        case DOT: {
                            Helper.drawDot(CTX, dotMinorCenterX - minorHalfDotSize, dotMinorCenterY - minorHalfDotSize, minorDotSize);
                            break;
                        }
                        case BOX: {
                            CTX.setLineWidth(SIZE * 0.007);
                            if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                                Helper.drawLine(CTX, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                                break;
                            }
                            Helper.drawLine(CTX, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                            break;
                        }
                        case PILL: {
                            CTX.setLineCap(StrokeLineCap.ROUND);
                            CTX.setLineWidth(SIZE * 0.007);
                            if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                                Helper.drawLine(CTX, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                                break;
                            }
                            Helper.drawLine(CTX, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                            break;
                        }
                        default: {
                            CTX.setLineWidth(SIZE * 0.02 * minorTickMarkWidthFactor);
                            if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                                Helper.drawLine(CTX, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                                break;
                            }
                            Helper.drawLine(CTX, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                        }
                    }
                }
            }
            counterBD = counterBD.add(minorTickSpaceBD);
            counter = counterBD.doubleValue();
            if (counter > MAX_VALUE) break;
            angle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? angle - tmpAngleStep : angle + tmpAngleStep;
            i -= tmpStep;
        }
    }

    public static final Image createNoiseImage(double WIDTH, double HEIGHT, Color DARK_COLOR, Color BRIGHT_COLOR, double ALPHA_VARIATION_IN_PERCENT) {
        if (Double.compare(WIDTH, 0.0) <= 0 || Double.compare(HEIGHT, 0.0) <= 0) {
            return null;
        }
        int width = (int)WIDTH;
        int height = (int)HEIGHT;
        double alphaVariationInPercent = Helper.clamp(0.0, 100.0, ALPHA_VARIATION_IN_PERCENT);
        WritableImage IMAGE = new WritableImage(width, height);
        PixelWriter PIXEL_WRITER = IMAGE.getPixelWriter();
        Random BW_RND = new Random();
        Random ALPHA_RND = new Random();
        double ALPHA_START = alphaVariationInPercent / 100.0 / 2.0;
        double ALPHA_VARIATION = alphaVariationInPercent / 100.0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color NOISE_COLOR = BW_RND.nextBoolean() ? BRIGHT_COLOR : DARK_COLOR;
                double NOISE_ALPHA = Helper.clamp(0.0, 1.0, ALPHA_START + ALPHA_RND.nextDouble() * ALPHA_VARIATION);
                PIXEL_WRITER.setColor(x, y, Color.color((double)NOISE_COLOR.getRed(), (double)NOISE_COLOR.getGreen(), (double)NOISE_COLOR.getBlue(), (double)NOISE_ALPHA));
            }
        }
        return IMAGE;
    }

    public static final void drawTimeSections(Clock CLOCK, GraphicsContext CTX, List<TimeSection> SECTIONS, double SIZE, double XY_INSIDE, double XY_OUTSIDE, double WH_INSIDE, double WH_OUTSIDE, double LINE_WIDTH) {
        if (SECTIONS.isEmpty()) {
            return;
        }
        TickLabelLocation tickLabelLocation = CLOCK.getTickLabelLocation();
        ZonedDateTime time = CLOCK.getTime();
        boolean isAM = time.get(ChronoField.AMPM_OF_DAY) == 0;
        double xy = TickLabelLocation.INSIDE == tickLabelLocation ? XY_INSIDE * SIZE : XY_OUTSIDE * SIZE;
        double wh = TickLabelLocation.INSIDE == tickLabelLocation ? WH_INSIDE * SIZE : WH_OUTSIDE * SIZE;
        double offset = 90.0;
        int listSize = SECTIONS.size();
        double angleStep = 6.0;
        boolean highlightSections = CLOCK.isHighlightSections();
        for (int i = 0; i < listSize; ++i) {
            boolean draw;
            boolean isStopAM;
            TimeSection section = SECTIONS.get(i);
            LocalTime start = section.getStart();
            LocalTime stop = section.getStop();
            boolean isStartAM = start.get(ChronoField.AMPM_OF_DAY) == 0;
            boolean bl = isStopAM = stop.get(ChronoField.AMPM_OF_DAY) == 0;
            boolean bl2 = isAM ? isStartAM || isStopAM : (draw = !isStartAM || !isStopAM);
            if (!draw) continue;
            double sectionStartAngle = ((double)(start.getHour() % 12) * 5.0 + (double)start.getMinute() / 12.0 + (double)start.getSecond() / 300.0) * angleStep + 180.0;
            double sectionAngleExtend = ((double)((stop.getHour() - start.getHour()) % 12) * 5.0 + (double)(stop.getMinute() - start.getMinute()) / 12.0 + (double)(stop.getSecond() - start.getSecond()) / 300.0) * angleStep;
            if (start.getHour() > stop.getHour()) {
                sectionAngleExtend = 360.0 - Math.abs(sectionAngleExtend);
            }
            CTX.save();
            if (highlightSections) {
                CTX.setStroke((Paint)(section.contains(time.toLocalTime()) ? section.getHighlightColor() : section.getColor()));
            } else {
                CTX.setStroke((Paint)section.getColor());
            }
            CTX.setLineWidth(SIZE * LINE_WIDTH);
            CTX.setLineCap(StrokeLineCap.BUTT);
            CTX.strokeArc(xy, xy, wh, wh, -(offset + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
            CTX.restore();
        }
    }

    public static final void drawTimeAreas(Clock CLOCK, GraphicsContext CTX, List<TimeSection> AREAS, double SIZE, double XY_INSIDE, double XY_OUTSIDE, double WH_INSIDE, double WH_OUTSIDE) {
        if (AREAS.isEmpty()) {
            return;
        }
        TickLabelLocation tickLabelLocation = CLOCK.getTickLabelLocation();
        ZonedDateTime time = CLOCK.getTime();
        boolean isAM = time.get(ChronoField.AMPM_OF_DAY) == 0;
        double xy = TickLabelLocation.OUTSIDE == tickLabelLocation ? XY_OUTSIDE * SIZE : XY_INSIDE * SIZE;
        double wh = TickLabelLocation.OUTSIDE == tickLabelLocation ? WH_OUTSIDE * SIZE : WH_INSIDE * SIZE;
        double offset = 90.0;
        double angleStep = 6.0;
        int listSize = AREAS.size();
        boolean highlightAreas = CLOCK.isHighlightAreas();
        for (int i = 0; i < listSize; ++i) {
            boolean draw;
            boolean isStopAM;
            TimeSection area = AREAS.get(i);
            LocalTime start = area.getStart();
            LocalTime stop = area.getStop();
            boolean isStartAM = start.get(ChronoField.AMPM_OF_DAY) == 0;
            boolean bl = isStopAM = stop.get(ChronoField.AMPM_OF_DAY) == 0;
            boolean bl2 = isAM ? isStartAM || isStopAM : (draw = !isStartAM || !isStopAM);
            if (!draw) continue;
            double areaStartAngle = ((double)(start.getHour() % 12) * 5.0 + (double)start.getMinute() / 12.0 + (double)start.getSecond() / 300.0) * angleStep + 180.0;
            double areaAngleExtend = ((double)((stop.getHour() - start.getHour()) % 12) * 5.0 + (double)(stop.getMinute() - start.getMinute()) / 12.0 + (double)(stop.getSecond() - start.getSecond()) / 300.0) * angleStep;
            if (start.getHour() > stop.getHour()) {
                areaAngleExtend = 360.0 - Math.abs(areaAngleExtend);
            }
            CTX.save();
            if (highlightAreas) {
                CTX.setFill((Paint)(area.contains(time.toLocalTime()) ? area.getHighlightColor() : area.getColor()));
            } else {
                CTX.setFill((Paint)area.getColor());
            }
            CTX.fillArc(xy, xy, wh, wh, -(offset + areaStartAngle), -areaAngleExtend, ArcType.ROUND);
            CTX.restore();
        }
    }

    public static final void drawAlarms(Clock CLOCK, double SIZE, double ALARM_MARKER_SIZE, double ALARM_MARKER_RADIUS, Map<Alarm, Circle> ALARM_MAP, DateTimeFormatter DATE_TIME_FORMATTER, ZonedDateTime TIME) {
        if (CLOCK.isAlarmsVisible()) {
            double alarmSize = ALARM_MARKER_SIZE * SIZE;
            double center = SIZE * 0.5;
            double angleStep = 6.0;
            for (Map.Entry<Alarm, Circle> entry : ALARM_MAP.entrySet()) {
                Alarm alarm = entry.getKey();
                ZonedDateTime alarmTime = alarm.getTime();
                double alarmAngle = ((double)alarmTime.getMinute() + (double)alarmTime.getSecond() / 60.0) * angleStep + 180.0;
                double sinValue = Math.sin(Math.toRadians(-alarmAngle));
                double cosValue = Math.cos(Math.toRadians(-alarmAngle));
                Color alarmColor = alarm.isArmed() ? alarm.getColor() : INACTIVE_ALARM_COLOR;
                Circle dot = entry.getValue();
                dot.setRadius(alarmSize);
                dot.setCenterX(center + SIZE * ALARM_MARKER_RADIUS * sinValue);
                dot.setCenterY(center + SIZE * ALARM_MARKER_RADIUS * cosValue);
                dot.setFill((Paint)alarmColor);
                dot.setStroke((Paint)alarmColor.darker());
                dot.setPickOnBounds(false);
                dot.setOnMousePressed(e -> alarm.fireAlarmMarkerEvent(alarm.ALARM_MARKER_PRESSED_EVENT));
                dot.setOnMouseReleased(e -> alarm.fireAlarmMarkerEvent(alarm.ALARM_MARKER_RELEASED_EVENT));
                if (alarmTime.getDayOfMonth() == TIME.getDayOfMonth() && alarmTime.getMonthValue() == TIME.getMonthValue() && alarmTime.getYear() == TIME.getYear() && alarmTime.getHour() == TIME.getHour() && alarmTime.getMinute() >= TIME.getMinute()) {
                    dot.setManaged(true);
                    dot.setVisible(true);
                } else {
                    dot.setManaged(false);
                    dot.setVisible(false);
                }
                Tooltip alarmTooltip = alarm.getText().isEmpty() ? new Tooltip(DATE_TIME_FORMATTER.format(alarm.getTime())) : new Tooltip(alarm.getText() + "\n" + DATE_TIME_FORMATTER.format(alarm.getTime()));
                alarmTooltip.setTextAlignment(TextAlignment.CENTER);
                Tooltip.install((Node)dot, (Tooltip)alarmTooltip);
            }
        }
    }

    public static final String formatNumber(Gauge GAUGE, double VALUE) {
        return Helper.formatNumber(GAUGE.getLocale(), GAUGE.getFormatString(), GAUGE.getDecimals(), VALUE);
    }

    public static final String formatNumber(Locale LOCALE, String FORMAT_STRING, int DECIMALS, double VALUE) {
        double value = VALUE;
        if (value > 0.0) {
            value = Math.floor(value * Math.pow(10.0, DECIMALS)) / Math.pow(10.0, DECIMALS);
        } else if (value < 0.0) {
            value = Math.ceil(value * Math.pow(10.0, DECIMALS)) / Math.pow(10.0, DECIMALS);
        }
        return String.format(LOCALE, FORMAT_STRING, value);
    }

    public static final String formatNumber(Locale LOCALE, double MIN_VALUE, double MAX_VALUE, int DECIMALS, double VALUE) {
        StringBuilder sb = new StringBuilder("%.").append(DECIMALS).append("f");
        String f = sb.toString();
        int minLength = String.format(Locale.US, f, MIN_VALUE).length();
        int maxLength = String.format(Locale.US, f, MAX_VALUE).length();
        int length = Math.max(minLength, maxLength);
        StringBuilder formatStringBuilder = new StringBuilder("%").append(length).append(".").append(DECIMALS).append("f");
        String formatString = formatStringBuilder.toString();
        double value = VALUE;
        if (value > 0.0) {
            value = Math.floor(VALUE * Math.pow(10.0, DECIMALS)) / Math.pow(10.0, DECIMALS);
        } else if (value < 0.0) {
            value = Math.ceil(VALUE * Math.pow(10.0, DECIMALS)) / Math.pow(10.0, DECIMALS);
        }
        return String.format(LOCALE, formatString, value);
    }
}

