/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public class AirCompass
extends AbstractRadial {
    private boolean rotateTickmarks = true;
    private double oldValue = 0.0;
    private double rotationAngle = 0.0;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage frameImage;
    private BufferedImage backgroundImage;
    private BufferedImage tickmarksImage;
    private BufferedImage planeImage;
    private BufferedImage foregroundImage;
    private BufferedImage disabledImage;
    private Timeline timeline = new Timeline((Object)this);

    public AirCompass() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setLcdVisible(true);
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.frameImage != null) {
            this.frameImage.flush();
        }
        this.frameImage = this.create_FRAME_Image(n4);
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(n4);
        if (this.tickmarksImage != null) {
            this.tickmarksImage.flush();
        }
        this.tickmarksImage = this.create_TICKMARKS_Image(n4);
        if (this.planeImage != null) {
            this.planeImage.flush();
        }
        this.planeImage = this.create_AIRPLANE_Image(n4);
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        switch (this.getFrameType()) {
            case SQUARE: {
                this.foregroundImage = FOREGROUND_FACTORY.createLinearForeground(n4, n4, false);
                break;
            }
            default: {
                this.foregroundImage = FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType());
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterY());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.isFrameVisible()) {
            graphics2D.drawImage((Image)this.frameImage, 0, 0, null);
        }
        if (this.isBackgroundVisible()) {
            graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        if (this.rotateTickmarks) {
            graphics2D.rotate(-this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
            graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        } else {
            graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        }
        if (!this.rotateTickmarks) {
            graphics2D.rotate(this.rotationAngle, this.CENTER.getX(), this.CENTER.getY());
            graphics2D.drawImage((Image)this.planeImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        } else {
            graphics2D.drawImage((Image)this.planeImage, 0, 0, null);
        }
        if (this.isForegroundVisible()) {
            graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
        }
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public double getValue() {
        return this.oldValue;
    }

    @Override
    public void setValue(double d) {
        this.rotationAngle = Math.PI / 180 * (d % 360.0);
        this.fireStateChanged();
        this.oldValue = d;
        if (this.isValueCoupled()) {
            this.setLcdValue(d);
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setValueAnimated(double d) {
        if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.timeline.abort();
        }
        this.timeline = new Timeline((Object)this);
        this.timeline.addPropertyToInterpolate("value", (Object)this.oldValue, (Object)d);
        this.timeline.setEase((TimelineEase)new Spline(0.5f));
        this.timeline.setDuration(800L);
        this.timeline.play();
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return 10.0;
    }

    public boolean isRotateTickmarks() {
        return this.rotateTickmarks;
    }

    public void setRotateTickmarks(boolean bl) {
        this.rotateTickmarks = bl;
        this.setValue(0.0);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double(this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().x, this.getInnerBounds().getCenterX() + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getInnerBounds();
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_TICKMARKS_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int n2 = bufferedImage.getWidth();
        AffineTransform affineTransform = graphics2D.getTransform();
        BasicStroke basicStroke = new BasicStroke(0.01f * (float)n2, 1, 2);
        Font font = new Font("Arial", 0, (int)(0.073f * (float)n2));
        Font font2 = new Font("Arial", 0, (int)(0.075f * (float)n2));
        float f = 0.1f * (float)n2;
        float f2 = 0.039f * (float)n2;
        float f3 = 0.04f * (float)n2;
        float f4 = (float)n2 * 0.39f;
        this.CENTER.setLocation((float)n2 / 2.0f, (float)n2 / 2.0f);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (this.isTickmarkColorFromThemeEnabled()) {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
        } else {
            graphics2D.setColor(this.getTickmarkColor());
        }
        for (double d3 = Math.PI * 2; d3 >= 0.0; d3 -= 0.08726646259971647) {
            Line2D.Double double_4;
            graphics2D.setStroke(basicStroke);
            d = Math.sin(d3 - Math.PI);
            d2 = Math.cos(d3 - Math.PI);
            if (n4 == 1) {
                graphics2D.setStroke(basicStroke);
                ((Point2D)double_).setLocation(this.CENTER.getX() + (double)(f4 - f3) * d, this.CENTER.getY() + (double)(f4 - f3) * d2);
                ((Point2D)double_2).setLocation(this.CENTER.getX() + (double)(f4 - f2) * d, this.CENTER.getY() + (double)(f4 - f2) * d2);
                double_4 = new Line2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY());
                graphics2D.draw(double_4);
                n4 = 0;
            }
            if (n3 == 2) {
                graphics2D.setStroke(basicStroke);
                ((Point2D)double_).setLocation(this.CENTER.getX() + (double)(f4 - f3) * d, this.CENTER.getY() + (double)(f4 - f3) * d2);
                ((Point2D)double_2).setLocation(this.CENTER.getX() + (double)f4 * d, this.CENTER.getY() + (double)f4 * d2);
                double_4 = new Line2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY());
                graphics2D.draw(double_4);
                n3 = 0;
            }
            ((Point2D)double_3).setLocation(this.CENTER.getX() + (double)(f4 - f) * d, this.CENTER.getY() + (double)(f4 - f) * d2);
            if (n5 != 72 && n5 % 6 == 0) {
                Color color;
                if (n5 / 2 == 0) {
                    graphics2D.setFont(font2);
                    color = graphics2D.getColor();
                    graphics2D.setColor(this.getPointerColor().LIGHT);
                    graphics2D.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "N", (int)((Point2D)double_3).getX(), (int)((Point2D)double_3).getY(), Math.PI * 2 - d3));
                    graphics2D.setColor(color);
                } else if (n5 / 2 == 9) {
                    graphics2D.setFont(font2);
                    color = graphics2D.getColor();
                    graphics2D.setColor(this.getPointerColor().LIGHT);
                    graphics2D.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "E", (int)((Point2D)double_3).getX(), (int)((Point2D)double_3).getY(), Math.PI * 2 - d3));
                    graphics2D.setColor(color);
                } else if (n5 / 2 == 18) {
                    graphics2D.setFont(font2);
                    color = graphics2D.getColor();
                    graphics2D.setColor(this.getPointerColor().LIGHT);
                    graphics2D.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "S", (int)((Point2D)double_3).getX(), (int)((Point2D)double_3).getY(), Math.PI * 2 - d3));
                    graphics2D.setColor(color);
                } else if (n5 / 2 == 27) {
                    graphics2D.setFont(font2);
                    color = graphics2D.getColor();
                    graphics2D.setColor(this.getPointerColor().LIGHT);
                    graphics2D.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "W", (int)((Point2D)double_3).getX(), (int)((Point2D)double_3).getY(), Math.PI * 2 - d3));
                    graphics2D.setColor(color);
                } else {
                    graphics2D.setFont(font);
                    graphics2D.rotate(Math.toRadians(0.0), this.CENTER.getX(), this.CENTER.getY());
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf(n5 / 2), (int)((Point2D)double_3).getX(), (int)((Point2D)double_3).getY(), Math.PI * 2 - d3));
                }
            }
            graphics2D.setTransform(affineTransform);
            ++n4;
            ++n3;
            ++n5;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_AIRPLANE_Image(int n) {
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage bufferedImage = UTIL.createImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Point2D.Double double_2 = new Point2D.Double(0.5 * (double)n2, 0.5 * (double)n3);
        float[] fArray = new float[]{0.0f, 0.41f, 0.705f, 1.0f};
        Color[] colorArray = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 30), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_2, (float)(0.4158878326 * (double)n2), fArray, colorArray);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_3 = new Ellipse2D.Double((double)n2 * 0.44392523169517517, (double)n3 * 0.44392523169517517, (double)n2 * 0.11214950680732727, (double)n3 * 0.11214950680732727);
        Point2D.Double double_4 = new Point2D.Double(0.0, double_3.getBounds2D().getMinY());
        Point2D.Double double_5 = new Point2D.Double(0.0, double_3.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.08411215245723724, (double)n3 * 0.08411215245723724, (double)n2 * 0.8317756652832031, (double)n3 * 0.8317756652832031);
        Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * 0.44859811663627625, (double)n3 * 0.44859811663627625, (double)n2 * 0.10280373692512512, (double)n3 * 0.10280373692512512);
        Point2D.Double double_8 = new Point2D.Double(0.0, double_6.getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, double_6.getBounds2D().getMaxY());
        float[] fArray3 = new float[]{0.0f, 0.35f, 1.0f};
        Color[] colorArray3 = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_8, double_9, fArray3, colorArray3);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_7);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2523364485981308);
        generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2523364485981308, (double)n2 * 0.4766355140186916, (double)n3 * 0.2850467289719626, (double)n2 * 0.4719626168224299, (double)n3 * 0.3130841121495327);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.32710280373831774, (double)n2 * 0.4672897196261682, (double)n3 * 0.38317757009345793, (double)n2 * 0.4672897196261682, (double)n3 * 0.38317757009345793);
        generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.5186915887850467);
        generalPath.lineTo((double)n2 * 0.32710280373831774, (double)n3 * 0.5700934579439252);
        generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48598130841121495);
        generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.6121495327102804);
        generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.6635514018691588);
        generalPath.lineTo((double)n2 * 0.4252336448598131, (double)n3 * 0.7149532710280374);
        generalPath.lineTo((double)n2 * 0.48130841121495327, (double)n3 * 0.6822429906542056);
        generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.6962616822429907);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.6962616822429907);
        generalPath.lineTo((double)n2 * 0.5186915887850467, (double)n3 * 0.6822429906542056);
        generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.7149532710280374);
        generalPath.lineTo((double)n2 * 0.5747663551401869, (double)n3 * 0.6635514018691588);
        generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.6121495327102804);
        generalPath.lineTo((double)n2 * 0.5280373831775701, (double)n3 * 0.48598130841121495);
        generalPath.lineTo((double)n2 * 0.6728971962616822, (double)n3 * 0.5700934579439252);
        generalPath.lineTo((double)n2 * 0.6728971962616822, (double)n3 * 0.5186915887850467);
        generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.38317757009345793);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.38317757009345793, (double)n2 * 0.5327102803738317, (double)n3 * 0.32710280373831774, (double)n2 * 0.5280373831775701, (double)n3 * 0.3130841121495327);
        generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.2897196261682243, (double)n2 * 0.5046728971962616, (double)n3 * 0.2570093457943925, (double)n2 * 0.5046728971962616, (double)n3 * 0.2523364485981308);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.2523364485981308, (double)n2 * 0.5046728971962616, (double)n3 * 0.2336448598130841, (double)n2 * 0.5046728971962616, (double)n3 * 0.2336448598130841);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.16822429906542055);
        generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2336448598130841);
        generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.2336448598130841, (double)n2 * 0.4953271028037383, (double)n3 * 0.2523364485981308, (double)n2 * 0.4953271028037383, (double)n3 * 0.2523364485981308);
        generalPath.closePath();
        graphics2D.setColor(this.getPointerColor().MEDIUM);
        graphics2D.setStroke(new BasicStroke(1.5f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.translate(1, 2);
        graphics2D.setStroke(new BasicStroke(2.0f, 0, 0));
        graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "AirCompass";
    }
}

